/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.client.gui;

import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.client.gui.GuiContainerElements;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementBook;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementTextField;
import com.xcompwiz.mystcraft.inventory.IBookContainer;
import com.xcompwiz.mystcraft.item.ItemAgebook;
import com.xcompwiz.mystcraft.item.ItemLinkbook;
import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.network.packet.MPacketGuiMessage;
import java.awt.Color;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import thefloydman.moremystcraft.inventory.ContainerNexusController;
import thefloydman.moremystcraft.tileentity.TileEntityNexusController;

public class GuiNexusController
extends GuiContainerElements {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("moremystcraft", "textures/gui/nexus_controller.png");
    private int windowCenterX = 0;
    private int windowCenterY = 0;
    private int guiX = 0;
    private int guiY = 0;
    private InventoryPlayer playerInv;
    private EntityPlayer player;
    private ContainerNexusController container;
    private TileEntityNexusController tileEntity;
    private int firstDisplayedBook;
    private int selectedCell;
    private int selectedBook;
    private float scrollFraction;
    private boolean scrollbarEnabled;
    private int scrollBlockX = 0;
    private int scrollBlockY = 0;
    private int scrollBlockWidth;
    private int scrollBlockHeight;
    private int scrollbarHeight;
    private boolean scrollBlockBeingDragged;
    private GuiElementTextField searchBar;
    private int[] displayedBooks;
    private GuiElementArea scrollDetectionArea;
    private GuiElementBook bookElement;

    public GuiNexusController(ContainerNexusController container, InventoryPlayer playerInv) {
        super((Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 218;
        this.playerInv = playerInv;
        this.container = container;
        this.tileEntity = container.tileEntity;
        this.firstDisplayedBook = 2;
        this.selectedCell = -1;
        this.container.selectedBook = -1;
        this.scrollFraction = 0.0f;
        this.scrollBlockWidth = 12;
        this.scrollBlockHeight = 15;
        this.scrollbarHeight = 52;
        this.scrollBlockBeingDragged = false;
        this.displayedBooks = new int[]{-1, -1, -1, -1};
    }

    public void validate() {
        super.validate();
        Keyboard.enableRepeatEvents((boolean)true);
        TextBoxHandler handler = new TextBoxHandler();
        this.searchBar = new GuiElementTextField((GuiElementTextField.IGuiTextProvider)handler, (GuiElementTextField.IGuiOnTextChange)handler, "query", 7, 65, 162, 12);
        this.searchBar.setMaxLength(32);
        this.searchBar.setFocused(true);
        this.addElement((GuiElement)this.searchBar);
        this.bookElement = new GuiElementBook((IBookContainer)this.container, (GuiElementBook.IGuiOnLinkHandler)new LinkHandler(), 43, 81, 90, 50);
        this.addElement((GuiElement)this.bookElement);
        this.scrollDetectionArea = new GuiElementArea(7, 7, 144, 54);
        this.addElement(this.scrollDetectionArea);
    }

    public boolean func_73868_f() {
        return true;
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void _drawBackgroundLayer(int mouseX, int mouseY, float f) {
        int textureX;
        this.windowCenterX = this.field_146294_l / 2;
        this.windowCenterY = this.field_146295_m / 2;
        this.guiX = this.windowCenterX - this.field_146999_f / 2;
        this.guiY = this.windowCenterY - this.field_147000_g / 2;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.guiX, this.guiY, 0, 0, this.field_146999_f, this.field_147000_g);
        int index = (int)Math.rint((float)(this.tileEntity.getFilteredBookList().size() - 4) * this.scrollFraction);
        for (int i = 0; i < 4 && i < this.tileEntity.getFilteredBookList().size(); ++i) {
            this.displayedBooks[i] = this.tileEntity.getFilteredBookList().get(index + i);
        }
        int listWidth = 142;
        int listHeight = 13;
        int listX = this.guiX + 8;
        int listY = this.guiY + 8;
        int i = 0;
        while (i < 4 && i < this.tileEntity.getFilteredBookList().size()) {
            if (this.tileEntity.func_70301_a(this.displayedBooks[i]).func_77973_b() instanceof ItemLinking) {
                int textureY = this.container.selectedBook == this.displayedBooks[i] ? 231 : 218;
                float red = 1.0f;
                float green = 1.0f;
                float blue = 1.0f;
                if (this.tileEntity.func_70301_a(this.displayedBooks[i]).func_77973_b() instanceof ItemAgebook) {
                    red = 0.94509804f;
                    green = 0.84313726f;
                    blue = 0.36862746f;
                } else if (this.tileEntity.func_70301_a(this.displayedBooks[i]).func_77973_b() instanceof ItemLinkbook) {
                    red = 0.21568628f;
                    green = 0.79607844f;
                    blue = 0.30980393f;
                }
                GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
                this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
                this.func_73729_b(listX, listY, 0, textureY, listWidth, listHeight);
                ILinkInfo info = ((ItemLinking)this.tileEntity.func_70301_a(this.displayedBooks[i]).func_77973_b()).getLinkInfo(this.tileEntity.func_70301_a(this.displayedBooks[i]));
                if (info != null) {
                    this.field_146289_q.func_78276_b(info.getDisplayName(), listX + 2, listY + 3, Color.BLACK.getRGB());
                }
            }
            ++i;
            listY += listHeight;
        }
        this.scrollbarEnabled = this.tileEntity.getFilteredBookList().size() > 4;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.scrollBlockX = this.guiX + 156;
        this.scrollBlockY = this.guiY + 8;
        if (this.scrollbarEnabled) {
            if (this.scrollBlockBeingDragged) {
                this.scrollBlockY = mouseY - 7;
                if (this.scrollBlockY < this.guiY + 8) {
                    this.scrollBlockY = this.guiY + 8;
                } else if (this.scrollBlockY > this.guiY + 8 + this.scrollbarHeight - this.scrollBlockHeight) {
                    this.scrollBlockY = this.guiY + 8 + this.scrollbarHeight - this.scrollBlockHeight;
                }
            } else {
                this.scrollBlockY = (int)((double)this.scrollBlockY + Math.rint((float)(this.scrollbarHeight - this.scrollBlockHeight) * this.scrollFraction));
            }
            textureX = 176;
            this.func_73729_b(this.scrollBlockX, this.scrollBlockY, textureX, 0, this.scrollBlockWidth, this.scrollBlockHeight);
        } else {
            textureX = 188;
            this.func_73729_b(this.scrollBlockX, this.scrollBlockY, textureX, 0, this.scrollBlockWidth, this.scrollBlockHeight);
        }
    }

    protected void _drawForegroundLayer(int mouseX, int mouseY) {
    }

    protected void _onMouseUp(int mouseX, int mouseY, int clicked_id, boolean eaten) {
        super._onMouseUp(mouseX, mouseY, clicked_id, eaten);
        this.searchBar.setFocused(true);
        this.scrollBlockBeingDragged = false;
        this.selectedCell = this.determineClickedCell(mouseX, mouseY);
        if (this.selectedCell < 0) {
            return;
        }
        int n = this.container.selectedBook = this.displayedBooks[this.selectedCell] < this.tileEntity.func_70302_i_() ? this.displayedBooks[this.selectedCell] : -1;
        if (this.container.selectedBook > 1 || this.container.selectedBook == -1) {
            this.container.func_75140_a(this.player, this.container.selectedBook);
            this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, this.container.selectedBook);
        }
        this.searchBar.setFocused(true);
    }

    protected int determineClickedCell(int mouseX, int mouseY) {
        int listWidth = 142;
        int listHeight = 13;
        int listX = this.guiX + 8;
        int listY = this.guiY + 8;
        int i = 0;
        while (i < 4) {
            if (mouseX >= listX && mouseX <= listX + listWidth && mouseY >= listY && mouseY <= listY + listHeight) {
                return i;
            }
            ++i;
            listY += listHeight;
        }
        return -1;
    }

    protected void _onMouseDrag(int mouseX, int mouseY, int clicked_id, long lastclick, boolean eaten) {
        if (this.mouseOnScrollBlock(mouseX, mouseY) && this.scrollbarEnabled) {
            this.scrollBlockBeingDragged = true;
            float localY = mouseY - 8 - this.scrollBlockHeight / 2 - this.guiY;
            this.scrollFraction = MathHelper.func_76131_a((float)(localY / (float)(this.scrollbarHeight - this.scrollBlockHeight)), (float)0.0f, (float)1.0f);
        }
    }

    protected boolean mouseOnScrollBlock(int mouseX, int mouseY) {
        return mouseX >= this.scrollBlockX && mouseX <= this.scrollBlockX + this.scrollBlockWidth && mouseY >= this.scrollBlockY && mouseY <= this.scrollBlockY + this.scrollBlockHeight;
    }

    protected void _keyTyped(char c, int i, boolean eaten) {
        this.scrollFraction = 0.0f;
        super._keyTyped(c, i, eaten);
    }

    private class GuiElementArea
    extends GuiElement {
        public GuiElementArea(int guiLeft, int guiTop, int xSize, int ySize) {
            super(guiLeft, guiTop, xSize, ySize);
        }

        public void _handleMouseInput() {
            int input = Mouse.getEventDWheel();
            if (GuiNexusController.this.scrollbarEnabled && input != 0) {
                input = input > 0 ? 1 : -1;
                float outsideFraction = 1.0f / ((float)GuiNexusController.this.tileEntity.getFilteredBookList().size() - 3.0f);
                float insideFraction = (outsideFraction + 2.0f * outsideFraction) / 2.0f;
                if (GuiNexusController.this.scrollFraction == 0.0f || GuiNexusController.this.scrollFraction == 1.0f) {
                    GuiNexusController guiNexusController = GuiNexusController.this;
                    guiNexusController.scrollFraction = guiNexusController.scrollFraction - (float)input * insideFraction;
                } else {
                    GuiNexusController guiNexusController = GuiNexusController.this;
                    guiNexusController.scrollFraction = guiNexusController.scrollFraction - (float)input * outsideFraction;
                }
                if (GuiNexusController.this.scrollFraction > outsideFraction * (float)(GuiNexusController.this.tileEntity.getFilteredBookList().size() - 4)) {
                    GuiNexusController.this.scrollFraction = 1.0f;
                }
                if (GuiNexusController.this.scrollFraction < outsideFraction) {
                    GuiNexusController.this.scrollFraction = 0.0f;
                }
            }
        }

        protected boolean _onKeyPress(char c, int i) {
            GuiNexusController.this.scrollFraction = 0.0f;
            return false;
        }
    }

    public class TextBoxHandler
    implements GuiElementTextField.IGuiTextProvider,
    GuiElementTextField.IGuiOnTextChange {
        public String getText(GuiElementTextField caller) {
            return GuiNexusController.this.container.getQuery();
        }

        public void onTextChange(GuiElementTextField caller, String text) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("query", text);
            MystcraftPacketHandler.CHANNEL.sendToServer((IMessage)new MPacketGuiMessage(((GuiNexusController)GuiNexusController.this).container.field_75152_c, nbt));
            GuiNexusController.this.container.processMessage((EntityPlayer)GuiNexusController.this.field_146297_k.field_71439_g, nbt);
        }
    }

    public class LinkHandler
    implements GuiElementBook.IGuiOnLinkHandler {
        public void onLink(GuiElement elem) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Link", (byte)0);
            MystcraftPacketHandler.CHANNEL.sendToServer((IMessage)new MPacketGuiMessage(((GuiNexusController)GuiNexusController.this).container.field_75152_c, nbttagcompound));
        }
    }
}

