/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.inventory;

import com.xcompwiz.mystcraft.api.item.IItemPageProvider;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import com.xcompwiz.mystcraft.inventory.ContainerBase;
import com.xcompwiz.mystcraft.inventory.IBookContainer;
import com.xcompwiz.mystcraft.item.ItemAgebook;
import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.item.LinkItemUtils;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.network.IGuiMessageHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thefloydman.moremystcraft.block.BlockNexusController;
import thefloydman.moremystcraft.init.MoreMystcraftBlocks;
import thefloydman.moremystcraft.tileentity.TileEntityNexusController;

public class ContainerNexusController
extends ContainerBase
implements IBookContainer,
IGuiMessageHandler {
    public TileEntityNexusController tileEntity;
    InventoryPlayer inventory;
    NBTTagCompound nbt;
    private String itemName;
    private ItemStack itemStack;
    private NBTTagCompound bookCompound;
    private ItemStack currentpage;
    private int currentpageIndex;
    private int pagecount;
    private EntityPlayer player;
    private ILinkInfo cached_linkinfo;
    private boolean cached_permitted;
    public int selectedBook;
    protected String query;

    public ContainerNexusController(InventoryPlayer playerInv, TileEntityNexusController controller) {
        this.tileEntity = controller;
        this.inventory = playerInv;
        this.query = "";
        this.func_75146_a(new SlotNexusInput((IInventory)controller, 0, 17, 98));
        this.func_75146_a(new Slot((IInventory)controller, 1, 143, 98){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
                ContainerNexusController.this.tileEntity.removeBook(ContainerNexusController.this.selectedBook);
                ContainerNexusController.this.selectedBook = -1;
                return super.func_190901_a(thePlayer, stack);
            }
        });
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInv, k, 8 + k * 18, 194));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 136 + i * 18));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack copyStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack existingStack = slot.func_75211_c();
            copyStack = existingStack.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? !this.func_75135_a(existingStack, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(existingStack, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (existingStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (existingStack.func_190916_E() == copyStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, existingStack);
        }
        return copyStack;
    }

    @Nonnull
    public ItemStack getBook() {
        if (this.tileEntity.getBookList() == null || this.tileEntity.getBookList().isEmpty() || this.selectedBook < 2) {
            return ItemStack.field_190927_a;
        }
        return this.func_75147_a((IInventory)this.tileEntity, 1).func_75211_c();
    }

    public Collection<String> getBookAuthors() {
        ItemStack book = this.getBook();
        if (book.func_190926_b()) {
            return Collections.EMPTY_SET;
        }
        return ((ItemLinking)book.func_77973_b()).getAuthors(book);
    }

    public String getBookTitle() {
        ItemStack book = this.getBook();
        if (book.func_190926_b() || !(book.func_77973_b() instanceof ItemLinking)) {
            return "";
        }
        return ((ItemLinking)book.func_77973_b()).getTitle(book);
    }

    @Nonnull
    public ItemStack getCurrentPage() {
        if (this.currentpage.func_190926_b()) {
            this.setCurrentPageIndex(this.currentpageIndex);
        }
        return this.currentpage;
    }

    public int getCurrentPageIndex() {
        return this.currentpageIndex;
    }

    public ILinkInfo getLinkInfo() {
        ItemStack book = this.getBook();
        if (book.func_190926_b() || !(book.func_77973_b() instanceof ItemLinking)) {
            return null;
        }
        if (this.cached_linkinfo == null) {
            this.cached_linkinfo = ((ItemLinking)book.func_77973_b()).getLinkInfo(book);
        }
        return this.cached_linkinfo;
    }

    public int getPageCount() {
        return this.pagecount;
    }

    public boolean hasBookSlot() {
        return false;
    }

    public boolean isLinkPermitted() {
        ILinkInfo linkInfo = this.getLinkInfo();
        if (linkInfo == null) {
            return false;
        }
        if (ItemAgebook.isNewAgebook((ItemStack)this.getBook())) {
            return true;
        }
        if (linkInfo.getDimensionUID() != null) {
            return this.tileEntity.func_145831_w().field_73011_w.getDimension() != linkInfo.getDimensionUID().intValue();
        }
        return false;
    }

    public boolean isTargetWorldVisited() {
        Integer dim = LinkItemUtils.getTargetDimension((ItemStack)this.getBook());
        return dim != null && DimensionUtils.isDimensionVisited((Integer)dim);
    }

    public void setCurrentPageIndex(int index) {
        List<ItemStack> pagelist;
        this.currentpage = ItemStack.field_190927_a;
        this.currentpageIndex = 0;
        if (index < 0) {
            index = 0;
        }
        if ((pagelist = this.getPageList()) == null) {
            index = 0;
            this.pagecount = 0;
        } else {
            this.pagecount = pagelist.size();
            if (index >= this.pagecount) {
                index = this.pagecount;
            } else {
                this.currentpage = pagelist.get(index);
            }
        }
        this.currentpageIndex = index;
    }

    private List<ItemStack> getPageList() {
        ItemStack book = this.getBook();
        if (book.func_190926_b()) {
            return null;
        }
        if (book.func_77973_b() instanceof IItemPageProvider) {
            return ((IItemPageProvider)book.func_77973_b()).getPageList(this.player, book);
        }
        return null;
    }

    protected void acceptBook() {
        if (this.func_75147_a((IInventory)this.tileEntity, 0).func_75216_d() && this.func_75147_a((IInventory)this.tileEntity, 0).func_75211_c().func_77973_b() instanceof ItemLinking) {
            if (this.tileEntity.getBookCount() < this.tileEntity.getBookList().size() - 2) {
                this.tileEntity.addBook(this.func_75147_a((IInventory)this.tileEntity, 0).func_75211_c());
            }
            if (!this.tileEntity.func_145831_w().field_72995_K) {
                this.tileEntity.func_145831_w().func_184138_a(this.tileEntity.func_174877_v(), this.tileEntity.func_145831_w().func_180495_p(this.tileEntity.func_174877_v()), this.tileEntity.func_145831_w().func_180495_p(this.tileEntity.func_174877_v()), 7);
            }
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        World world = this.tileEntity.func_145831_w();
        if (!world.field_72995_K) {
            this.func_193327_a(playerIn, playerIn.field_70170_p, (IInventory)this.tileEntity);
            IBlockState state = world.func_180495_p(this.tileEntity.func_174877_v());
            world.func_175656_a(this.tileEntity.func_174877_v(), state.func_177226_a((IProperty)BlockNexusController.IN_USE, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void func_193327_a(EntityPlayer playerIn, World worldIn, IInventory inventoryIn) {
        inventoryIn.func_70304_b(1);
        if (!playerIn.func_70089_S() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).func_193105_t()) {
            playerIn.func_71019_a(inventoryIn.func_70304_b(0), false);
        } else {
            playerIn.field_71071_by.func_191975_a(worldIn, inventoryIn.func_70304_b(0));
        }
    }

    public boolean func_75140_a(EntityPlayer playerIn, int id) {
        this.selectedBook = id;
        Slot slot = this.func_75147_a((IInventory)this.tileEntity, 1);
        if (id == -1) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75215_d(this.tileEntity.func_70301_a(id));
        }
        return true;
    }

    public void processMessage(EntityPlayer player, NBTTagCompound data) {
        if (data.func_74764_b("Link") && this.tileEntity != null) {
            ItemStack book = this.tileEntity.func_70301_a(1);
            if (book.func_190926_b()) {
                return;
            }
            if (book.func_77973_b() instanceof ItemLinking) {
                ((ItemLinking)book.func_77973_b()).activate(book, this.tileEntity.func_145831_w(), (Entity)player);
            }
        }
        if (data.func_74764_b("query")) {
            this.query = data.func_74779_i("query");
            this.tileEntity.setQuery(this.query);
            this.tileEntity.func_145831_w().func_184138_a(this.tileEntity.func_174877_v(), MoreMystcraftBlocks.NEXUS_CONTROLLER.func_176223_P(), MoreMystcraftBlocks.NEXUS_CONTROLLER.func_176223_P(), 3);
        }
    }

    public String getQuery() {
        return this.query;
    }

    public class SlotNexusInput
    extends Slot {
        public SlotNexusInput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemLinking;
        }

        public void func_75218_e() {
            super.func_75218_e();
            ContainerNexusController.this.acceptBook();
        }
    }
}

