/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.network;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import thefloydman.moremystcraft.network.packets.PacketPotion;
import thefloydman.moremystcraft.network.packets.PacketRenderJourneyActivation;
import thefloydman.moremystcraft.network.packets.PacketRequestPotionList;
import thefloydman.moremystcraft.network.packets.PacketSendTranslatedMessage;
import thefloydman.moremystcraft.network.packets.PacketSetHubTimer;
import thefloydman.moremystcraft.network.packets.PacketSneakPressed;
import thefloydman.moremystcraft.network.packets.PacketSpawnMaintainerSuit;

public class MoreMystcraftPacketHandler {
    public static final SimpleNetworkWrapper CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("moremystcraft");
    private static int index = 0;

    public static void register() {
        CHANNEL.registerMessage(PacketPotion.Handler.class, PacketPotion.class, index++, Side.CLIENT);
        CHANNEL.registerMessage(PacketRequestPotionList.Handler.class, PacketRequestPotionList.class, index++, Side.SERVER);
        CHANNEL.registerMessage(PacketSpawnMaintainerSuit.Handler.class, PacketSpawnMaintainerSuit.class, index++, Side.SERVER);
        CHANNEL.registerMessage(PacketRenderJourneyActivation.Handler.class, PacketRenderJourneyActivation.class, index++, Side.CLIENT);
        CHANNEL.registerMessage(PacketSetHubTimer.Handler.class, PacketSetHubTimer.class, index++, Side.SERVER);
        CHANNEL.registerMessage(PacketSendTranslatedMessage.Handler.class, PacketSendTranslatedMessage.class, index++, Side.CLIENT);
    }

    public static void sneakPressed(UUID uuid) {
        CHANNEL.sendToServer((IMessage)new PacketSneakPressed(uuid));
    }

    public static void sendPotion(int dim, String str, EntityPlayerMP player) {
        CHANNEL.sendTo((IMessage)new PacketPotion(dim, str), player);
    }

    public static void requestPotionList(int dim) {
        CHANNEL.sendToServer((IMessage)new PacketRequestPotionList(dim));
    }

    public static void spawnMaintainerSuit(BlockPos pos, float yaw) {
        CHANNEL.sendToServer((IMessage)new PacketSpawnMaintainerSuit(pos, yaw));
    }

    public static void renderJourneyActivation(EntityPlayerMP player, BlockPos pos) {
        CHANNEL.sendTo((IMessage)new PacketRenderJourneyActivation(pos), player);
    }

    public static void setHubTimer(BlockPos pos, int time) {
        CHANNEL.sendToServer((IMessage)new PacketSetHubTimer(pos, time));
    }

    public static void sendTranslatedMessage(EntityPlayerMP player, String key, int type, String username) {
        CHANNEL.sendTo((IMessage)new PacketSendTranslatedMessage(key, type, username), player);
    }
}

