/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.network.packets;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thefloydman.moremystcraft.config.MoreMystcraftConfig;
import thefloydman.moremystcraft.util.Reference;

public class PacketSendTranslatedMessage
implements IMessage {
    String key;
    int messageType;
    String username;
    int usernameLength;

    public PacketSendTranslatedMessage(String msg, int type, String name) {
        this.key = msg;
        this.messageType = type;
        this.username = name;
        this.usernameLength = this.username.length();
    }

    public PacketSendTranslatedMessage() {
        this.key = "";
        this.messageType = Reference.MessageType.GENERAL.ordinal();
        this.username = "";
        this.usernameLength = this.username.length();
    }

    public void fromBytes(ByteBuf buf) {
        this.messageType = buf.readInt();
        this.username = buf.readCharSequence(buf.readInt(), Charset.defaultCharset()).toString();
        this.key = buf.readCharSequence(buf.readableBytes(), Charset.defaultCharset()).toString();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.messageType);
        buf.writeInt(this.usernameLength);
        buf.writeCharSequence((CharSequence)this.username, Charset.defaultCharset());
        buf.writeCharSequence((CharSequence)this.key, Charset.defaultCharset());
    }

    public static class Handler
    implements IMessageHandler<PacketSendTranslatedMessage, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketSendTranslatedMessage msg, MessageContext ctx) {
            if (msg.messageType == Reference.MessageType.STATUS.ordinal()) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                player.func_146105_b((ITextComponent)new TextComponentTranslation(msg.key, new Object[0]), true);
            } else if (msg.messageType == Reference.MessageType.LINKING_LAG.ordinal() && MoreMystcraftConfig.getPostMessageOnLink()) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + msg.username + " " + new TextComponentTranslation(msg.key, new Object[0]).func_150260_c()));
            }
            return null;
        }
    }
}

