/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.symbol.behavior;

import com.google.gson.JsonObject;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import mystlibrary.exception.SymbolBuildException;
import mystlibrary.symbol.SymbolMetadata;
import mystlibrary.symbol.behavior.IAgeSymbolBehavior;
import mystlibrary.symbol.util.SymbolJsonParser;
import net.minecraft.util.ResourceLocation;
import thefloydman.moremystcraft.util.Reference;

public class SizeBehavior
implements IAgeSymbolBehavior {
    public static final ResourceLocation NAME = Reference.forMoreMystcraft("size");
    private final float size;
    private static final String FIELD_NAME_VALUE = "value";

    public static IAgeSymbolBehavior fromJson(JsonObject json, SymbolMetadata metadata) throws SymbolBuildException {
        float size = SymbolJsonParser.parseFloat((JsonObject)json, (String)FIELD_NAME_VALUE, (SymbolMetadata)metadata);
        SizeBehavior behavior = new SizeBehavior(size);
        return behavior;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("behavior_id", NAME.toString());
        json.addProperty(FIELD_NAME_VALUE, (Number)Float.valueOf(this.size));
        return json;
    }

    public SizeBehavior(float size) {
        this.size = size;
    }

    public void registerLogic(AgeDirector controller, long seed) {
        float value = this.size;
        Number prev = controller.popModifier("size").asNumber();
        if (prev != null) {
            value = this.combineFloats(prev.floatValue(), value);
        }
        controller.setModifier("size", (Object)Float.valueOf(value));
    }

    private float combineFloats(float a, float b) {
        return (a + 1.0f) / 2.0f * b;
    }
}

