/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.symbol.behavior;

import com.google.gson.JsonObject;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import mystlibrary.exception.SymbolBuildException;
import mystlibrary.symbol.SymbolMetadata;
import mystlibrary.symbol.behavior.IAgeSymbolBehavior;
import mystlibrary.symbol.util.SymbolJsonParser;
import net.minecraft.util.ResourceLocation;
import thefloydman.moremystcraft.util.Reference;

public class TiltBehavior
implements IAgeSymbolBehavior {
    public static final ResourceLocation NAME = Reference.forMoreMystcraft("tilt");
    private final float tilt;
    private static final String FIELD_NAME_VALUE = "value";

    public static IAgeSymbolBehavior fromJson(JsonObject json, SymbolMetadata metadata) throws SymbolBuildException {
        float tilt = SymbolJsonParser.parseFloat((JsonObject)json, (String)FIELD_NAME_VALUE, (SymbolMetadata)metadata);
        TiltBehavior behavior = new TiltBehavior(tilt);
        return behavior;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("behavior_id", NAME.toString());
        json.addProperty(FIELD_NAME_VALUE, (Number)Float.valueOf(this.tilt));
        return json;
    }

    public TiltBehavior(float tilt) {
        this.tilt = tilt;
    }

    public void registerLogic(AgeDirector controller, long seed) {
        Float value = Float.valueOf(this.tilt);
        Number prev = controller.popModifier("tilt").asNumber();
        if (prev != null) {
            value = Float.valueOf(ModifierUtils.averageAngles((float)prev.floatValue(), (float)value.floatValue()) % 360.0f);
        }
        controller.setModifier("tilt", (Object)value);
    }
}

