/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBiome;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import thefloydman.moremystcraft.symbol.MoreMystcraftSymbolBase;
import thefloydman.moremystcraft.world.gen.NoiseGeneratorCellularAutomata;

public class SymbolBiomeControllerIsland
extends MoreMystcraftSymbolBase {
    public SymbolBiomeControllerIsland(ResourceLocation identifier) {
        super(identifier);
    }

    public void registerLogic(AgeDirector controller, long seed) {
        Number size = controller.popModifier("size").asNumber();
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        Biome biome = ModifierUtils.popBiome((AgeDirector)controller);
        while (biome != null) {
            biomes.add(biome);
            biome = ModifierUtils.popBiome((AgeDirector)controller);
        }
        Random rand = new Random(controller.getSeed());
        while (biomes.size() < 1) {
            biomes.add(SymbolBiome.getRandomBiome((Random)rand));
        }
        controller.registerInterface((IBiomeController)new BiomeController(biomes, size));
    }

    public boolean generatesConfigOption() {
        return true;
    }

    private class BiomeController
    implements IBiomeController {
        private List<Biome> biomes;
        private double size;
        private int resolution;
        private Biome[] biomeArray;
        private double minSize;
        private double maxSize;
        private double beachSize;
        private double oceanSize;
        byte[][] noiseArray;

        public BiomeController(List<Biome> biomes, Number size) {
            this.biomes = biomes;
            if (size != null) {
                if (size.doubleValue() == 3.0) {
                    this.size = 128.0;
                } else if (size.doubleValue() == 2.0) {
                    this.size = 96.0;
                } else if (size.doubleValue() == 1.0) {
                    this.size = 64.0;
                } else if (size.doubleValue() == 0.5) {
                    this.size = 16.0;
                } else if (size.doubleValue() == 0.25) {
                    this.size = 8.0;
                }
            } else {
                this.size = 64.0;
            }
            this.minSize = this.size / 8.0;
            this.maxSize = this.size;
            this.beachSize = this.size + 16.0;
            this.oceanSize = this.size + 64.0;
            this.resolution = (int)(this.maxSize * 2.0) + 1;
            this.biomeArray = new Biome[this.resolution * this.resolution];
            this.generateIslandArray();
        }

        public List<Biome> getValidSpawnBiomes() {
            return this.biomes;
        }

        public Biome getBiomeAtCoords(int i, int j) {
            i = (int)Math.floor(i / 4);
            j = (int)Math.floor(j / 4);
            if ((double)Math.abs(i) > this.oceanSize || (double)Math.abs(j) > this.oceanSize) {
                return Biomes.field_76771_b;
            }
            if ((double)Math.abs(i) > this.size || (double)Math.abs(j) > this.size) {
                return Biomes.field_76771_b;
            }
            if (this.noiseArray[(int)((double)j + this.size)][(int)((double)i + this.size)] == 1) {
                return this.biomes.get(0);
            }
            if (this.noiseArray[(int)((double)j + this.size)][(int)((double)i + this.size)] == 2) {
                return this.biomes.get(1);
            }
            return Biomes.field_76771_b;
        }

        public Biome[] getBiomesForGeneration(Biome[] aBiome, int x, int z, int xSize, int zSize) {
            if (aBiome == null || aBiome.length < xSize * zSize) {
                aBiome = new Biome[xSize * zSize];
            }
            for (int i = 0; i < xSize * zSize; ++i) {
                aBiome[i] = this.getBiomeAtCoords((x + i % xSize) * 4, (z + i / xSize) * 4);
            }
            return aBiome;
        }

        public Biome[] getBiomesAtCoords(Biome[] aBiome, int x, int z, int xSize, int zSize, boolean flag) {
            if (aBiome == null || aBiome.length < xSize * zSize) {
                aBiome = new Biome[xSize * zSize];
            }
            if (flag && xSize == 16 && zSize == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
                return this.createBiomeArray(aBiome, x, z, xSize, zSize);
            }
            for (int i = 0; i < xSize * zSize; ++i) {
                aBiome[i] = this.getBiomeAtCoords(x + i % xSize, z + i / xSize);
            }
            return aBiome;
        }

        private Biome[] createBiomeArray(Biome[] aBiome, int i, int j, int k, int l) {
            if (aBiome == null || aBiome.length < k * l) {
                aBiome = new Biome[k * l];
            }
            for (int i2 = 0; i2 < k * l; ++i2) {
                aBiome[i2] = this.getBiomeAtCoords(i + i2 % k, j + i2 / k);
            }
            return aBiome;
        }

        public void cleanupCache() {
        }

        private Double distanceToCoords(int x, int z) {
            return Math.abs(Math.sqrt(x * x + z * z));
        }

        private void generateIslandArray() {
            if (this.biomes.get(0).equals(null)) {
                return;
            }
            this.noiseArray = new NoiseGeneratorCellularAutomata(this.resolution, this.resolution, 53, 3, 5, 3).getnoiseArray();
            double[] ellipseCenter = new double[]{this.noiseArray.length / 2, this.noiseArray[0].length / 2};
            double[] ellipseRadii = new double[]{(double)this.noiseArray.length / (4.0 - 2.0 * Math.random()), (double)this.noiseArray[0].length / (4.0 - 2.0 * Math.random())};
            this.noiseArray = this.shaveToEllipse(this.noiseArray, ellipseCenter, ellipseRadii);
        }

        private byte[][] shaveToEllipse(byte[][] input, double[] ellipseCenter, double[] ellipseRadii) {
            for (int i = 0; i < input.length; ++i) {
                for (int j = 0; j < input[0].length; ++j) {
                    if (Math.abs((double)j - ellipseCenter[1]) > ellipseRadii[1]) {
                        input[i][j] = 0;
                        continue;
                    }
                    if (Math.abs((double)i - ellipseCenter[0]) > ellipseRadii[0]) {
                        input[i][j] = 0;
                        continue;
                    }
                    if (!(((double)j - ellipseCenter[1]) * ((double)j - ellipseCenter[1]) / (ellipseRadii[1] * ellipseRadii[1]) + ((double)i - ellipseCenter[0]) * ((double)i - ellipseCenter[0]) / (ellipseRadii[0] * ellipseRadii[0]) > 1.0)) continue;
                    input[i][j] = 0;
                }
            }
            return input;
        }

        private int[][] addBeaches(int[][] beachedArray, double[] ellipseCenter, double[] ellipseRadii) {
            int chancePercent = 15;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < beachedArray.length; ++j) {
                    for (int k = 0; k < beachedArray[j].length; ++k) {
                        if (beachedArray[j][k] != 1 && beachedArray[j][k] != 2) continue;
                        if (j - 1 >= 0 && k - 1 >= 0 && this.noiseArray[j - 1][k - 1] == 0 && (int)(Math.random() * 100.0) < chancePercent) {
                            this.noiseArray[j - 1][k - 1] = 2;
                        }
                        if (j - 1 >= 0 && this.noiseArray[j - 1][k] == 0 && (int)(Math.random() * 100.0) < chancePercent) {
                            this.noiseArray[j - 1][k] = 2;
                        }
                        if (j - 1 >= 0 && k + 1 < this.noiseArray[0].length && this.noiseArray[j - 1][k + 1] == 0 && (int)(Math.random() * 100.0) < chancePercent) {
                            this.noiseArray[j - 1][k + 1] = 2;
                        }
                        if (k - 1 >= 0 && this.noiseArray[j][k - 1] == 0 && (int)(Math.random() * 100.0) < chancePercent) {
                            this.noiseArray[j][k - 1] = 2;
                        }
                        if (k + 1 < this.noiseArray[0].length && this.noiseArray[j][k + 1] == 0 && (int)(Math.random() * 100.0) < chancePercent) {
                            this.noiseArray[j][k + 1] = 2;
                        }
                        if (j + 1 < this.noiseArray.length && k - 1 >= 0 && this.noiseArray[j + 1][k - 1] == 0 && (int)(Math.random() * 100.0) < chancePercent) {
                            this.noiseArray[j + 1][k - 1] = 2;
                        }
                        if (j + 1 < this.noiseArray.length && this.noiseArray[j + 1][k] == 0 && (int)(Math.random() * 100.0) < chancePercent) {
                            this.noiseArray[j + 1][k] = 2;
                        }
                        if (j + 1 >= this.noiseArray.length || k + 1 >= this.noiseArray[0].length || this.noiseArray[j + 1][k + 1] != 0 || (int)(Math.random() * 100.0) >= chancePercent) continue;
                        this.noiseArray[j + 1][k + 1] = 2;
                    }
                }
            }
            return beachedArray;
        }

        private int coordsToIndex(int x, int z) {
            int xNew = x + (int)this.oceanSize;
            int zNew = z + (int)this.oceanSize;
            int cellNumber = zNew * this.resolution + xNew;
            return cellNumber;
        }

        private int indexToXCoord(int index) {
            int xCoord = (int)((double)index - Math.floor(index / this.resolution) * (double)this.resolution - this.oceanSize);
            return xCoord;
        }

        private int indexToZCoord(int index) {
            int zCoord = (int)(Math.floor(index / this.resolution) - this.oceanSize);
            return zCoord;
        }
    }
}

