/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainGenerator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.ChunkPrimer;
import thefloydman.moremystcraft.symbol.MoreMystcraftSymbolBase;
import thefloydman.moremystcraft.world.gen.MazeGeneratorRecursiveBacktracker;

public class SymbolTerrainGenMaze
extends MoreMystcraftSymbolBase {
    public SymbolTerrainGenMaze(ResourceLocation identifier) {
        super(identifier);
    }

    public void registerLogic(AgeDirector controller, long seed) {
        TerrainGenerator gen = new TerrainGenerator(controller);
        BlockDescriptor block = ModifierUtils.popBlockMatching((AgeDirector)controller, (BlockCategory[])new BlockCategory[]{BlockCategory.TERRAIN});
        if (block != null) {
            gen.setFloorBlock(block.blockstate);
        }
        if ((block = ModifierUtils.popBlockMatching((AgeDirector)controller, (BlockCategory[])new BlockCategory[]{BlockCategory.TERRAIN})) != null) {
            gen.setWallBlock(block.blockstate);
        }
        controller.registerInterface((ITerrainGenerator)gen);
        controller.setCloudHeight(160.0f);
    }

    public boolean generatesConfigOption() {
        return true;
    }

    private static class TerrainGenerator
    implements ITerrainGenerator {
        private AgeDirector controller;
        private IBlockState wallBlock;
        private IBlockState floorBlock;
        private Map<String, int[][]> mazeMap = new HashMap<String, int[][]>();
        private double size;

        public TerrainGenerator(AgeDirector controller) {
            this.wallBlock = Blocks.field_150348_b.func_176223_P();
            this.floorBlock = Blocks.field_150348_b.func_176223_P();
            this.controller = controller;
            this.size = 1.0;
        }

        public void setWallBlock(IBlockState state) {
            this.wallBlock = state;
        }

        public void setFloorBlock(IBlockState state) {
            this.floorBlock = state;
        }

        public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
            int wallHeight = 96;
            int floorHeight = 64;
            for (int y = 0; y < 256; ++y) {
                int localZ;
                int localX;
                IBlockState blockID = Blocks.field_150350_a.func_176223_P();
                String index = String.valueOf(Math.floor(chunkX / 16)) + "," + String.valueOf(Math.floor(chunkZ / 16));
                if (this.mazeMap.get(index) == null) {
                    this.generateMazeSquare(index);
                }
                for (localX = (int)Math.abs(((double)chunkX - (double)chunkX % this.size) / this.size); localX > 15; localX -= 16) {
                }
                for (localZ = (int)Math.abs(((double)chunkZ - (double)chunkZ % this.size) / this.size); localZ > 15; localZ -= 16) {
                }
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        if (y < 3) {
                            blockID = Blocks.field_150357_h.func_176223_P();
                        } else if (this.mazeMap.get(index)[localX][localZ] == 2 && y < 64) {
                            blockID = this.floorBlock;
                        } else if (this.mazeMap.get(index)[localX][localZ] == 1 && y < 96) {
                            blockID = this.wallBlock;
                        }
                        primer.func_177855_a(x, y, z, blockID);
                    }
                }
            }
        }

        private void generateMazeSquare(String index) {
            int[][] mazeSquare = new MazeGeneratorRecursiveBacktracker(16, 16).getMaze();
            int randomSide = (int)(Math.random() * 15.0 + 1.0);
            int n = randomSide % 2 == 0 ? 1 : 0;
            mazeSquare[randomTop += (randomTop = (int)(Math.random() * 15.0 + 1.0)) % 2 == 0 ? 1 : 0][0] = 2;
            mazeSquare[0][randomSide += n] = 2;
            this.mazeMap.put(index, mazeSquare);
        }
    }
}

