/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.util.handlers;

import com.xcompwiz.mystcraft.data.ModBlocks;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import thefloydman.moremystcraft.config.MoreMystcraftConfig;
import thefloydman.moremystcraft.data.DummyRecipe;
import thefloydman.moremystcraft.init.MoreMystcraftBlocks;
import thefloydman.moremystcraft.init.MoreMystcraftItems;

public class CraftingHandler {
    public static IForgeRegistryModifiable<IRecipe> recipeRegistry;

    public static void handleRecipes(IForgeRegistry<IRecipe> registry) {
        recipeRegistry = (IForgeRegistryModifiable)registry;
        ArrayList recipes = new ArrayList(recipeRegistry.getValuesCollection());
        for (IRecipe recipe : recipes) {
            for (Recipes en : Recipes.values()) {
                CraftingHandler.handleRecipe(recipe, en);
            }
        }
    }

    protected static void handleRecipe(IRecipe recipe, Recipes en) {
        ItemStack output;
        if (!en.option && en.item != null && (output = recipe.func_77571_b()).func_77973_b().equals(en.item)) {
            recipeRegistry.remove(recipe.getRegistryName());
            recipeRegistry.register((IForgeRegistryEntry)DummyRecipe.from(recipe));
        }
    }

    protected static enum Recipes {
        BOOK_BINDER(MoreMystcraftConfig.getBookBinderRecipeEnabled(), ModBlocks.bookbinder),
        LOCKED_LECTERN(MoreMystcraftConfig.getLockedLecternRecipeDisabled(), MoreMystcraftBlocks.LOCKED_LECTERN),
        LOCKED_BOOKSTAND(MoreMystcraftConfig.getLockedBookstandRecipeEnabled(), MoreMystcraftBlocks.LOCKED_BOOKSTAND),
        TRAFFIC_CONE(MoreMystcraftConfig.getTrafficConeRecipeEnabled(), MoreMystcraftBlocks.TRAFFIC_CONE),
        NEXUS_CONTROLLER(MoreMystcraftConfig.getNexusControllerRecipeEnabled(), MoreMystcraftBlocks.NEXUS_CONTROLLER),
        UNSTABLE_RECEPTACLE(MoreMystcraftConfig.getUnstableReceptacleRecipeEnabled(), MoreMystcraftBlocks.UNSTABLE_RECEPTACLE),
        MAINTAINER_SUIT(MoreMystcraftConfig.getMaintainerSuitRecipeEnabled(), MoreMystcraftItems.MAINTAINER_SUIT),
        JOURNEY_CLOTH_HAND(MoreMystcraftConfig.getJourneyRecipesEnabled(), MoreMystcraftBlocks.JOURNEY_CLOTH_HAND_ITEM),
        JOURNEY_CLOTH_SHELL(MoreMystcraftConfig.getJourneyRecipesEnabled(), MoreMystcraftBlocks.JOURNEY_CLOTH_SHELL_ITEM),
        JOURNEY_HUB_HAND(MoreMystcraftConfig.getJourneyRecipesEnabled(), MoreMystcraftBlocks.JOURNEY_HUB_HAND_ITEM),
        JOURNEY_HUB_SHELL(MoreMystcraftConfig.getJourneyRecipesEnabled(), MoreMystcraftBlocks.JOURNEY_HUB_SHELL_ITEM);

        protected boolean option;
        protected Object item;

        private Recipes(boolean bool, Object object) {
            this.option = bool;
            this.item = null;
            if (object != null) {
                if (object instanceof Block) {
                    if (ForgeRegistries.BLOCKS.containsValue((IForgeRegistryEntry)((Block)object))) {
                        this.item = Item.func_150898_a((Block)((Block)object));
                    }
                } else if (object instanceof Item && ForgeRegistries.ITEMS.containsValue((IForgeRegistryEntry)((Item)object))) {
                    this.item = (Item)object;
                }
            }
        }
    }
}

