/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.util.handlers;

import com.xcompwiz.mystcraft.api.event.LinkEvent;
import com.xcompwiz.mystcraft.item.ItemLinkbookUnlinked;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import java.util.List;
import mystlibrary.event.BehaviorRegistrationEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thefloydman.moremystcraft.capability.adventurepanel.ICapabilityAdventurePanel;
import thefloydman.moremystcraft.capability.adventurepanel.ProviderCapabilityAdventurePanel;
import thefloydman.moremystcraft.capability.journeyclothscollected.ICapabilityJourneyClothsCollected;
import thefloydman.moremystcraft.capability.journeyclothscollected.ProviderCapabilityJourneyClothsCollected;
import thefloydman.moremystcraft.client.render.RenderMaintainerSuit;
import thefloydman.moremystcraft.client.render.RenderPotionDummy;
import thefloydman.moremystcraft.config.MoreMystcraftConfig;
import thefloydman.moremystcraft.entity.EntityMaintainerSuit;
import thefloydman.moremystcraft.entity.EntityPotionDummy;
import thefloydman.moremystcraft.init.MoreMystcraftBlocks;
import thefloydman.moremystcraft.init.MoreMystcraftEntityEntries;
import thefloydman.moremystcraft.init.MoreMystcraftItems;
import thefloydman.moremystcraft.item.ItemMaintainerSuit;
import thefloydman.moremystcraft.network.MoreMystcraftPacketHandler;
import thefloydman.moremystcraft.symbol.behavior.CloudHeightBehavior;
import thefloydman.moremystcraft.symbol.behavior.SizeBehavior;
import thefloydman.moremystcraft.symbol.behavior.TiltBehavior;
import thefloydman.moremystcraft.util.Reference;
import thefloydman.moremystcraft.util.handlers.CraftingHandler;
import thefloydman.moremystcraft.util.handlers.MaintainerSuitEventHandler;

@Mod.EventBusSubscriber
public class EventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerColors(ColorHandlerEvent.Block event) {
    }

    @SubscribeEvent
    public static void registerRenders(ModelRegistryEvent event) {
        MoreMystcraftBlocks.registerMystcraftModels();
        if (MoreMystcraftConfig.getMaintainerSuitEnabled()) {
            RenderingRegistry.registerEntityRenderingHandler(EntityMaintainerSuit.class, RenderMaintainerSuit::new);
            RenderingRegistry.registerEntityRenderingHandler(EntityPotionDummy.class, RenderPotionDummy::new);
        }
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        if (MoreMystcraftConfig.getMaintainerSuitEnabled()) {
            event.getRegistry().register((IForgeRegistryEntry)MoreMystcraftEntityEntries.MAINTAINER_SUIT);
            event.getRegistry().register((IForgeRegistryEntry)MoreMystcraftEntityEntries.POTION_DUMMY);
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        CraftingHandler.handleRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
    }

    @SubscribeEvent
    public static void keyPressed(InputEvent.KeyInputEvent event) {
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        MoreMystcraftItems.registerItems(event);
    }

    @SubscribeEvent
    public static void entityJoinWorld(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && entity.field_71093_bK > 1 && world.field_73011_w instanceof WorldProviderMyst) {
            EntityPotionDummy dummy = new EntityPotionDummy(world);
            dummy.setParent(entity.func_110124_au());
            world.func_72838_d((Entity)dummy);
            List<String> potions = MaintainerSuitEventHandler.getPotionsList(entity.field_71093_bK);
            if (potions != null) {
                for (String potion : potions) {
                    MoreMystcraftPacketHandler.sendPotion(entity.field_71093_bK, potion, (EntityPlayerMP)entity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        EntityPlayer player = event.getPlayer();
        World world = player.func_130014_f_();
        if (!world.field_72995_K && event.getEntityItem().func_92059_d().func_77973_b() instanceof ItemMaintainerSuit) {
            event.setCanceled(true);
            Vec3d playerPos = player.func_174791_d();
            Vec3d playerLook = player.func_70040_Z();
            Vec3d playerEyes = playerPos.func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
            Vec3d playerEnd = playerEyes.func_178787_e(playerLook).func_178787_e(playerLook);
            RayTraceResult result = world.func_147447_a(playerEyes, playerEnd, false, false, true);
            Vec3d hitVec = playerEnd;
            if (!result.field_72313_a.equals((Object)RayTraceResult.Type.MISS)) {
                hitVec = result.field_72307_f;
            }
            Vec3d groundVec = hitVec.func_72441_c(0.0, -2.0, 0.0);
            BlockPos groundPos = world.func_147447_a(hitVec, groundVec, false, false, true).func_178782_a();
            EntityMaintainerSuit entity = new EntityMaintainerSuit(world);
            entity.func_70107_b((double)groundPos.func_177958_n() + 0.5, (double)groundPos.func_177956_o() + 1.0, (double)groundPos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntityPlayer) {
            event.addCapability(Reference.forMoreMystcraft("journey_cloths_activated"), (ICapabilityProvider)new ProviderCapabilityJourneyClothsCollected());
            event.addCapability(Reference.forMoreMystcraft("previous_gamemode"), (ICapabilityProvider)new ProviderCapabilityAdventurePanel());
        }
    }

    @SubscribeEvent
    public static void onLinkStart(LinkEvent.LinkEventStart event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)event.entity;
            ICapabilityAdventurePanel cap = (ICapabilityAdventurePanel)event.entity.getCapability(ProviderCapabilityAdventurePanel.ADVENTURE_PANEL, null);
            GameType type = cap.getPreviousGameMode();
            if (type != null && cap.getLinkedToAdventure()) {
                player.func_71033_a(type);
            }
            cap.setPreviousGameMode(player.field_71134_c.func_73081_b());
            if (MoreMystcraftConfig.getPostMessageOnLink()) {
                String[] names;
                PlayerList playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
                for (String name : names = playerList.func_72369_d()) {
                    if (name.equals(player.getDisplayNameString())) continue;
                    MoreMystcraftPacketHandler.sendTranslatedMessage(playerList.func_152612_a(name), Reference.Message.PLAYER_LINKING.key, Reference.MessageType.LINKING_LAG.ordinal(), player.getDisplayNameString());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLinkEnd(LinkEvent.LinkEventEnd event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)event.entity;
            ICapabilityAdventurePanel cap = (ICapabilityAdventurePanel)event.entity.getCapability(ProviderCapabilityAdventurePanel.ADVENTURE_PANEL, null);
            if (event.info.getFlag("Adventure")) {
                player.func_71033_a(GameType.ADVENTURE);
                MoreMystcraftPacketHandler.sendTranslatedMessage(player, Reference.Message.CHANGE_TO_ADVENTURE_MODE.key, Reference.MessageType.STATUS.ordinal(), "none");
                cap.setLinkedToAdventure(true);
            } else {
                player.func_71033_a(cap.getPreviousGameMode());
                cap.setLinkedToAdventure(false);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            ICapabilityAdventurePanel cap = (ICapabilityAdventurePanel)player.getCapability(ProviderCapabilityAdventurePanel.ADVENTURE_PANEL, null);
            cap.setDeathDimension(event.getEntityLiving().func_130014_f_().field_73011_w.getDimension());
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(LivingSpawnEvent event) {
        EntityPlayerMP player;
        ICapabilityAdventurePanel cap;
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        if (entity instanceof EntityPlayer && !world.field_72995_K && (cap = (ICapabilityAdventurePanel)(player = (EntityPlayerMP)entity).getCapability(ProviderCapabilityAdventurePanel.ADVENTURE_PANEL, null)).getLinkedToAdventure() && player.field_71134_c.func_73081_b().equals((Object)GameType.ADVENTURE) && cap.getDeathDimension() != world.field_73011_w.getDimension()) {
            player.func_71033_a(cap.getPreviousGameMode());
            cap.setLinkedToAdventure(false);
        }
    }

    @SubscribeEvent
    public static void playerInteractRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getWorld().field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            if (player.field_71134_c.func_73081_b().equals((Object)GameType.ADVENTURE) && event.getItemStack().func_77973_b() instanceof ItemLinkbookUnlinked && !MoreMystcraftConfig.getUnlinkedBooksEnabledInAdventureMode()) {
                MoreMystcraftPacketHandler.sendTranslatedMessage(player, Reference.Message.USE_UNLINKED_BOOK_IN_ADVENTURE_MODE.key, Reference.MessageType.STATUS.ordinal(), "none");
                event.setCancellationResult(EnumActionResult.FAIL);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            EntityPlayer entityOld = event.getOriginal();
            EntityPlayer entityNew = event.getEntityPlayer();
            ICapabilityAdventurePanel capModeOld = (ICapabilityAdventurePanel)entityOld.getCapability(ProviderCapabilityAdventurePanel.ADVENTURE_PANEL, null);
            ICapabilityAdventurePanel capModeNew = (ICapabilityAdventurePanel)entityNew.getCapability(ProviderCapabilityAdventurePanel.ADVENTURE_PANEL, null);
            capModeNew.setDeathDimension(capModeOld.getDeathDimension());
            capModeNew.setLinkedToAdventure(capModeOld.getLinkedToAdventure());
            capModeNew.setPreviousGameMode(capModeOld.getPreviousGameMode());
            ICapabilityJourneyClothsCollected capJourneyOld = (ICapabilityJourneyClothsCollected)entityOld.getCapability(ProviderCapabilityJourneyClothsCollected.JOURNEY_CLOTH, null);
            ICapabilityJourneyClothsCollected capJourneyNew = (ICapabilityJourneyClothsCollected)entityNew.getCapability(ProviderCapabilityJourneyClothsCollected.JOURNEY_CLOTH, null);
            capJourneyNew.setActivatedCloths(capJourneyOld.getActivatedCloths());
        }
    }

    @SubscribeEvent
    public static void registerBehaviors(BehaviorRegistrationEvent event) {
        event.registerBehavior(TiltBehavior.NAME, TiltBehavior::fromJson);
        event.registerBehavior(SizeBehavior.NAME, SizeBehavior::fromJson);
        event.registerBehavior(CloudHeightBehavior.NAME, CloudHeightBehavior::fromJson);
    }
}

