/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.world.gen;

import java.util.ArrayList;
import java.util.List;

public class MazeGeneratorRecursiveBacktracker {
    private int[][] maze;
    private int width;
    private int height;
    private List<int[]> unvisitedCells = new ArrayList<int[]>();

    public MazeGeneratorRecursiveBacktracker(int width, int height) {
        int i;
        this.width = width;
        this.height = height;
        int[] currentCell = new int[2];
        int[] nextCell = new int[2];
        int[] middleCell = new int[2];
        List<Object> neighborCells = new ArrayList();
        this.maze = new int[this.width][this.height];
        for (i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (i % 2 == 0 || j % 2 == 0) {
                    this.maze[i][j] = 1;
                    continue;
                }
                this.maze[i][j] = 0;
                this.unvisitedCells.add(new int[]{i, j});
            }
        }
        currentCell[0] = (int)(Math.random() * (double)(this.width - 1) + 1.0);
        currentCell[0] = currentCell[0] + (currentCell[0] % 2 == 0 ? 1 : 0);
        currentCell[1] = (int)(Math.random() * (double)(this.height - 1) + 1.0);
        currentCell[1] = currentCell[1] + (currentCell[1] % 2 == 0 ? 1 : 0);
        this.maze[currentCell[0]][currentCell[1]] = 2;
        for (i = 0; i < this.unvisitedCells.size(); ++i) {
            if (this.unvisitedCells.get(i)[0] != currentCell[0] || this.unvisitedCells.get(i)[1] != currentCell[1]) continue;
            this.unvisitedCells.remove(i);
            break;
        }
        neighborCells = this.getNeighbors(currentCell);
        ArrayList<int[]> stack = new ArrayList<int[]>();
        while (this.unvisitedCells.size() > 0) {
            if (neighborCells.size() > 0) {
                nextCell = (int[])neighborCells.get((int)(Math.random() * (double)neighborCells.size()));
                stack.add(0, currentCell);
                if (nextCell[0] == currentCell[0]) {
                    middleCell[0] = currentCell[0];
                    middleCell[1] = nextCell[1] > currentCell[1] ? currentCell[1] + 1 : currentCell[1] - 1;
                    this.maze[middleCell[0]][middleCell[1]] = 2;
                } else if (nextCell[1] == currentCell[1]) {
                    middleCell[1] = currentCell[1];
                    middleCell[0] = nextCell[0] > currentCell[0] ? currentCell[0] + 1 : currentCell[0] - 1;
                    this.maze[middleCell[0]][middleCell[1]] = 2;
                }
                currentCell = nextCell;
                this.maze[currentCell[0]][currentCell[1]] = 2;
                for (int i2 = 0; i2 < this.unvisitedCells.size(); ++i2) {
                    if (this.unvisitedCells.get(i2)[0] != currentCell[0] || this.unvisitedCells.get(i2)[1] != currentCell[1]) continue;
                    this.unvisitedCells.remove(i2);
                    break;
                }
                neighborCells = this.getNeighbors(currentCell);
                continue;
            }
            if (stack.size() <= 0) continue;
            currentCell = (int[])stack.get(0);
            stack.remove(0);
            neighborCells = this.getNeighbors(currentCell);
        }
    }

    private List<int[]> getNeighbors(int[] mainCell) {
        ArrayList<int[]> neighborCells = new ArrayList<int[]>();
        int[] up = new int[]{mainCell[0], mainCell[1] - 2};
        if (mainCell[1] - 2 >= 0) {
            for (int i = 0; i < this.unvisitedCells.size(); ++i) {
                if (this.unvisitedCells.get(i)[0] != up[0] || this.unvisitedCells.get(i)[1] != up[1]) continue;
                neighborCells.add(up);
                break;
            }
        }
        int[] left = new int[]{mainCell[0] - 2, mainCell[1]};
        if (mainCell[0] - 2 >= 0) {
            for (int i = 0; i < this.unvisitedCells.size(); ++i) {
                if (this.unvisitedCells.get(i)[0] != left[0] || this.unvisitedCells.get(i)[1] != left[1]) continue;
                neighborCells.add(left);
                break;
            }
        }
        int[] right = new int[]{mainCell[0] + 2, mainCell[1]};
        if (mainCell[0] + 2 < this.width) {
            for (int i = 0; i < this.unvisitedCells.size(); ++i) {
                if (this.unvisitedCells.get(i)[0] != right[0] || this.unvisitedCells.get(i)[1] != right[1]) continue;
                neighborCells.add(right);
                break;
            }
        }
        int[] down = new int[]{mainCell[0], mainCell[1] + 2};
        if (mainCell[1] + 2 < this.height) {
            for (int i = 0; i < this.unvisitedCells.size(); ++i) {
                if (this.unvisitedCells.get(i)[0] != down[0] || this.unvisitedCells.get(i)[1] != down[1]) continue;
                neighborCells.add(down);
                break;
            }
        }
        return neighborCells;
    }

    public int[][] getMaze() {
        return this.maze;
    }
}

