/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.world.gen;

import java.util.ArrayList;
import java.util.List;

public class NoiseGeneratorCellularAutomata {
    private byte[][] noiseArray;
    private List<int[]> unverifiedCells;
    private final int width;
    private final int height;

    public NoiseGeneratorCellularAutomata(int mapWidth, int mapHeight, int alivePercentage, int passes, int deadToAlive, int aliveToDead) {
        int i;
        this.width = mapWidth;
        this.height = mapHeight;
        this.noiseArray = new byte[this.height][this.width];
        for (i = 0; i < this.noiseArray.length; ++i) {
            for (int j = 0; j < this.noiseArray[i].length; ++j) {
                int centerX = this.width / 2;
                int centerY = this.height / 2;
                double distanceFromCenter = Math.sqrt((j - centerX) * (j - centerX) + (i - centerY) * (i - centerY));
                this.noiseArray[i][j] = distanceFromCenter < (double)((this.height + this.width) / 2 / 6) || Math.random() * 100.0 < (double)alivePercentage ? (byte)1 : 0;
            }
        }
        for (i = 0; i < passes; ++i) {
            int k;
            int j;
            for (j = 0; j < this.noiseArray.length; ++j) {
                for (k = 0; k < this.noiseArray[0].length; ++k) {
                    if (this.noiseArray[j][k] == 0) {
                        if (this.livingNeighbors(j, k) <= deadToAlive - 1) continue;
                        this.noiseArray[j][k] = 1;
                        continue;
                    }
                    if (this.noiseArray[j][k] != 1 || this.livingNeighbors(j, k) >= aliveToDead + 1) continue;
                    this.noiseArray[j][k] = 0;
                }
            }
            this.unverifiedCells = new ArrayList<int[]>();
            for (j = 0; j < this.noiseArray.length; ++j) {
                k = 0;
                while (k < this.noiseArray[0].length) {
                    this.unverifiedCells.add(new int[]{j, k++});
                }
            }
            while (this.unverifiedCells.size() > 0) {
                ArrayList<int[]> blobCells = new ArrayList();
                if (this.noiseArray[this.unverifiedCells.get(0)[0]][this.unverifiedCells.get(0)[1]] == 1) {
                    blobCells = this.getBlobCells(this.unverifiedCells.get(0));
                } else {
                    this.unverifiedCells.remove(0);
                }
                if (blobCells.size() <= 8 || this.findBlobWidth(blobCells) >= 2 && this.findBlobHeight(blobCells) >= 2) continue;
                for (int j2 = 0; j2 < blobCells.size(); ++j2) {
                    this.noiseArray[((int[])blobCells.get((int)j2))[0]][((int[])blobCells.get((int)j2))[1]] = 0;
                }
            }
        }
    }

    private int livingNeighbors(int row, int column) {
        int count = 0;
        if (row - 1 >= 0 && column - 1 >= 0 && this.noiseArray[row - 1][column - 1] == 1) {
            ++count;
        }
        if (row - 1 >= 0 && this.noiseArray[row - 1][column] == 1) {
            ++count;
        }
        if (row - 1 >= 0 && column + 1 < this.width && this.noiseArray[row - 1][column + 1] == 1) {
            ++count;
        }
        if (column - 1 >= 0 && this.noiseArray[row][column - 1] == 1) {
            ++count;
        }
        if (column + 1 < this.width && this.noiseArray[row][column + 1] == 1) {
            ++count;
        }
        if (row + 1 < this.height && column - 1 >= 0 && this.noiseArray[row + 1][column - 1] == 1) {
            ++count;
        }
        if (row + 1 < this.height && this.noiseArray[row + 1][column] == 1) {
            ++count;
        }
        if (row + 1 < this.height && column + 1 < this.width && this.noiseArray[row + 1][column + 1] == 1) {
            ++count;
        }
        return count;
    }

    private List<int[]> getBlobCells(int[] startCell) {
        ArrayList<int[]> allCells = new ArrayList<int[]>();
        ArrayList<int[]> unvisitedCells = new ArrayList<int[]>();
        unvisitedCells.add(startCell);
        int[] currentCell = new int[2];
        while (unvisitedCells.size() > 0) {
            int[] motherCell = (int[])unvisitedCells.remove(0);
            allCells.add(motherCell);
            if (this.unverifiedCells.indexOf(motherCell) == -1) continue;
            this.unverifiedCells.remove(this.unverifiedCells.indexOf(motherCell));
            if (motherCell[0] - 1 >= 0) {
                currentCell[0] = motherCell[0] - 1;
                currentCell[1] = motherCell[1];
                if (this.noiseArray[currentCell[0]][currentCell[1]] == 1 && !allCells.contains(currentCell) && !unvisitedCells.contains(currentCell)) {
                    unvisitedCells.add(currentCell);
                }
            }
            if (motherCell[0] + 1 < this.height) {
                currentCell[0] = motherCell[0] + 1;
                currentCell[1] = motherCell[1];
                if (this.noiseArray[currentCell[0]][currentCell[1]] == 1 && !allCells.contains(currentCell) && !unvisitedCells.contains(currentCell)) {
                    unvisitedCells.add(currentCell);
                }
            }
            if (motherCell[1] - 1 >= 0) {
                currentCell[0] = motherCell[0];
                currentCell[1] = motherCell[1] - 1;
                if (this.noiseArray[currentCell[0]][currentCell[1]] == 1 && !allCells.contains(currentCell) && !unvisitedCells.contains(currentCell)) {
                    unvisitedCells.add(currentCell);
                }
            }
            if (motherCell[1] + 1 >= this.width) continue;
            currentCell[0] = motherCell[0];
            currentCell[1] = motherCell[1] + 1;
            if (this.noiseArray[currentCell[0]][currentCell[1]] != 1 || allCells.contains(currentCell) || unvisitedCells.contains(currentCell)) continue;
            unvisitedCells.add(currentCell);
        }
        return allCells;
    }

    private int findBlobHeight(List<int[]> blob) {
        int currentY;
        int largestY = currentY = blob.get(0)[0];
        int smallestY = currentY;
        for (int i = 1; i < blob.size(); ++i) {
            currentY = blob.get(i)[0];
            if (currentY > largestY) {
                largestY = currentY;
            }
            if (currentY >= smallestY) continue;
            smallestY = currentY;
        }
        return largestY - smallestY + 1;
    }

    private int findBlobWidth(List<int[]> blob) {
        int currentX;
        int largestX = currentX = blob.get(0)[1];
        int smallestX = currentX;
        for (int i = 1; i < blob.size(); ++i) {
            currentX = blob.get(i)[1];
            if (currentX > largestX) {
                largestX = currentX;
            }
            if (currentX >= smallestX) continue;
            smallestX = currentX;
        }
        return largestX - smallestX + 1;
    }

    public byte[][] getnoiseArray() {
        return this.noiseArray;
    }
}

