/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.world.gen.feature;

import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.IWorldGenerator;
import thefloydman.moremystcraft.config.MoreMystcraftConfig;
import thefloydman.moremystcraft.util.Reference;
import thefloydman.moremystcraft.world.gen.feature.SubWorldGenStudy;

public class WorldGenStudy
extends WorldGenerator
implements IWorldGenerator {
    static Map<Biome, Map<String, IBlockState>> biomeMap = new HashMap<Biome, Map<String, IBlockState>>();

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(world, rand, blockX + 8, blockZ + 8);
                break;
            }
            case 0: {
                new MoreMystcraftConfig();
                if (!MoreMystcraftConfig.getStudiesEnabled()) break;
                this.generateOverworld(world, rand, blockX + 8, blockZ + 8);
                break;
            }
            case 1: {
                this.generateEnd(world, rand, blockX + 8, blockZ + 8);
                break;
            }
        }
        int dimId = world.field_73011_w.getDimension();
        try {
            if (dimId < 0) {
                return;
            }
            if (world.field_73011_w instanceof WorldProviderMyst) {
                new AgeData("currentDim");
                AgeData data = AgeData.getAge((int)dimId, (boolean)false);
                List symbolList = data.getSymbols(false);
                ResourceLocation studyLoc = Reference.forMoreMystcraft("abandoned_study");
                if (symbolList.contains(studyLoc)) {
                    this.generateOverworld(world, rand, blockX + 8, blockZ + 8);
                }
            }
        }
        catch (NullPointerException e) {
            return;
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid Dimension ID: " + Integer.toString(dimId));
        }
    }

    private void generateOverworld(World world, Random rand, int blockX, int blockZ) {
        new MoreMystcraftConfig();
        if ((int)(rand.nextFloat() * (float)MoreMystcraftConfig.getStudyFrequency()) == 0) {
            int y = WorldGenStudy.getGroundFromAbove(world, blockX, blockZ);
            BlockPos pos = new BlockPos(blockX, y, blockZ);
            if (world.func_180495_p(pos).func_185904_a().func_76224_d() || world.func_180495_p(pos).func_185904_a() == Material.field_151584_j || world.func_180495_p(pos).func_185904_a() == Material.field_151575_d) {
                return;
            }
            Map<String, IBlockState> blockMap = biomeMap.get(world.func_180494_b(pos));
            if (blockMap == null) {
                blockMap = biomeMap.get(Biomes.field_76772_c);
            }
            SubWorldGenStudy structure = new SubWorldGenStudy(blockMap);
            structure.func_180709_b(world, rand, pos.func_177982_a(0, -4, 0));
        }
    }

    private void generateNether(World world, Random rand, int chunkX, int chunkZ) {
    }

    private void generateEnd(World world, Random rand, int chunkX, int chunkZ) {
    }

    public static int getGroundFromAbove(World world, int x, int z) {
        int y = 255;
        boolean foundGround = false;
        while (!foundGround) {
            int n = y--;
            new MoreMystcraftConfig();
            if (n < MoreMystcraftConfig.getStudyMinimumY()) break;
            IBlockState blockAt = world.func_180495_p(new BlockPos(x, y, z));
            foundGround = blockAt.func_185904_a().func_76220_a();
        }
        return y;
    }

    public static boolean canSpawnHere(Template template, World world, BlockPos posAboveGround) {
        int zwidth = template.func_186259_a().func_177952_p();
        int xwidth = template.func_186259_a().func_177958_n();
        boolean corner1 = WorldGenStudy.isCornerValid(world, posAboveGround);
        boolean corner2 = WorldGenStudy.isCornerValid(world, posAboveGround.func_177982_a(xwidth, 0, zwidth));
        return posAboveGround.func_177956_o() > 31 && corner1 && corner2;
    }

    public static boolean isCornerValid(World world, BlockPos pos) {
        int variation = 3;
        int highestBlock = WorldGenStudy.getGroundFromAbove(world, pos.func_177958_n(), pos.func_177952_p());
        return highestBlock > pos.func_177956_o() - variation && highestBlock < pos.func_177956_o() + variation;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        return false;
    }

    protected static Map<String, IBlockState> assignBlocks(IBlockState log, IBlockState planks, IBlockState slab, IBlockState stairs) {
        IBlockState stairsSouthBottomStraight = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        IBlockState stairsNorthBottomStraight = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        IBlockState stairsSouthTopStraight = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        IBlockState stairsNorthTopStraight = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        IBlockState stairsWestBottomStraight = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        IBlockState stairsNorthBottomOuterLeft = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
        IBlockState stairsSouthBottomOuterRight = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
        IBlockState stairsWestTopStraight = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        IBlockState stairsEastTopStraight = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        IBlockState stairsNorthTopInnerLeft = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_LEFT);
        IBlockState stairsNorthTopInnerRight = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_RIGHT);
        IBlockState stairsSouthTopInnerLeft = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_LEFT);
        IBlockState stairsSouthTopInnerRight = stairs.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_RIGHT);
        HashMap<String, IBlockState> map = new HashMap<String, IBlockState>();
        map.put("log", log);
        map.put("planks", planks);
        map.put("slab", slab);
        map.put("stairs_south_bottom_straight", stairsSouthBottomStraight);
        map.put("stairs_north_bottom_straight", stairsNorthBottomStraight);
        map.put("stairs_south_top_straight", stairsSouthTopStraight);
        map.put("stairs_north_top_straight", stairsNorthTopStraight);
        map.put("stairs_west_bottom_straight", stairsWestBottomStraight);
        map.put("stairs_north_bottom_outer_left", stairsNorthBottomOuterLeft);
        map.put("stairs_south_bottom_outer_right", stairsSouthBottomOuterRight);
        map.put("stairs_west_top_straight", stairsWestTopStraight);
        map.put("stairs_east_top_straight", stairsEastTopStraight);
        map.put("stairs_north_top_inner_left", stairsNorthTopInnerLeft);
        map.put("stairs_north_top_inner_right", stairsNorthTopInnerRight);
        map.put("stairs_south_top_inner_left", stairsSouthTopInnerLeft);
        map.put("stairs_south_top_inner_right", stairsSouthTopInnerRight);
        return map;
    }

    protected static Map<String, IBlockState> repairMap(Map<String, IBlockState> map) {
        HashMap<String, IBlockState> newMap = new HashMap<String, IBlockState>();
        for (Map.Entry<String, IBlockState> entry : map.entrySet()) {
            if (entry.getValue() != null) {
                newMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            newMap.put(entry.getKey(), Blocks.field_150348_b.func_176223_P());
        }
        return newMap;
    }

    static {
        Map<String, IBlockState> mapOak = WorldGenStudy.repairMap(WorldGenStudy.assignBlocks(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.OAK), Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockWoodSlab.field_176557_b, (Comparable)BlockPlanks.EnumType.OAK), Blocks.field_150476_ad.func_176223_P()));
        Map<String, IBlockState> mapAcacia = WorldGenStudy.repairMap(WorldGenStudy.assignBlocks(Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.ACACIA), Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockWoodSlab.field_176557_b, (Comparable)BlockPlanks.EnumType.ACACIA), Blocks.field_150400_ck.func_176223_P()));
        Map<String, IBlockState> mapBirch = WorldGenStudy.repairMap(WorldGenStudy.assignBlocks(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.BIRCH), Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockWoodSlab.field_176557_b, (Comparable)BlockPlanks.EnumType.BIRCH), Blocks.field_150487_bG.func_176223_P()));
        Map<String, IBlockState> mapDarkOak = WorldGenStudy.repairMap(WorldGenStudy.assignBlocks(Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.DARK_OAK), Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockWoodSlab.field_176557_b, (Comparable)BlockPlanks.EnumType.DARK_OAK), Blocks.field_150401_cl.func_176223_P()));
        Map<String, IBlockState> mapJungle = WorldGenStudy.repairMap(WorldGenStudy.assignBlocks(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockWoodSlab.field_176557_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150481_bH.func_176223_P()));
        Map<String, IBlockState> mapSpruce = WorldGenStudy.repairMap(WorldGenStudy.assignBlocks(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockWoodSlab.field_176557_b, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150485_bF.func_176223_P()));
        Map<String, IBlockState> mapSandstone = WorldGenStudy.repairMap(WorldGenStudy.assignBlocks(Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH), Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.DEFAULT), Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SAND), Blocks.field_150372_bz.func_176223_P()));
        Map<String, IBlockState> mapStone = WorldGenStudy.repairMap(WorldGenStudy.assignBlocks(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE), Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.DEFAULT), Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE), Blocks.field_150446_ar.func_176223_P()));
        biomeMap.put(Biomes.field_76787_r, mapOak);
        biomeMap.put(Biomes.field_150583_P, mapBirch);
        biomeMap.put(Biomes.field_150582_Q, mapBirch);
        biomeMap.put(Biomes.field_150577_O, mapSpruce);
        biomeMap.put(Biomes.field_150584_S, mapSpruce);
        biomeMap.put(Biomes.field_150575_M, mapOak);
        biomeMap.put(Biomes.field_180279_ad, mapOak);
        biomeMap.put(Biomes.field_76769_d, mapSandstone);
        biomeMap.put(Biomes.field_76786_s, mapSandstone);
        biomeMap.put(Biomes.field_76770_e, mapSpruce);
        biomeMap.put(Biomes.field_76783_v, mapSpruce);
        biomeMap.put(Biomes.field_150580_W, mapSpruce);
        biomeMap.put(Biomes.field_76767_f, mapOak);
        biomeMap.put(Biomes.field_76785_t, mapOak);
        biomeMap.put(Biomes.field_76776_l, mapSpruce);
        biomeMap.put(Biomes.field_76777_m, mapOak);
        biomeMap.put(Biomes.field_76778_j, mapOak);
        biomeMap.put(Biomes.field_76775_o, mapSpruce);
        biomeMap.put(Biomes.field_76774_n, mapSpruce);
        biomeMap.put(Biomes.field_76782_w, mapJungle);
        biomeMap.put(Biomes.field_150574_L, mapJungle);
        biomeMap.put(Biomes.field_76792_x, mapJungle);
        biomeMap.put(Biomes.field_150589_Z, mapAcacia);
        biomeMap.put(Biomes.field_150608_ab, mapAcacia);
        biomeMap.put(Biomes.field_150607_aa, mapAcacia);
        biomeMap.put(Biomes.field_76789_p, mapOak);
        biomeMap.put(Biomes.field_76788_q, mapOak);
        biomeMap.put(Biomes.field_185448_Z, mapBirch);
        biomeMap.put(Biomes.field_185429_aa, mapSpruce);
        biomeMap.put(Biomes.field_185442_R, mapSandstone);
        biomeMap.put(Biomes.field_185443_S, mapSpruce);
        biomeMap.put(Biomes.field_185434_af, mapSpruce);
        biomeMap.put(Biomes.field_185444_T, mapOak);
        biomeMap.put(Biomes.field_185445_W, mapSpruce);
        biomeMap.put(Biomes.field_185446_X, mapJungle);
        biomeMap.put(Biomes.field_185447_Y, mapJungle);
        biomeMap.put(Biomes.field_185437_ai, mapAcacia);
        biomeMap.put(Biomes.field_185439_ak, mapAcacia);
        biomeMap.put(Biomes.field_185438_aj, mapAcacia);
        biomeMap.put(Biomes.field_185441_Q, mapOak);
        biomeMap.put(Biomes.field_185432_ad, mapSpruce);
        biomeMap.put(Biomes.field_185433_ae, mapSpruce);
        biomeMap.put(Biomes.field_185430_ab, mapDarkOak);
        biomeMap.put(Biomes.field_185435_ag, mapAcacia);
        biomeMap.put(Biomes.field_185436_ah, mapAcacia);
        biomeMap.put(Biomes.field_150599_m, mapOak);
        biomeMap.put(Biomes.field_150590_f, mapSpruce);
        biomeMap.put(Biomes.field_185431_ac, mapSpruce);
        biomeMap.put(Biomes.field_76771_b, mapOak);
        biomeMap.put(Biomes.field_76772_c, mapOak);
        biomeMap.put(Biomes.field_150578_U, mapSpruce);
        biomeMap.put(Biomes.field_150581_V, mapSpruce);
        biomeMap.put(Biomes.field_76781_i, mapOak);
        biomeMap.put(Biomes.field_150585_R, mapDarkOak);
        biomeMap.put(Biomes.field_150588_X, mapAcacia);
        biomeMap.put(Biomes.field_150587_Y, mapAcacia);
        biomeMap.put(Biomes.field_76779_k, mapStone);
        biomeMap.put(Biomes.field_150576_N, mapStone);
        biomeMap.put(Biomes.field_76780_h, mapOak);
        biomeMap.put(Biomes.field_76768_g, mapSpruce);
        biomeMap.put(Biomes.field_76784_u, mapSpruce);
        biomeMap.put(Biomes.field_185440_P, mapStone);
    }
}

