/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.grid.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.grid.IStructureWorldEventHandler;
import elec332.core.handler.ElecCoreRegistrar;
import elec332.core.world.DimensionCoordinate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public enum GridEventInputHandler {
    INSTANCE;

    private List<IStructureWorldEventHandler> cachedHandlers;
    private final Queue<DimensionCoordinate> bud = new ArrayDeque<DimensionCoordinate>();
    private final Queue<DimensionCoordinate> notify;
    private final Map<IStructureWorldEventHandler, Set<DimensionCoordinate>> chunkAdd = Maps.newHashMap();
    private final Map<IStructureWorldEventHandler, Set<DimensionCoordinate>> chunkRemove = Maps.newHashMap();

    private GridEventInputHandler() {
        this.notify = new ArrayDeque<DimensionCoordinate>();
        this.cachedHandlers = Lists.newArrayList();
    }

    public void worldBlockUpdate(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (!world.field_72995_K && newState.func_177230_c().hasTileEntity(newState) || oldState.func_177230_c().hasTileEntity(oldState)) {
            this.bud.add(new DimensionCoordinate(world, pos));
        }
    }

    public void onBlockNotify(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            if (!state.func_177230_c().hasTileEntity(state)) {
                return;
            }
            DimensionCoordinate dimCoord = new DimensionCoordinate(world, pos);
            this.notify.add(dimCoord);
        }
    }

    public void chunkLoad(Chunk chunk) {
        if (!chunk.func_177412_p().field_72995_K) {
            for (Map.Entry<IStructureWorldEventHandler, Set<DimensionCoordinate>> entry : this.chunkAdd.entrySet()) {
                for (TileEntity tile : chunk.func_177434_r().values()) {
                    if (!entry.getKey().isValidObject(tile)) continue;
                    entry.getValue().add(DimensionCoordinate.fromTileEntity(tile));
                }
            }
        }
    }

    public void chunkUnLoad(Chunk chunk) {
        if (!chunk.func_177412_p().field_72995_K) {
            for (Map.Entry<IStructureWorldEventHandler, Set<DimensionCoordinate>> entry : this.chunkRemove.entrySet()) {
                for (TileEntity tile : chunk.func_177434_r().values()) {
                    if (!entry.getKey().isValidObject(tile)) continue;
                    entry.getValue().add(DimensionCoordinate.fromTileEntity(tile));
                }
            }
        }
    }

    public void tickEnd() {
        DimensionCoordinate c;
        ArrayList l = Lists.newArrayList();
        while ((c = this.bud.poll()) != null) {
            l.add(c);
        }
        ImmutableSet bud = ImmutableSet.copyOf((Collection)l);
        l.clear();
        while ((c = this.notify.poll()) != null) {
            l.add(c);
        }
        l.removeAll((Collection<?>)bud);
        ImmutableSet notify = ImmutableSet.copyOf((Collection)l);
        for (IStructureWorldEventHandler gridHandler : this.cachedHandlers) {
            gridHandler.checkNotifyStuff((Set<DimensionCoordinate>)notify);
            gridHandler.checkBlockUpdates((Set<DimensionCoordinate>)bud);
            Set<DimensionCoordinate> chunkRemove_ = this.chunkRemove.get(gridHandler);
            HashSet chunkRemove = Sets.newHashSet(chunkRemove_);
            chunkRemove_.clear();
            gridHandler.checkChunkUnload(chunkRemove);
            chunkRemove.clear();
            Set<DimensionCoordinate> chunkAdd_ = this.chunkAdd.get(gridHandler);
            HashSet chunkAdd = Sets.newHashSet(chunkAdd_);
            chunkAdd_.clear();
            gridHandler.checkChunkLoad(chunkAdd);
            chunkAdd.clear();
            gridHandler.tick();
        }
    }

    public void worldUnload(World world) {
        if (!world.field_72995_K) {
            for (IStructureWorldEventHandler gridHandler : this.cachedHandlers) {
                gridHandler.worldUnload(world);
            }
        }
    }

    public void reloadHandlers() {
        this.cachedHandlers.clear();
        this.notify.clear();
        this.bud.clear();
        this.chunkAdd.clear();
        this.chunkRemove.clear();
        this.cachedHandlers.addAll(ElecCoreRegistrar.GRIDHANDLERS.getAllRegisteredObjects());
        for (IStructureWorldEventHandler agh : this.cachedHandlers) {
            this.chunkAdd.put(agh, Sets.newHashSet());
            this.chunkRemove.put(agh, Sets.newHashSet());
        }
    }
}

