/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.util.FluidTankWrapper;
import elec332.core.util.ItemStackHelper;
import elec332.core.util.PlayerHelper;
import elec332.core.world.WorldHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidHelper {
    @Nullable
    public static IFluidHandler getFluidHandler(IBlockAccess iba, BlockPos pos, EnumFacing facing) {
        TileEntity tile = WorldHelper.getTileAt(iba, pos);
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
        }
        return null;
    }

    public static boolean onTankActivated(EntityPlayer player, EnumHand hand, IFluidTank tank) {
        FluidTankWrapper fluidHandler = FluidTankWrapper.of(tank);
        return FluidHelper.tryDrainItem(player, hand, fluidHandler, tank.getCapacity()) || FluidHelper.tryFillItem(player, hand, fluidHandler, tank.getCapacity());
    }

    public static boolean onTankActivated(EntityPlayer player, EnumHand hand, IFluidHandler fluidHandler, int tankCapacity) {
        return FluidHelper.tryDrainItem(player, hand, fluidHandler, tankCapacity) || FluidHelper.tryFillItem(player, hand, fluidHandler, tankCapacity);
    }

    public static boolean tryDrainItem(EntityPlayer player, EnumHand hand, IFluidTank tank) {
        return FluidHelper.tryDrainItem(player, hand, (IFluidHandler)(tank instanceof IFluidHandler ? (IFluidHandler)tank : FluidTankWrapper.of(tank)), tank.getCapacity());
    }

    public static boolean tryDrainItem(EntityPlayer player, EnumHand hand, IFluidHandler fluidHandler, int capacity) {
        if (fluidHandler == null) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!ItemStackHelper.isStackValid(stack)) {
            return false;
        }
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            IFluidHandler item = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            FluidStack stack1 = item.drain(capacity, false);
            if (stack1 == null) {
                return false;
            }
            int i = fluidHandler.fill(stack1, false);
            if (i > 0) {
                if (player.func_130014_f_().field_72995_K) {
                    return true;
                }
                fluidHandler.fill(item.drain(i, !PlayerHelper.isPlayerInCreative(player)), true);
                return true;
            }
        }
        return false;
    }

    public static boolean tryFillItem(EntityPlayer player, EnumHand hand, IFluidTank tank) {
        return FluidHelper.tryFillItem(player, hand, (IFluidHandler)(tank instanceof IFluidHandler ? (IFluidHandler)tank : FluidTankWrapper.of(tank)), tank.getCapacity());
    }

    public static boolean tryFillItem(EntityPlayer player, EnumHand hand, IFluidHandler fluidHandler, int capacity) {
        if (fluidHandler == null) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!ItemStackHelper.isStackValid(stack)) {
            return false;
        }
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            IFluidHandler item = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            FluidStack fluid = fluidHandler.drain(capacity, false);
            if (fluid == null) {
                return false;
            }
            int i = item.fill(fluid, false);
            if (i > 0) {
                if (player.func_130014_f_().field_72995_K) {
                    return true;
                }
                item.fill(fluidHandler.drain(capacity, !PlayerHelper.isPlayerInCreative(player)), true);
                return true;
            }
        }
        return false;
    }
}

