/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.api.impl;

import com.xcompwiz.mystcraft.api.APIInstanceProvider;
import com.xcompwiz.mystcraft.api.exception.APIUndefined;
import com.xcompwiz.mystcraft.api.exception.APIVersionRemoved;
import com.xcompwiz.mystcraft.api.exception.APIVersionUndefined;
import com.xcompwiz.mystcraft.api.impl.WrapperBuilder;
import com.xcompwiz.mystcraft.api.impl.client.RenderAPIWrapper;
import com.xcompwiz.mystcraft.api.impl.grammar.GrammarAPIWrapper;
import com.xcompwiz.mystcraft.api.impl.instability.InstabilityAPIWrapper;
import com.xcompwiz.mystcraft.api.impl.instability.InstabilityFactWrapper;
import com.xcompwiz.mystcraft.api.impl.item.ItemFactAPIWrapper;
import com.xcompwiz.mystcraft.api.impl.linking.DimensionAPIWrapper;
import com.xcompwiz.mystcraft.api.impl.linking.LinkPropertyAPIWrapper;
import com.xcompwiz.mystcraft.api.impl.linking.LinkingAPIWrapper;
import com.xcompwiz.mystcraft.api.impl.page.PageAPIWrapper;
import com.xcompwiz.mystcraft.api.impl.symbol.SymbolAPIWrapper;
import com.xcompwiz.mystcraft.api.impl.symbol.SymbolFactoryAPIWrapper;
import com.xcompwiz.mystcraft.api.impl.symbol.SymbolValuesAPIWrapper;
import com.xcompwiz.mystcraft.api.impl.word.WordAPIWrapper;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import java.util.HashMap;

public class APIProviderImpl
implements APIInstanceProvider {
    private String modname;
    private HashMap<String, Object> instances = new HashMap();
    private static HashMap<String, HashMap<Integer, WrapperBuilder>> apiCtors;

    public APIProviderImpl(String modname) {
        this.modname = modname;
    }

    public String getOwnerMod() {
        return this.modname;
    }

    @Override
    public synchronized Object getAPIInstance(String api) throws APIUndefined, APIVersionUndefined, APIVersionRemoved {
        Object ret = this.instances.get(api);
        if (ret != null) {
            return ret;
        }
        String[] splitName = api.split("-");
        if (splitName.length != 2) {
            throw new APIUndefined(api);
        }
        String apiname = splitName[0];
        int version = Integer.parseInt(splitName[1]);
        ret = APIProviderImpl.constructAPIWrapper(this.modname, apiname, version);
        this.instances.put(api, ret);
        return ret;
    }

    public static void init() {
        if (apiCtors != null) {
            return;
        }
        apiCtors = new HashMap();
        APIProviderImpl.getCtors("dimension").put(1, new WrapperBuilder(DimensionAPIWrapper.class));
        APIProviderImpl.getCtors("grammar").put(1, new WrapperBuilder(GrammarAPIWrapper.class));
        APIProviderImpl.getCtors("instability").put(1, new WrapperBuilder(InstabilityAPIWrapper.class));
        APIProviderImpl.getCtors("instabilityfact").put(1, new WrapperBuilder(InstabilityFactWrapper.class));
        APIProviderImpl.getCtors("itemfact").put(1, new WrapperBuilder(ItemFactAPIWrapper.class));
        APIProviderImpl.getCtors("linking").put(1, new WrapperBuilder(LinkingAPIWrapper.class));
        APIProviderImpl.getCtors("linkingprop").put(1, new WrapperBuilder(LinkPropertyAPIWrapper.class));
        APIProviderImpl.getCtors("page").put(1, new WrapperBuilder(PageAPIWrapper.class));
        APIProviderImpl.getCtors("render").put(1, new WrapperBuilder(RenderAPIWrapper.class));
        APIProviderImpl.getCtors("symbol").put(1, new WrapperBuilder(SymbolAPIWrapper.class));
        APIProviderImpl.getCtors("symbolfact").put(1, new WrapperBuilder(SymbolFactoryAPIWrapper.class));
        APIProviderImpl.getCtors("symbolvals").put(1, new WrapperBuilder(SymbolValuesAPIWrapper.class));
        APIProviderImpl.getCtors("word").put(1, new WrapperBuilder(WordAPIWrapper.class));
    }

    private static HashMap<Integer, WrapperBuilder> getCtors(String apiname) {
        HashMap<Integer, WrapperBuilder> ctors = apiCtors.get(apiname);
        if (ctors == null) {
            ctors = new HashMap();
            apiCtors.put(apiname, ctors);
        }
        return ctors;
    }

    private static Object constructAPIWrapper(String owner, String apiname, int version) throws APIUndefined, APIVersionUndefined, APIVersionRemoved {
        if (apiCtors == null) {
            throw new RuntimeException("Something is broken. The Mystcraft API Provider hasn't constructed properly.");
        }
        HashMap<Integer, WrapperBuilder> ctors = apiCtors.get(apiname);
        if (ctors == null) {
            throw new APIUndefined(apiname);
        }
        if (!ctors.containsKey(version)) {
            throw new APIVersionUndefined(apiname + "-" + version);
        }
        WrapperBuilder ctor = ctors.get(version);
        if (ctor == null) {
            throw new APIVersionRemoved(apiname + "-" + version);
        }
        try {
            return ctor.newInstance(owner);
        }
        catch (Exception e) {
            LoggerUtils.error("Caught an exception while building an API wrapper. Go kick XCompWiz.", new Object[0]);
            throw new RuntimeException("Caught an exception while building an API wrapper. Go kick XCompWiz.", e);
        }
    }
}

