/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.api.impl.item;

import com.xcompwiz.mystcraft.api.item.IItemPageCollection;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.page.SortingUtils;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemFactoryImpl {
    public ItemStack buildPage() {
        return Page.createPage();
    }

    public ItemStack buildSymbolPage(ResourceLocation identifier) {
        return Page.createSymbolPage(identifier);
    }

    public ItemStack buildLinkPage(String ... properties) {
        ItemStack page = Page.createPage();
        Page.makeLinkPanel(page);
        for (String property : properties) {
            Page.addLinkProperty(page, property);
        }
        return page;
    }

    @Nonnull
    public ItemStack buildCollectionItem(String name, ResourceLocation ... tokens) {
        HashSet<GrammarGenerator.Rule> rules = new HashSet<GrammarGenerator.Rule>();
        for (ResourceLocation token : tokens) {
            List<GrammarGenerator.Rule> tokenrules;
            if (token == null || (tokenrules = GrammarGenerator.getAllRules(token)) == null) continue;
            rules.addAll(tokenrules);
        }
        HashSet<IAgeSymbol> symbolsSet = new HashSet<IAgeSymbol>();
        for (GrammarGenerator.Rule rule : rules) {
            for (ResourceLocation tok : rule.getValues()) {
                IAgeSymbol symbol2;
                if (!SymbolManager.hasBinding(tok) || (symbol2 = SymbolManager.getAgeSymbol(tok)) == null) continue;
                symbolsSet.add(symbol2);
            }
        }
        ArrayList<IAgeSymbol> symbols = new ArrayList<IAgeSymbol>(symbolsSet);
        symbols.sort(SortingUtils.ComparatorSymbolAlphabetical.instance);
        ItemStack itemstack = new ItemStack(ModItems.portfolio, 1, 0);
        IItemPageCollection item = (IItemPageCollection)itemstack.func_77973_b();
        item.setDisplayName(null, itemstack, name);
        for (IAgeSymbol symbol2 : symbols) {
            item.addPage(null, itemstack, Page.createSymbolPage(symbol2.getRegistryName()));
        }
        return itemstack;
    }

    public ItemStack buildCollectionItem(String name, ItemStack ... pages) {
        ItemStack itemstack = new ItemStack(ModItems.portfolio, 1, 0);
        IItemPageCollection item = (IItemPageCollection)itemstack.func_77973_b();
        item.setDisplayName(null, itemstack, name);
        for (ItemStack page : pages) {
            if (page.func_190926_b() || !(page.func_77973_b() instanceof ItemPage)) continue;
            item.addPage(null, itemstack, page.func_77946_l());
        }
        return itemstack;
    }
}

