/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.api.symbol;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;

public final class BlockCategory {
    private static HashMap<ResourceLocation, BlockCategory> categories = new HashMap();
    public static final BlockCategory ANY = new BlockCategory(new ResourceLocation("mystcraft", "BlockAny"));
    public static final BlockCategory SOLID = new BlockCategory(new ResourceLocation("mystcraft", "BlockSolid"));
    public static final BlockCategory FLUID = new BlockCategory(new ResourceLocation("mystcraft", "BlockFluid"));
    public static final BlockCategory GAS = new BlockCategory(new ResourceLocation("mystcraft", "BlockGas"));
    public static final BlockCategory TERRAIN = new BlockCategory(new ResourceLocation("mystcraft", "BlockTerrain"));
    public static final BlockCategory STRUCTURE = new BlockCategory(new ResourceLocation("mystcraft", "BlockStructure"));
    public static final BlockCategory ORGANIC = new BlockCategory(new ResourceLocation("mystcraft", "BlockOrganic"));
    public static final BlockCategory CRYSTAL = new BlockCategory(new ResourceLocation("mystcraft", "BlockCrystal"));
    public static final BlockCategory SEA = new BlockCategory(new ResourceLocation("mystcraft", "BlockSea"));
    private final ResourceLocation name;

    public static Collection<BlockCategory> getCategories() {
        return Collections.unmodifiableCollection(categories.values());
    }

    private BlockCategory(ResourceLocation name) {
        this.name = name;
        categories.put(name, this);
    }

    public static BlockCategory registerBlockCategory(ResourceLocation name) {
        if (categories.containsKey(name)) {
            return categories.get(name);
        }
        return new BlockCategory(name);
    }

    public static BlockCategory getBlockCategory(ResourceLocation name) {
        if (categories.containsKey(name)) {
            return categories.get(name);
        }
        return null;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public ResourceLocation getGrammarBinding() {
        return this.name;
    }
}

