/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client.gui.element;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.client.gui.GuiUtils;
import com.xcompwiz.mystcraft.client.gui.element.GuiElement;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementTextField;
import com.xcompwiz.mystcraft.client.gui.element.GuiElementVSlider;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElementPageSurface
extends GuiElement
implements GuiElementTextField.IGuiOnTextChange {
    public static final float pagewidth = 30.0f;
    public static final float pageheight = 40.0f;
    private IGuiPositionedPagesProvider pagesProvider;
    private float pageWidth;
    private float pageHeight;
    private PositionableItem hoverpage;
    private List<String> hovertext = new ArrayList<String>();
    private int hoverslot = 0;
    private GuiElementVSlider scrollbar;
    private boolean mousedown;
    private String searchtext;
    private boolean mouseOverPageArea = false;

    public GuiElementPageSurface(IGuiPositionedPagesProvider pagesProvider, Minecraft mc, int left, int top, int width, int height) {
        super(left, top, width, height);
        this.mc = mc;
        this.pagesProvider = pagesProvider;
        this.pageWidth = 30.0f;
        this.pageHeight = 40.0f;
        this.mousedown = false;
        this.scrollbar = new GuiElementVSlider(this.xSize - 20, 0, 20, this.ySize);
        this.addElement(this.scrollbar);
    }

    @Override
    public void _handleMouseInput() {
        if (!this.mouseOverPageArea) {
            return;
        }
        this.scrollbar.handleMouseScroll();
    }

    @Override
    public boolean _onMouseDown(int mouseX, int mouseY, int button) {
        if (this.contains(mouseX, mouseY)) {
            if (this.pagesProvider == null) {
                return false;
            }
            if (!this.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                List<PositionableItem> pages = this.getPages();
                if (pages == null) {
                    return false;
                }
                this.pagesProvider.place(this.hoverslot, button == 1);
                return true;
            }
            if (this.hoverpage != null && button == 2) {
                return true;
            }
            if (this.hoverpage != null && button == 0) {
                this.pagesProvider.pickup(this.hoverpage);
                return true;
            }
            this.mousedown = true;
        }
        return false;
    }

    @Override
    public boolean _onMouseUp(int i, int j, int k) {
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        if (this.pagesProvider != null && GuiUtils.contains(i, j, guiLeft, guiTop, this.xSize - 20, this.ySize) && this.hoverpage != null && k == 1 && this.mousedown) {
            this.pagesProvider.copy(this.hoverpage);
        }
        this.mousedown = false;
        return false;
    }

    @Override
    public List<String> _getTooltipInfo() {
        if (this.hovertext != null && this.hovertext.size() > 0) {
            return this.hovertext;
        }
        return super._getTooltipInfo();
    }

    @Override
    public void _renderBackground(float f, int mouseX, int mouseY) {
        int guiLeft = this.getLeft();
        int guiTop = this.getTop();
        this.mouseOverPageArea = GuiUtils.contains(mouseX, mouseY, guiLeft, guiTop, this.xSize - 20, this.ySize);
        this.hovertext.clear();
        this.hoverpage = null;
        int color = -1442840576;
        GuiElementPageSurface.func_73734_a((int)guiLeft, (int)guiTop, (int)(guiLeft + this.xSize - 20), (int)(guiTop + this.ySize), (int)color);
        GuiUtils.drawGradientRect(guiLeft, guiTop, guiLeft + this.xSize - 20, guiTop + this.ySize, 0, 0, this.getZLevel());
        GlStateManager.func_179143_c((int)518);
        GuiUtils.startGlScissor(guiLeft, guiTop, this.xSize, this.ySize - 1);
        this.setZLevel(1.0f);
        GlStateManager.func_179094_E();
        int currentScroll = -this.scrollbar.getCurrentPos();
        List<PositionableItem> pages = this.getPages();
        int maxScroll = 0;
        float rootX = guiLeft;
        float rootY = guiTop + currentScroll;
        if (pages != null) {
            float pagexSize = this.pageWidth;
            float pageySize = this.pageHeight;
            for (PositionableItem positionable : pages) {
                ItemStack page = positionable.itemstack;
                float pageX = positionable.x;
                float pageY = positionable.y;
                if (pageY + this.pageHeight * 2.0f - (float)this.ySize > (float)maxScroll) {
                    maxScroll = (int)(pageY + this.pageHeight * 2.0f + 6.0f - (float)this.ySize);
                }
                if (rootY + pageY < (float)guiTop - this.pageHeight || rootY + pageY > (float)(guiTop + this.ySize)) continue;
                String displayname = this.getDisplayName(page);
                if (displayname != null && this.searchtext != null && this.searchtext.length() > 0 && !displayname.toLowerCase().contains(this.searchtext.toLowerCase())) {
                    page = ItemStack.field_190927_a;
                }
                if (positionable.count > 0) {
                    GuiUtils.drawPage(this.mc.field_71446_o, this.getZLevel(), page, pagexSize, pageySize, rootX + pageX, rootY + pageY);
                } else {
                    GuiUtils.drawPage(this.mc.field_71446_o, this.getZLevel(), ItemStack.field_190927_a, pagexSize, pageySize, rootX + pageX, rootY + pageY);
                }
                if (positionable.count > 1) {
                    GuiUtils.drawScaledText("" + positionable.count, (int)(rootX + pageX), (int)(rootY + pageY + this.pageHeight - 7.0f), 20, 10, 0xFFFFFF);
                }
                if (!this.mouseOverPageArea) continue;
                this.testMouseOver(positionable, page, displayname, mouseX, mouseY, (int)(rootX + pageX), (int)(rootY + pageY), (int)pagexSize, (int)pageySize);
            }
        }
        if (this.hoverpage == null && pages != null && this.mouseOverPageArea && !this.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            int rowSize = (int)((float)this.xSize / this.pageWidth);
            float x = mouseX - guiLeft;
            float y = mouseY - currentScroll - guiTop;
            this.hoverslot = (int)(x / this.pageWidth) + (int)(y / this.pageHeight) * rowSize;
            int count = pages.size();
            float xStep = this.pageWidth + 1.0f;
            float yStep = this.pageHeight + 1.0f;
            for (int i = count; i <= this.hoverslot; ++i) {
                float pageX = (float)(i % rowSize) * xStep;
                float pageY = (float)(i / rowSize) * yStep;
                if (pageY + this.pageHeight * 2.0f - (float)this.ySize > (float)maxScroll) {
                    maxScroll = (int)(pageY + this.pageHeight * 2.0f + 6.0f - (float)this.ySize);
                }
                GuiUtils.drawPage(this.mc.field_71446_o, this.getZLevel(), ItemStack.field_190927_a, this.pageWidth, this.pageHeight, rootX + pageX, rootY + pageY);
            }
        }
        this.scrollbar.setMaxScroll(maxScroll);
        GlStateManager.func_179121_F();
        GlStateManager.func_179143_c((int)515);
        this.setZLevel(2.0f);
        GuiUtils.endGlScissor();
    }

    private String getDisplayName(ItemStack page) {
        ResourceLocation symbolRes = Page.getSymbol(page);
        if (symbolRes == null) {
            return null;
        }
        IAgeSymbol symbol2 = SymbolManager.getAgeSymbol(symbolRes);
        if (symbol2 != null) {
            return symbol2.getLocalizedName();
        }
        return symbolRes.func_110623_a();
    }

    private boolean testMouseOver(PositionableItem positionable, ItemStack page, String displayname, int mouseX, int mouseY, int i, int j, int pagexSize, int pageySize) {
        if (!GuiUtils.contains(mouseX, mouseY, i, j, pagexSize, pageySize)) {
            return false;
        }
        if (this.hoverpage == positionable) {
            return true;
        }
        if (page.func_190926_b()) {
            return true;
        }
        this.hoverpage = positionable;
        this.hoverslot = this.hoverpage.slotId;
        this.hovertext.clear();
        Page.getTooltip(page, this.hovertext);
        if (displayname != null) {
            this.hovertext.add(displayname);
        }
        GuiUtils.onItemTooltip(page, this.pagesProvider == null ? null : this.pagesProvider.getItemStack(), this.mc.field_71439_g, this.hovertext, ITooltipFlag.TooltipFlags.NORMAL);
        return true;
    }

    private List<PositionableItem> getPages() {
        if (this.pagesProvider == null) {
            return null;
        }
        return this.pagesProvider.getPositionedPages();
    }

    @Override
    public void onTextChange(GuiElementTextField caller, String text) {
        this.searchtext = text;
    }

    public static interface IGuiPositionedPagesProvider {
        public ItemStack getItemStack();

        public List<PositionableItem> getPositionedPages();

        public void place(int var1, boolean var2);

        public void pickup(PositionableItem var1);

        public void copy(PositionableItem var1);
    }

    public static class PositionableItem {
        public int slotId;
        @Nonnull
        public ItemStack itemstack = ItemStack.field_190927_a;
        public float x;
        public float y;
        public int count = 1;
    }
}

