/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.grammar;

import com.xcompwiz.mystcraft.utility.WeightedItemSelector;
import com.xcompwiz.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.ResourceLocation;

public class GrammarGenerator {
    public static final Map<ResourceLocation, RankData> ranks = new HashMap<ResourceLocation, RankData>();
    private static HashMap<ResourceLocation, List<Rule>> mappings = new HashMap();
    private static HashMap<ResourceLocation, List<Rule>> reverseLookup = new HashMap();
    private static HashMap<ResourceLocation, HashMap<ResourceLocation, List<List<Rule>>>> shortestpaths;
    private static boolean profile_pathbuilder;

    public static void registerRule(Rule rule) {
        if (rule.parent == null) {
            throw new RuntimeException("Invalid CFG Rule.  Requires parent to expand.");
        }
        if (shortestpaths != null) {
            throw new RuntimeException("You must register your rules before the grammar is finalized! (before Mystcraft's post-init)");
        }
        CollectionUtils.getOrCreateElement(rule.parent, mappings).add(rule);
        for (ResourceLocation value : rule.values) {
            CollectionUtils.getOrCreateElement(value, reverseLookup).add(rule);
        }
        if (rule.rank != null) {
            RankData rankdata = ranks.get(rule.getParent());
            if (rankdata == null) {
                rankdata = new RankData();
                ranks.put(rule.getParent(), rankdata);
            }
            while (rankdata.ranksizes.size() <= rule.rank) {
                rankdata.ranksizes.add(0);
            }
            rankdata.ranksizes.set(rule.rank, rankdata.ranksizes.get(rule.rank) + 1);
        }
    }

    public static List<Rule> getParentRules(ResourceLocation str) {
        List<Rule> rules = CollectionUtils.getOrCreateElement(str, reverseLookup);
        return Collections.unmodifiableList(rules);
    }

    public static List<Rule> getAllRules(ResourceLocation str) {
        List<Rule> mapping = mappings.get(str);
        if (mapping == null) {
            return null;
        }
        return Collections.unmodifiableList(mapping);
    }

    public static Rule getRandomRule(ResourceLocation str, Random rand) {
        List<Rule> rules = mappings.get(str);
        if (rules == null || rules.size() == 0) {
            return null;
        }
        return WeightedItemSelector.getRandomItem(rand, rules);
    }

    public static List<ResourceLocation> explore(ResourceLocation str, Random rand) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        Rule rule = GrammarGenerator.getRandomRule(str, rand);
        if (rule == null) {
            list.add(str);
            return list;
        }
        if (rule.size() == 0) {
            return list;
        }
        List<ResourceLocation> result = rule.getValues();
        for (ResourceLocation t : result) {
            list.addAll(GrammarGenerator.explore(t, rand));
        }
        return list;
    }

    public static List<List<Rule>> getShortestPaths(ResourceLocation subtree_token, ResourceLocation node_token) {
        if (shortestpaths == null) {
            throw new RuntimeException("Somebody's trying to use the grammar before we're done building it!");
        }
        List<List<Rule>> paths = null;
        HashMap<ResourceLocation, List<List<Rule>>> allpaths = shortestpaths.get(subtree_token);
        if (allpaths != null) {
            paths = allpaths.get(node_token);
        }
        if (paths == null) {
            return null;
        }
        return Collections.unmodifiableList(paths);
    }

    private static HashMap<ResourceLocation, List<List<Rule>>> getOrCalculatePaths(HashMap<ResourceLocation, HashMap<ResourceLocation, List<List<Rule>>>> shortestpaths, ResourceLocation token) {
        HashMap<Object, List<List<Rule>>> allpaths = shortestpaths.get(token);
        if (allpaths != null) {
            return allpaths;
        }
        allpaths = new HashMap();
        List<Rule> producers = reverseLookup.get(token);
        LinkedList<VisitPair> tovisit = new LinkedList<VisitPair>();
        if (producers != null) {
            for (Rule rule : producers) {
                tovisit.add(new VisitPair(rule.parent, Collections.unmodifiableList(CollectionUtils.buildList(rule))));
            }
        }
        while (tovisit.size() > 0) {
            VisitPair elem = (VisitPair)tovisit.remove(0);
            ResourceLocation target = elem.target;
            if (target.equals((Object)token)) continue;
            List<Rule> path = elem.path;
            List<List<Rule>> paths_to_target = CollectionUtils.getOrCreateElement(target, allpaths);
            if (paths_to_target.size() > 0 && paths_to_target.get(0).size() > path.size()) {
                paths_to_target.clear();
            }
            if (paths_to_target.size() != 0 && paths_to_target.get(0).size() != path.size()) continue;
            paths_to_target.add(path);
            List<Rule> target_producers = reverseLookup.get(target);
            if (target_producers == null) continue;
            for (Rule producer : target_producers) {
                tovisit.add(new VisitPair(producer.parent, Collections.unmodifiableList(CollectionUtils.buildList(path, null, producer))));
            }
        }
        shortestpaths.put(token, allpaths);
        return allpaths;
    }

    public static void buildGrammar() {
        GrammarGenerator.buildShortestPaths();
        GrammarGenerator.buildRankWeights();
    }

    private static void buildShortestPaths() {
        long timestart = System.currentTimeMillis();
        if (profile_pathbuilder) {
            System.out.println("Starting buildShortestPaths");
        }
        shortestpaths = new HashMap();
        for (Map.Entry<ResourceLocation, List<Rule>> lookup : reverseLookup.entrySet()) {
            ResourceLocation token = lookup.getKey();
            if (shortestpaths.containsKey(token)) continue;
            GrammarGenerator.getOrCalculatePaths(shortestpaths, token);
        }
        long timeend = System.currentTimeMillis();
        if (profile_pathbuilder) {
            System.out.println("buildShortestPaths Exectution Time: " + (timeend - timestart));
        }
    }

    private static void buildRankWeights() {
        boolean step = true;
        for (RankData rankdata : ranks.values()) {
            rankdata.rankweights = new HashMap();
            int weight = 1;
            int lasttotal = 0;
            for (int i = rankdata.ranksizes.size() - 1; i >= 0; --i) {
                int count = rankdata.ranksizes.get(i);
                if (weight != 1 && count > 0) {
                    weight = Math.max(weight, lasttotal / count + 1);
                }
                rankdata.rankweights.put(i, weight);
                lasttotal = count * weight;
                ++weight;
            }
        }
    }

    public static String pathToString(List<Rule> path) {
        StringBuilder out = new StringBuilder();
        for (Rule rule : path) {
            if (!out.toString().equals("")) {
                out.append(" - ");
            }
            out.append(rule.parent);
        }
        return out.toString();
    }

    public static void testShortestPaths(ResourceLocation token1, ResourceLocation token2) {
        System.out.println(token1 + " - " + token2);
        List<List<Rule>> paths = GrammarGenerator.getShortestPaths(token1, token2);
        if (paths == null) {
            System.out.println("no path");
            return;
        }
        for (List<Rule> path : paths) {
            System.out.println("path: " + GrammarGenerator.pathToString(path));
        }
    }

    static {
        profile_pathbuilder = false;
    }

    public static class VisitPair {
        public ResourceLocation target;
        public List<Rule> path;

        public VisitPair(ResourceLocation target, List<Rule> path) {
            this.target = target;
            this.path = path;
        }
    }

    public static final class Rule
    implements WeightedItemSelector.IWeightedItem {
        private final ResourceLocation parent;
        private final List<ResourceLocation> values;
        private final Integer rank;

        public Rule(ResourceLocation parent, List<ResourceLocation> values, Integer rank) {
            this.parent = parent;
            this.values = Collections.unmodifiableList(values);
            this.rank = rank;
        }

        @Override
        public float getWeight() {
            if (this.rank == null) {
                return 0.0f;
            }
            return GrammarGenerator.ranks.get((Object)this.parent).rankweights.get(this.rank).intValue();
        }

        public ResourceLocation getParent() {
            return this.parent;
        }

        public List<ResourceLocation> getValues() {
            if (this.values == null) {
                return null;
            }
            return this.values;
        }

        public int size() {
            if (this.values == null) {
                return 0;
            }
            return this.values.size();
        }
    }

    public static final class RankData {
        public ArrayList<Integer> ranksizes = new ArrayList();
        public HashMap<Integer, Integer> rankweights = null;
    }
}

