/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.item;

import com.xcompwiz.mystcraft.api.item.IItemPageProvider;
import com.xcompwiz.mystcraft.api.item.IItemRenameable;
import com.xcompwiz.mystcraft.api.item.IItemWritable;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.item.IItemOnLoadable;
import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.linking.LinkOptions;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemAgebook
extends ItemLinking
implements IItemRenameable,
IItemWritable,
IItemPageProvider,
IItemOnLoadable {
    public ItemAgebook() {
        this.func_77655_b("myst.agebook");
        this.func_77637_a(MystcraftCommonProxy.tabMystCommon);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
        }
    }

    @Nonnull
    public EnumRarity func_77613_e(@Nonnull ItemStack itemstack) {
        return itemstack.func_77948_v() ? EnumRarity.RARE : EnumRarity.EPIC;
    }

    @Override
    protected void initialize(World world, @Nonnull ItemStack itemstack, Entity entity) {
        if (itemstack.func_77978_p() == null) {
            itemstack.func_77982_d(new NBTTagCompound());
            LinkOptions.setFlag(itemstack.func_77978_p(), "Generate Platform", true);
            this.addPages(itemstack, this.getDefaultPages(itemstack));
        }
    }

    @Override
    public void validate(World worldObj, @Nonnull ItemStack itemstack, Entity entity) {
        super.validate(worldObj, itemstack, entity);
        if (itemstack.func_77978_p() != null && !itemstack.func_77978_p().func_74764_b("Pages")) {
            this.addPages(itemstack, this.getDefaultPages(itemstack));
        }
    }

    private Collection<ItemStack> getDefaultPages(@Nonnull ItemStack itemstack) {
        Collection<ItemStack> collection = Collections.singleton(Page.createLinkPage());
        Integer dimid = LinkOptions.getDimensionUID(itemstack.func_77978_p());
        if (dimid == null) {
            return collection;
        }
        AgeData data = AgeData.getAge((int)dimid, false);
        if (data == null) {
            return collection;
        }
        collection = data.getPages();
        return collection;
    }

    public static void initializeCompound(@Nonnull ItemStack itemstack, int dimId, AgeData agedata) {
        itemstack.func_77982_d(new NBTTagCompound());
        LinkOptions.setDimensionUID(itemstack.func_77978_p(), dimId);
        LinkOptions.setUUID(itemstack.func_77978_p(), agedata.getUUID());
        LinkOptions.setDisplayName(itemstack.func_77978_p(), agedata.getAgeName());
        LinkOptions.setFlag(itemstack.func_77978_p(), "Generate Platform", true);
        ((ItemAgebook)itemstack.func_77973_b()).addPages(itemstack, agedata.getPages());
    }

    public static void create(@Nonnull ItemStack agebook, EntityPlayer player, List<ItemStack> pages, String pendingtitle) {
        agebook.func_77982_d(new NBTTagCompound());
        ((ItemAgebook)agebook.func_77973_b()).addPages(agebook, pages);
        ((ItemAgebook)agebook.func_77973_b()).addAuthor(agebook, player);
        ((ItemAgebook)agebook.func_77973_b()).setDisplayName(player, agebook, pendingtitle);
        if (pages.isEmpty()) {
            return;
        }
        ItemStack linkpanel = pages.get(0);
        if (Page.isLinkPanel(linkpanel)) {
            Page.applyLinkPanel(linkpanel, agebook);
        }
    }

    public static boolean isNewAgebook(@Nonnull ItemStack itemstack) {
        if (!(itemstack.func_77973_b() instanceof ItemAgebook)) {
            return false;
        }
        if (itemstack.func_77978_p() == null) {
            return false;
        }
        Integer dimid = LinkOptions.getDimensionUID(itemstack.func_77978_p());
        if (dimid != null) {
            return false;
        }
        List<ItemStack> pages = ((ItemAgebook)itemstack.func_77973_b()).getPageList(null, itemstack);
        return !pages.isEmpty() && Page.isLinkPanel(pages.get(0));
    }

    public void func_77622_d(@Nonnull ItemStack stack, World world, EntityPlayer player) {
    }

    @Override
    public void activate(@Nonnull ItemStack itemstack, World worldObj, Entity entity) {
        if (worldObj.field_72995_K) {
            return;
        }
        this.checkFirstLink(itemstack, worldObj, entity);
        super.activate(itemstack, worldObj, entity);
    }

    private void checkFirstLink(@Nonnull ItemStack itemstack, World worldObj, Entity entity) {
        if (itemstack.func_77978_p() == null) {
            return;
        }
        Integer dimid = LinkOptions.getDimensionUID(itemstack.func_77978_p());
        if (dimid != null) {
            return;
        }
        dimid = DimensionUtils.createAge();
        AgeData agedata = AgeData.getAge((int)dimid, false);
        LinkOptions.setDimensionUID(itemstack.func_77978_p(), dimid);
        LinkOptions.setUUID(itemstack.func_77978_p(), agedata.getUUID());
        agedata.setAgeName(LinkOptions.getDisplayName(itemstack.func_77978_p()));
        String seed = LinkOptions.getProperty(itemstack.func_77978_p(), "Seed");
        if (seed != null) {
            agedata.setSeed(Long.parseLong(seed));
        } else {
            LinkOptions.setProperty(itemstack.func_77978_p(), "Seed", Long.toString(agedata.getSeed()));
        }
        this.updatePageList(itemstack);
        agedata.setPages(this.getPageList(null, itemstack));
    }

    @Override
    public String getDisplayName(EntityPlayer player, @Nonnull ItemStack itemstack) {
        return LinkOptions.getDisplayName(itemstack.func_77978_p());
    }

    @Override
    public void setDisplayName(EntityPlayer player, @Nonnull ItemStack itemstack, String name) {
        LinkOptions.setDisplayName(itemstack.func_77978_p(), name);
        AgeData data = this.getAgeData(itemstack, player.field_70170_p.field_72995_K);
        if (data != null) {
            data.setAgeName(name);
        }
    }

    public void setSeed(EntityPlayer player, @Nonnull ItemStack itemstack, long seed) {
        AgeData data = this.getAgeData(itemstack, player.field_70170_p.field_72995_K);
        if (data != null) {
            data.setSeed(seed);
            LinkOptions.setProperty(itemstack.func_77978_p(), "Seed", Long.toString(data.getSeed()));
        } else {
            LinkOptions.setProperty(itemstack.func_77978_p(), "Seed", Long.toString(seed));
        }
    }

    @Override
    public boolean writeSymbol(EntityPlayer player, @Nonnull ItemStack itemstack, ResourceLocation symbol2) {
        if (this.isVisited(itemstack, player.field_70170_p.field_72995_K)) {
            return false;
        }
        if (itemstack.func_77978_p() == null) {
            return false;
        }
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        ArrayList<ItemStack> list = NBTUtils.readItemStackCollection(nbttagcompound.func_150295_c("Pages", 10), new ArrayList());
        for (ItemStack page : list) {
            if (!Page.isBlank(page)) continue;
            Page.setSymbol(page, symbol2);
            nbttagcompound.func_74782_a("Pages", (NBTBase)NBTUtils.writeItemStackCollection(new NBTTagList(), list));
            this.addAuthor(itemstack, player);
            return true;
        }
        return false;
    }

    private void addPages(@Nonnull ItemStack itemstack, Collection<ItemStack> pages) {
        if (itemstack.func_77978_p() == null) {
            return;
        }
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        ArrayList<ItemStack> list = NBTUtils.readItemStackCollection(nbttagcompound.func_150295_c("Pages", 10), new ArrayList());
        list.addAll(pages);
        nbttagcompound.func_74782_a("Pages", (NBTBase)NBTUtils.writeItemStackCollection(new NBTTagList(), list));
    }

    @Override
    public List<ItemStack> getPageList(@Nullable EntityPlayer player, @Nonnull ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return Collections.emptyList();
        }
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        return NBTUtils.readItemStackCollection(nbttagcompound.func_150295_c("Pages", 10), new ArrayList());
    }

    private void setPageList(@Nonnull ItemStack itemstack, List<ItemStack> pagelist) {
        if (itemstack.func_77978_p() == null) {
            return;
        }
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        nbttagcompound.func_74782_a("Pages", (NBTBase)NBTUtils.writeItemStackCollection(new NBTTagList(), pagelist));
    }

    private void updatePageList(@Nonnull ItemStack itemstack) {
        this.setPageList(itemstack, SymbolRemappings.remap(this.getPageList(null, itemstack)));
    }

    private void addAuthor(@Nonnull ItemStack itemstack, EntityPlayer player) {
        String playerName;
        if (itemstack.func_77978_p() == null) {
            return;
        }
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        ArrayList<String> list = NBTUtils.readStringCollection(nbttagcompound.func_150295_c("Authors", 8), new ArrayList());
        if (!list.contains(playerName = player.getDisplayNameString())) {
            list.add(playerName);
            nbttagcompound.func_74782_a("Authors", (NBTBase)NBTUtils.writeStringCollection(new NBTTagList(), list));
        }
    }

    @Override
    public Collection<String> getAuthors(@Nonnull ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return Collections.emptyList();
        }
        NBTTagCompound nbttagcompound = itemstack.func_77978_p();
        return NBTUtils.readStringCollection(nbttagcompound.func_150295_c("Authors", 8), new ArrayList());
    }

    @Nullable
    private AgeData getAgeData(ItemStack itemstack, boolean isRemote) {
        if (itemstack.func_77978_p() == null) {
            return null;
        }
        Integer uid = LinkOptions.getDimensionUID(itemstack.func_77978_p());
        if (uid == null) {
            return null;
        }
        return AgeData.getAge((int)uid, isRemote);
    }

    private boolean isVisited(ItemStack itemstack, boolean isRemote) {
        AgeData agedata = this.getAgeData(itemstack, isRemote);
        return agedata != null && agedata.isVisited();
    }

    @Override
    @Nonnull
    public ItemStack onLoad(@Nonnull ItemStack itemstack) {
        this.updatePageList(itemstack);
        this.initialize(null, itemstack, null);
        this.validate(null, itemstack, null);
        if (this.getPageList(null, itemstack).isEmpty()) {
            this.addPages(itemstack, this.getDefaultPages(itemstack));
        }
        return itemstack;
    }
}

