/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.network.packet;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.network.packet.PacketBase;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MPacketDimensions
extends PacketBase<MPacketDimensions, MPacketDimensions> {
    private List<Integer> dimIds = new LinkedList<Integer>();

    public MPacketDimensions() {
    }

    public MPacketDimensions(Integer ... ids) {
        this.dimIds = Arrays.asList(ids);
    }

    public MPacketDimensions(Collection<Integer> ids) {
        this.dimIds.addAll(ids);
    }

    public void fromBytes(ByteBuf buf) {
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.dimIds.add(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimIds.size());
        for (int id : this.dimIds) {
            buf.writeInt(id);
        }
    }

    public MPacketDimensions onMessage(MPacketDimensions message, MessageContext ctx) {
        if (Mystcraft.registeredDims == null) {
            Mystcraft.registeredDims = new HashSet<Integer>();
        }
        for (int id : message.dimIds) {
            if (Mystcraft.registeredDims.contains(id)) continue;
            Mystcraft.registeredDims.add(id);
            DimensionManager.registerDimension((int)id, (DimensionType)Mystcraft.dimensionType);
        }
        return null;
    }
}

