/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.config.MystConfig;
import com.xcompwiz.mystcraft.grammar.GrammarGenerator;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.SymbolProfiler;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import com.xcompwiz.mystcraft.utility.WeightedItemSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;

public class SymbolManager {
    private static ResourceLocation SYMBOL_REGISTRY_NAME = new ResourceLocation("mystcraft", "symbol_registry");
    private static IForgeRegistryModifiable<IAgeSymbol> SYMBOL_REGISTRY = null;
    private static SymbolProfiler symbolProfiler = new SymbolProfiler();
    private static Set<ResourceLocation> errored = new HashSet<ResourceLocation>();
    private static Set<ResourceLocation> warned = new HashSet<ResourceLocation>();
    private static Set<ResourceLocation> blacklist = new HashSet<ResourceLocation>();
    private static Configuration config;
    private static HashMap<ResourceLocation, Integer> cardranks;
    private static ArrayList<Integer> cardranksizes;
    private static HashMap<Integer, Integer> cardrankweights;
    private static HashMap<ResourceLocation, Integer> maxTreasureStackOverrides;
    private static HashMap<ResourceLocation, Boolean> tradeableOverrides;
    private static HashMap<ResourceLocation, List<ItemStack>> tradeItemOverrides;
    private static HashMap<Integer, Integer> defaultMaxStacks;

    public static void buildRegistry() {
        if (SYMBOL_REGISTRY != null) {
            return;
        }
        RegistryBuilder builder = new RegistryBuilder();
        builder.setName(SYMBOL_REGISTRY_NAME).disableSaving();
        builder.setType(IAgeSymbol.class).allowModification();
        builder.add((IForgeRegistry.AddCallback)new SymbolAddListener());
        IForgeRegistry registry = builder.create();
        if (!(registry instanceof IForgeRegistryModifiable)) {
            throw new IllegalArgumentException("Forge registry builder didn't build a modifiable registry! Did something in forge change internally?");
        }
        SYMBOL_REGISTRY = (IForgeRegistryModifiable)registry;
    }

    public static void blackListSymbol(ResourceLocation identifier) {
        blacklist.add(identifier);
        IAgeSymbol symbol2 = (IAgeSymbol)SYMBOL_REGISTRY.getValue(identifier);
        if (symbol2 != null) {
            symbolProfiler.remove(symbol2);
        }
    }

    public static void setConfig(MystConfig mystconfig) {
        config = mystconfig;
    }

    public static boolean tryAddSymbol(IAgeSymbol symbol2) {
        return SymbolManager.tryAddSymbol(symbol2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryAddSymbol(IAgeSymbol symbol2, boolean addForRegistration) {
        boolean enabled = true;
        if (config != null && symbol2.generatesConfigOption() && !config.get("symbol." + symbol2.getRegistryName().func_110624_b(), symbol2.getRegistryName().func_110623_a().toLowerCase().replace(' ', '_') + ".enabled", enabled).getBoolean(enabled)) {
            return false;
        }
        if (SymbolRemappings.hasRemapping(symbol2.getRegistryName())) {
            LoggerUtils.error(String.format("%s has a remapping binding.  No symbol can be bound to this name.", symbol2.getRegistryName().toString()), new Object[0]);
            return false;
        }
        if (blacklist.contains(symbol2.getRegistryName())) {
            LoggerUtils.info(String.format("Symbol %s is turned off by blacklist.", symbol2.getRegistryName().toString()), new Object[0]);
            return false;
        }
        symbolProfiler.startProfiling(symbol2);
        try {
            symbol2.registerLogic(symbolProfiler, 0L);
        }
        catch (Exception e) {
            LoggerUtils.error(String.format("Exception encountered when profiling symbol with identifier %s.", symbol2.getRegistryName().toString()), new Object[0]);
            LoggerUtils.error(e.toString(), new Object[0]);
            e.printStackTrace();
            SymbolManager.blackListSymbol(symbol2.getRegistryName());
            errored.add(symbol2.getRegistryName());
        }
        finally {
            symbolProfiler.endProfiling(symbol2);
            if (config != null && config.hasChanged()) {
                config.save();
            }
        }
        if (addForRegistration) {
            SYMBOL_REGISTRY.register((IForgeRegistryEntry)symbol2);
        }
        return true;
    }

    public static Set<ResourceLocation> getErroredSymbols() {
        return errored;
    }

    public static IAgeSymbol getAgeSymbol(ResourceLocation id) {
        if (id == null) {
            return null;
        }
        IAgeSymbol symbol2 = null;
        if (!blacklist.contains(id)) {
            symbol2 = (IAgeSymbol)SYMBOL_REGISTRY.getValue(id);
        }
        if (symbol2 == null && warned.add(id)) {
            LoggerUtils.error(String.format("No Symbol match for identifier %s.  Are all of the Age Symbols loaded?", id.toString()), new Object[0]);
        }
        return symbol2;
    }

    public static boolean hasBinding(ResourceLocation id) {
        return !blacklist.contains(id) && SYMBOL_REGISTRY.containsKey(id);
    }

    public static String getSymbolOwner(ResourceLocation identifier) {
        if (blacklist.contains(identifier)) {
            return null;
        }
        IAgeSymbol symbol2 = (IAgeSymbol)SYMBOL_REGISTRY.getValue(identifier);
        return symbol2 == null ? null : symbol2.getRegistryName().func_110624_b();
    }

    public static ArrayList<IAgeSymbol> getAgeSymbols() {
        ArrayList<IAgeSymbol> symbols = new ArrayList<IAgeSymbol>();
        for (IAgeSymbol s : SYMBOL_REGISTRY.getValues()) {
            if (blacklist.contains(s.getRegistryName())) continue;
            symbols.add(s);
        }
        return symbols;
    }

    public static HashSet<IAgeSymbol> findAgeSymbolsImplementing(Class<?> Interface) {
        return symbolProfiler.getSymbolsProviding(Interface);
    }

    public static IAgeSymbol findAgeSymbolImplementing(Random rand, Class<?> instance) {
        return WeightedItemSelector.getRandomItem(rand, SymbolManager.findAgeSymbolsImplementing(instance));
    }

    public static Collection<IAgeSymbol> getSymbolsByRank(Integer exact) {
        return SymbolManager.getSymbolsByRank(exact, exact);
    }

    public static Collection<IAgeSymbol> getSymbolsByRank(Integer min, Integer max) {
        ArrayList<IAgeSymbol> set = new ArrayList<IAgeSymbol>();
        Set symbolIds = SYMBOL_REGISTRY.getKeys();
        for (ResourceLocation symbolId : symbolIds) {
            Integer rank;
            if (blacklist.contains(symbolId) || (rank = SymbolManager.getSymbolItemCardRank(symbolId)) == null || min != null && min > rank || max != null && max < rank) continue;
            set.add((IAgeSymbol)SYMBOL_REGISTRY.getValue(symbolId));
        }
        return set;
    }

    public static int getSymbolItemWeight(ResourceLocation identifier) {
        if (!cardranks.containsKey(identifier)) {
            return 0;
        }
        Integer rank = cardranks.get(identifier);
        if (rank == null) {
            return 0;
        }
        if (cardrankweights == null) {
            throw new RuntimeException("Cannot obtain symbol treasure weight: Card ranking system not built");
        }
        return cardrankweights.get(rank);
    }

    public static void setSymbolItemCardRank(ResourceLocation identifier, int cardrank) {
        if (cardrankweights != null) {
            throw new RuntimeException("Cannot set symbol rarity ranking: rank weights finalized");
        }
        cardranks.put(identifier, cardrank);
        while (cardranksizes.size() <= cardrank) {
            cardranksizes.add(0);
        }
        cardranksizes.set(cardrank, cardranksizes.get(cardrank) + 1);
    }

    public static Integer getSymbolItemCardRank(ResourceLocation identifier) {
        return cardranks.get(identifier);
    }

    public static int getSymbolTreasureMaxStack(IAgeSymbol symbol2) {
        Integer rank = SymbolManager.getSymbolItemCardRank(symbol2.getRegistryName());
        Integer dfault = defaultMaxStacks.get(rank);
        if (dfault == null) {
            dfault = 1;
        }
        if (!maxTreasureStackOverrides.containsKey(symbol2.getRegistryName())) {
            return dfault;
        }
        Integer override = maxTreasureStackOverrides.get(symbol2.getRegistryName());
        if (override == null) {
            return dfault;
        }
        return override;
    }

    public static void setSymbolTreasureMaxStack(ResourceLocation identifier, int override) {
        maxTreasureStackOverrides.put(identifier, override);
    }

    public static boolean isSymbolTradable(ResourceLocation identifier) {
        boolean dfault;
        boolean bl = dfault = SymbolManager.getSymbolItemWeight(identifier) > 0;
        if (!tradeableOverrides.containsKey(identifier)) {
            return dfault;
        }
        Boolean override = tradeableOverrides.get(identifier);
        if (override == null) {
            return dfault;
        }
        return override;
    }

    public static void setSymbolIsTradable(ResourceLocation identifier, boolean override) {
        tradeableOverrides.put(identifier, override);
    }

    public static List<ItemStack> getSymbolTradeItems(ResourceLocation identifier) {
        ItemStack dfault = new ItemStack(Items.field_151166_bC, Math.max(1, (int)(12.0f * (float)SymbolManager.getSymbolItemCardRank(identifier).intValue())));
        if (!tradeItemOverrides.containsKey(identifier)) {
            return Arrays.asList(dfault);
        }
        List<ItemStack> override = tradeItemOverrides.get(identifier);
        if (override == null) {
            return Arrays.asList(dfault);
        }
        return override;
    }

    public static void setSymbolTradeItems(ResourceLocation identifier, ItemStack primary, ItemStack secondary) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (primary != null) {
            list.add(primary.func_77946_l());
        }
        if (secondary != null) {
            list.add(secondary.func_77946_l());
        }
        if (list.size() > 0) {
            tradeItemOverrides.put(identifier, list);
        } else {
            SymbolManager.setSymbolIsTradable(identifier, false);
        }
    }

    public static void buildCardRanks() {
        boolean step = true;
        cardrankweights = new HashMap();
        int weight = 1;
        int lasttotal = 0;
        for (int i = cardranksizes.size() - 1; i >= 0; --i) {
            int count = cardranksizes.get(i);
            if (weight != 1 && count > 0) {
                weight = Math.max(weight, lasttotal / count + 1);
            }
            cardrankweights.put(i, weight);
            lasttotal = count * weight;
            ++weight;
        }
    }

    public static void registerRules() {
        ArrayList<IAgeSymbol> symbols = SymbolManager.getAgeSymbols();
        for (IAgeSymbol symbol2 : symbols) {
            ArrayList<GrammarGenerator.Rule> rules;
            if (!(symbol2 instanceof SymbolBase) || (rules = ((SymbolBase)symbol2).getRules()) == null) continue;
            for (GrammarGenerator.Rule rule : rules) {
                GrammarGenerator.registerRule(rule);
            }
        }
    }

    static {
        cardranks = new HashMap();
        cardranksizes = new ArrayList();
        cardrankweights = null;
        maxTreasureStackOverrides = new HashMap();
        tradeableOverrides = new HashMap();
        tradeItemOverrides = new HashMap();
        defaultMaxStacks = new HashMap();
        defaultMaxStacks.put(null, 0);
        defaultMaxStacks.put(0, 16);
        defaultMaxStacks.put(1, 8);
        defaultMaxStacks.put(2, 4);
        defaultMaxStacks.put(3, 2);
    }

    public static class SymbolAddListener
    implements IForgeRegistry.AddCallback<IAgeSymbol> {
        public void onAdd(IForgeRegistryInternal<IAgeSymbol> owner, RegistryManager stage, int id, IAgeSymbol obj, @Nullable IAgeSymbol oldObj) {
            if (!SymbolManager.tryAddSymbol(obj, false)) {
                stage.getRegistry(SYMBOL_REGISTRY_NAME).remove(obj.getRegistryName());
            }
        }
    }
}

