/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.client.render.CloudRendererMyst;
import com.xcompwiz.mystcraft.client.render.WeatherRendererMyst;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.network.NetworkUtils;
import com.xcompwiz.mystcraft.world.AgeController;
import com.xcompwiz.mystcraft.world.BiomeWrapperManager;
import com.xcompwiz.mystcraft.world.ChunkProviderMyst;
import com.xcompwiz.mystcraft.world.SkyRendererMyst;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import com.xcompwiz.mystcraft.world.storage.WorldInfoMyst;
import java.util.Random;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderMyst
extends WorldProvider {
    public int ageUID;
    public AgeData agedata;
    private AgeController controller;
    private BiomeWrapperManager biomeManager;
    private SkyRendererMyst skyrenderer;
    private CloudRendererMyst cloudrenderer;
    private WeatherRendererMyst weatherrenderer;
    private int emptyTicks;

    public void setDimension(int dim) {
        this.ageUID = dim;
        super.setDimension(dim);
    }

    protected void func_76572_b() {
        this.agedata = AgeData.getAge(this.ageUID, this.field_76579_a.field_72995_K);
        this.biomeManager = new BiomeWrapperManager(this);
        this.controller = new AgeController(this.field_76579_a, this.agedata);
        this.skyrenderer = this.controller.getSkyRenderer();
        this.weatherrenderer = this.controller.getWeatherRenderer();
        this.cloudrenderer = this.controller.getCloudRenderer();
        this.field_76578_c = this.controller.getBiomeProvider();
        this.setWorldInfo();
    }

    public World getWorld() {
        return this.field_76579_a;
    }

    public AgeController getAgeController() {
        return this.controller;
    }

    public void setWorldInfo() {
        if (this.field_76579_a.func_72912_H() instanceof WorldInfoMyst) {
            return;
        }
        ObfuscationReflectionHelper.setPrivateValue(World.class, (Object)this.field_76579_a, (Object)((Object)new WorldInfoMyst(this, this.field_76579_a.func_72912_H())), (String[])new String[]{"worldInfo", "field_72986_A"});
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return this.skyrenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        return this.cloudrenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        return this.weatherrenderer;
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkProviderMyst(this.getAgeController(), this.field_76579_a, this.agedata);
    }

    protected void func_76556_a() {
        this.getAgeController().generateLightBrightnessTable(this.field_76573_f);
    }

    public float[] func_76560_a(float f, float f1) {
        return null;
    }

    public float func_76563_a(long time, float partialtick) {
        return this.getAgeController().calculateCelestialAngle(time, partialtick);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float celestial_angle, float partialtick) {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        Biome biome = this.field_76579_a.func_180494_b(new BlockPos(entity));
        Vec3d fog = this.getAgeController().getFogColor(entity, biome, this.field_76579_a.func_72820_D(), celestial_angle, partialtick);
        if (fog == null) {
            float f2 = MathHelper.func_76134_b((float)(celestial_angle * 3.141593f * 2.0f)) * 2.0f + 0.5f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            float f3 = 0.7529412f;
            float f4 = 0.8470588f;
            float f5 = 1.0f;
            return new Vec3d((double)(f3 *= f2 * 0.94f + 0.06f), (double)(f4 *= f2 * 0.94f + 0.06f), (double)(f5 *= f2 * 0.91f + 0.09f));
        }
        return fog;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColor(float partialtick) {
        float var9;
        float var8;
        float blu;
        float grn;
        float red;
        float celestial_angle = this.field_76579_a.func_72826_c(partialtick);
        float var3 = MathHelper.func_76134_b((float)(celestial_angle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        Biome biome = this.field_76579_a.func_180494_b(new BlockPos(entity));
        Vec3d temp = this.getAgeController().getCloudColor(entity, biome, this.field_76579_a.func_72820_D(), celestial_angle, partialtick);
        if (temp != null) {
            red = (float)temp.field_72450_a;
            grn = (float)temp.field_72448_b;
            blu = (float)temp.field_72449_c;
        } else {
            red = 1.0f;
            grn = 1.0f;
            blu = 1.0f;
        }
        float var7 = this.field_76579_a.func_72867_j(partialtick);
        if (var7 > 0.0f) {
            var8 = (red * 0.3f + grn * 0.59f + blu * 0.11f) * 0.6f;
            var9 = 1.0f - var7 * 0.95f;
            red = red * var9 + var8 * (1.0f - var9);
            grn = grn * var9 + var8 * (1.0f - var9);
            blu = blu * var9 + var8 * (1.0f - var9);
        }
        red *= var3 * 0.9f + 0.1f;
        grn *= var3 * 0.9f + 0.1f;
        blu *= var3 * 0.85f + 0.15f;
        var8 = this.field_76579_a.func_72819_i(partialtick);
        if (var8 > 0.0f) {
            var9 = (red * 0.3f + grn * 0.59f + blu * 0.11f) * 0.2f;
            float var10 = 1.0f - var8 * 0.95f;
            red = red * var10 + var9 * (1.0f - var10);
            grn = grn * var10 + var9 * (1.0f - var10);
            blu = blu * var10 + var9 * (1.0f - var10);
        }
        return new Vec3d((double)red, (double)grn, (double)blu);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_76565_k() {
        return 0.03125;
    }

    public boolean func_76561_g() {
        return false;
    }

    public boolean shouldClientCheckLighting() {
        return false;
    }

    public float func_76571_f() {
        return this.getAgeController().getCloudHeight();
    }

    public double getHorizon() {
        return this.getAgeController().getHorizon();
    }

    public int func_76557_i() {
        return 64;
    }

    public boolean canBlockFreeze(BlockPos pos, boolean reqLand) {
        IBlockState blockstate;
        Biome biome = this.getBiomeForCoords(pos);
        float temp = biome.func_180626_a(pos);
        int y = pos.func_177956_o();
        temp = this.getAgeController().getTemperatureAtHeight(temp, y);
        if (temp > 0.15f) {
            return false;
        }
        if (y >= 0 && y < 256 && this.field_76579_a.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && ((blockstate = this.field_76579_a.func_180495_p(pos)).func_177230_c() == Blocks.field_150355_j || blockstate.func_177230_c() == Blocks.field_150358_i) && (Integer)blockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            if (!reqLand) {
                return true;
            }
            boolean canFreeze = true;
            if (canFreeze && this.field_76579_a.func_180495_p(pos.func_177976_e()).func_185904_a() != Material.field_151586_h) {
                canFreeze = false;
            }
            if (canFreeze && this.field_76579_a.func_180495_p(pos.func_177974_f()).func_185904_a() != Material.field_151586_h) {
                canFreeze = false;
            }
            if (canFreeze && this.field_76579_a.func_180495_p(pos.func_177968_d()).func_185904_a() != Material.field_151586_h) {
                canFreeze = false;
            }
            if (canFreeze && this.field_76579_a.func_180495_p(pos.func_177978_c()).func_185904_a() != Material.field_151586_h) {
                canFreeze = false;
            }
            return canFreeze;
        }
        return false;
    }

    public boolean canSnowAt(BlockPos pos, boolean checkLight) {
        IBlockState blockstate;
        Biome biome = this.getBiomeForCoords(pos);
        float temp = biome.func_180626_a(pos);
        int y = pos.func_177956_o();
        temp = this.getAgeController().getTemperatureAtHeight(temp, y);
        if (temp > 0.15f) {
            return false;
        }
        return y >= 0 && y < 256 && this.field_76579_a.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && ((blockstate = this.field_76579_a.func_180495_p(pos)) == null || blockstate.func_177230_c().isAir(blockstate, (IBlockAccess)this.field_76579_a, pos)) && Blocks.field_150431_aC.func_176196_c(this.field_76579_a, pos);
    }

    public void calculateInitialWeather() {
        this.updateWeather();
    }

    public boolean canDoLightning(Chunk chunk) {
        this.getAgeController().tickBlocksAndAmbiance(chunk);
        return false;
    }

    public void updateWeather() {
        this.getAgeController().tick();
        this.getAgeController().getWeatherController().updateRaining();
        this.weatherrenderer.updateClouds();
        this.cloudrenderer.updateClouds();
        this.field_76579_a.field_73003_n = this.field_76579_a.field_73004_o;
        this.field_76579_a.field_73004_o = this.getAgeController().getWeatherController().getRainingStrength();
        this.field_76579_a.field_73018_p = this.field_76579_a.field_73017_q;
        this.field_76579_a.field_73017_q = this.getAgeController().getWeatherController().getStormStrength();
        if (this.field_76579_a.field_72995_K || !(this.field_76579_a instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)this.field_76579_a;
        if (this.field_76579_a.field_73010_i.isEmpty()) {
            if (this.emptyTicks == 10) {
                world.func_72863_F().func_73240_a();
            }
            ++this.emptyTicks;
        } else {
            this.emptyTicks = 0;
        }
        if (world.func_73056_e()) {
            this.setWorldTime(this.getWorldTime() + this.timeToSunrise());
        }
        if (this.agedata.needsResend() && world.func_82737_E() % 200L == 0L) {
            this.agedata.resent();
            for (Object player : this.field_76579_a.field_73010_i) {
                NetworkUtils.sendAgeData((EntityPlayer)player, this.getDimension());
            }
        }
    }

    private long timeToSunrise() {
        return this.getAgeController().getTimeToSunrise(this.getWorldTime());
    }

    public void resetRainAndThunder() {
        this.agedata.markNeedsResend();
        this.getAgeController().getWeatherController().reset();
    }

    public void togglePrecipitation() {
        this.agedata.markNeedsResend();
        this.getAgeController().getWeatherController().togglePrecipitation();
    }

    public BlockPos getSpawnPoint() {
        this.verifySpawn();
        return this.agedata.getSpawn();
    }

    public BlockPos getRandomizedSpawnPoint() {
        return this.getSpawnPoint();
    }

    private void verifySpawn() {
        if (this.agedata.getSpawn() != null) {
            return;
        }
        if (this.field_76579_a.field_72995_K) {
            this.agedata.setSpawn(new BlockPos(0, 0, 0));
            return;
        }
        Random random = new Random(this.agedata.getSeed());
        BiomeProvider biomeprovider = this.func_177499_m();
        BlockPos spawnpos = biomeprovider.func_180630_a(0, 0, 256, biomeprovider.func_76932_a(), random);
        if (spawnpos == null) {
            System.out.println("Searching for viable spawn point.");
        }
        int x = random.nextInt(64) - random.nextInt(64);
        int y = this.getAgeController().getSeaLevel();
        int z = random.nextInt(64) - random.nextInt(64);
        for (int l = 0; l < 1000 && !this.func_76566_a(x, z) && this.agedata.getSpawn() == null; ++l) {
            x = random.nextInt(64) - random.nextInt(64);
            z = random.nextInt(64) - random.nextInt(64);
        }
        if (this.agedata.getSpawn() == null) {
            spawnpos = new BlockPos(x, y, z);
            this.field_76579_a.func_175726_f(spawnpos);
            while (!this.field_76579_a.func_175623_d(spawnpos)) {
                spawnpos = spawnpos.func_177984_a();
            }
            this.agedata.setSpawn(spawnpos);
        }
    }

    public boolean func_76566_a(int x, int z) {
        BlockPos blockpos = new BlockPos(x, 0, z);
        IBlockState block = this.field_76579_a.func_180495_p(blockpos = this.field_76579_a.func_175672_r(blockpos));
        if (block.func_177230_c() == Blocks.field_150357_h) {
            return false;
        }
        if (this.field_76579_a.func_175623_d(blockpos)) {
            return false;
        }
        return block.func_185904_a().func_76230_c();
    }

    public Biome getBiomeForCoords(BlockPos pos) {
        return this.biomeManager.getWrapper(pos);
    }

    private int getSkyColorByTemp(float par1) {
        if ((par1 /= 3.0f) < -1.0f) {
            par1 = -1.0f;
        }
        if (par1 > 1.0f) {
            par1 = 1.0f;
        }
        return java.awt.Color.getHSBColor(0.62222224f - par1 * 0.05f, 0.5f + par1 * 0.1f, 1.0f).getRGB();
    }

    public Color getStaticColor(String string, Biome biome, BlockPos pos) {
        return this.getAgeController().getStaticColor(string, biome, pos);
    }

    public Vec3d getSkyColor(Entity entity, float partialtick) {
        float var14;
        float celestial_angle = this.field_76579_a.func_72826_c(partialtick);
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        BlockPos blockPos = new BlockPos(entity);
        Biome biome = this.field_76579_a.func_180494_b(blockPos);
        Vec3d out = this.getAgeController().getSkyColor(entity, biome, this.field_76579_a.func_72820_D(), celestial_angle, partialtick);
        if (out == null) {
            float var4 = MathHelper.func_76134_b((float)(celestial_angle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
            if (var4 < 0.0f) {
                var4 = 0.0f;
            }
            if (var4 > 1.0f) {
                var4 = 1.0f;
            }
            float var8 = biome.func_180626_a(blockPos);
            int var9 = this.getSkyColorByTemp(var8);
            red = (float)(var9 >> 16 & 0xFF) / 255.0f;
            green = (float)(var9 >> 8 & 0xFF) / 255.0f;
            blue = (float)(var9 & 0xFF) / 255.0f;
            red *= var4;
            green *= var4;
            blue *= var4;
        } else {
            red = (float)out.field_72450_a;
            green = (float)out.field_72448_b;
            blue = (float)out.field_72449_c;
        }
        float rainstrength = this.field_76579_a.func_72867_j(partialtick);
        if (rainstrength > 0.0f) {
            var14 = (red * 0.3f + green * 0.59f + blue * 0.11f) * 0.6f;
            float var15 = 1.0f - rainstrength * 0.75f;
            red = red * var15 + var14 * (1.0f - var15);
            green = green * var15 + var14 * (1.0f - var15);
            blue = blue * var15 + var14 * (1.0f - var15);
        }
        if ((var14 = this.field_76579_a.func_72819_i(partialtick)) > 0.0f) {
            float var15 = (red * 0.3f + green * 0.59f + blue * 0.11f) * 0.2f;
            float var16 = 1.0f - var14 * 0.75f;
            red = red * var16 + var15 * (1.0f - var16);
            green = green * var16 + var15 * (1.0f - var16);
            blue = blue * var16 + var15 * (1.0f - var16);
        }
        if (this.field_76579_a.func_175658_ac() > 0) {
            float var15 = (float)this.field_76579_a.func_175658_ac() - partialtick;
            if (var15 > 1.0f) {
                var15 = 1.0f;
            }
            red = red * (1.0f - (var15 *= 0.45f)) + 0.8f * var15;
            green = green * (1.0f - var15) + 0.8f * var15;
            blue = blue * (1.0f - var15) + 1.0f * var15;
        }
        return new Vec3d((double)red, (double)green, (double)blue);
    }

    public String getSaveFolder() {
        return WorldProviderMyst.getSaveFolderName(this.ageUID);
    }

    public static String getSaveFolderName(int dimid) {
        return "DIM_MYST" + dimid;
    }

    public String getDimensionName() {
        if (this.agedata == null) {
            if (this.field_76579_a != null) {
                this.agedata = AgeData.getAge(this.ageUID, this.field_76579_a.field_72995_K);
            } else {
                LoggerUtils.warn("Someone is trying to get the age name from an improperly constructed world provider with dim id " + this.getDimension(), new Object[0]);
                this.agedata = AgeData.getAge(this.ageUID, false);
            }
        }
        if (this.agedata == null) {
            return "Age " + this.ageUID;
        }
        return this.agedata.getAgeName();
    }

    public long getWorldTime() {
        return this.agedata.getWorldTime();
    }

    public void setWorldTime(long time) {
        this.agedata.setWorldTime(time);
    }

    public boolean func_76567_e() {
        return Mystcraft.respawnInAges;
    }

    public boolean isPvPEnabled() {
        return this.getAgeController().isPvPEnabled();
    }

    public float getTemperature(float temperature, ResourceLocation biomeId) {
        return this.getAgeController().getWeatherController().getTemperature(temperature, biomeId);
    }

    public float getRainfall(float rainfall, ResourceLocation biomeId) {
        return this.getAgeController().getWeatherController().getRainfall(rainfall, biomeId);
    }

    public boolean getEnableSnow(boolean enableSnow, ResourceLocation biomeId) {
        return this.getAgeController().getWeatherController().getEnableSnow(enableSnow, biomeId);
    }

    public boolean getEnableRain(boolean canSpawnLightningBolt, ResourceLocation biomeId) {
        return this.getAgeController().getWeatherController().getEnableRain(canSpawnLightningBolt, biomeId);
    }

    public boolean func_191066_m() {
        return true;
    }

    public boolean func_177495_o() {
        return false;
    }

    public DimensionType func_186058_p() {
        return Mystcraft.dimensionType;
    }
}

