/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen.feature;

import com.xcompwiz.mystcraft.world.gen.feature.WorldGeneratorAdv;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class WorldGenMystCrystalFormation
extends WorldGeneratorAdv {
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    private World worldObj;
    private IBlockState block;
    private BlockPos crystalPos;

    public WorldGenMystCrystalFormation(Block block) {
        this(block.func_176223_P());
    }

    public WorldGenMystCrystalFormation(IBlockState state) {
        this.block = state;
    }

    private void generateLine(Random rand) {
        float angle1 = rand.nextFloat() * 140.0f + 15.0f;
        int length = rand.nextInt(7) + 6;
        int[] end = new int[]{this.crystalPos.func_177958_n() + (int)((double)length * Math.cos((double)angle1 * Math.PI / 180.0)), this.crystalPos.func_177956_o() + (int)((double)length * Math.sin((double)angle1 * Math.PI / 180.0)), this.crystalPos.func_177952_p() + rand.nextInt(7) - 3};
        int[] start = new int[]{this.crystalPos.func_177958_n(), this.crystalPos.func_177956_o(), this.crystalPos.func_177952_p()};
        this.placeBlockLine(start, end, this.block);
    }

    private void placeBlockLine(int[] ai, int[] ai1, IBlockState state) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.drawSphere(new BlockPos(ai3[0], ai3[1], ai3[2]), state);
        }
    }

    private void drawSphere(BlockPos pos, IBlockState state) {
        this.setBlock(pos, state);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            this.setBlock(pos.func_177972_a(face), state);
        }
    }

    private void setBlock(BlockPos pos, IBlockState state) {
        if (!this.worldObj.func_180495_p(pos).func_177230_c().equals(Blocks.field_150357_h)) {
            this.placeBlock(this.worldObj, pos, state, 3);
        }
    }

    @Override
    public boolean doGeneration(World world, Random rand, BlockPos pos) {
        this.worldObj = world;
        this.crystalPos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        if (!this.validLocation()) {
            return false;
        }
        int count = rand.nextInt(3) + 1;
        for (int i1 = 0; i1 < count; ++i1) {
            this.generateLine(rand);
        }
        return true;
    }

    private boolean validLocation() {
        IBlockState state = this.worldObj.func_180495_p(this.crystalPos);
        while (state.func_185904_a() != Material.field_151579_a) {
            this.crystalPos = this.crystalPos.func_177984_a();
            if (this.crystalPos.func_177956_o() > this.worldObj.func_72800_K()) {
                return false;
            }
            state = this.worldObj.func_180495_p(this.crystalPos);
        }
        while (!state.func_185904_a().func_76224_d() && state.func_185904_a() != Material.field_151579_a) {
            this.crystalPos = this.crystalPos.func_177984_a();
        }
        this.crystalPos = this.crystalPos.func_177979_c(2);
        return this.worldObj.func_180495_p(this.crystalPos).func_185904_a() != Material.field_151579_a;
    }
}

