/*
 * Decompiled with CFR 0.152.
 */
package com.indemnity83.irontanks.common.blocks;

import buildcraft.api.transport.pipe.ICustomPipeConnection;
import buildcraft.factory.block.ITankBlockConnector;
import buildcraft.factory.tile.TileTank;
import com.indemnity83.irontanks.common.tiles.TankTile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TankBlock
extends Block
implements ITileEntityProvider,
ICustomPipeConnection {
    private final int tankCapacity;

    public TankBlock(String tankName, int tankCapacity) {
        super(Material.field_151592_s, MapColor.field_151660_b);
        this.tankCapacity = tankCapacity;
        this.setRegistryName(tankName);
        this.func_149663_c("irontanks." + tankName);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"irontanks.tooltip.capacity", (Object[])new Object[]{this.tankCapacity}));
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TankTile().withCapacity(this.getTankCapacity());
    }

    public int getTankCapacity() {
        return this.tankCapacity;
    }

    public float getExtension(World world, BlockPos pos, EnumFacing face, IBlockState state) {
        return face.func_176740_k() == EnumFacing.Axis.Y ? 0.0f : 0.125f;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileTank && ((TileTank)tile).onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side.func_176740_k() != EnumFacing.Axis.Y || !(world.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof ITankBlockConnector);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TankTile) {
            TankTile tankTile = (TankTile)tile;
            tankTile.onExplode(explosion);
        }
        super.onBlockExploded(world, pos, explosion);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TankTile) {
            TankTile tankTile = (TankTile)tile;
            tankTile.onRemove();
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTank) {
            TileTank tileBC = (TileTank)tile;
            tileBC.onPlacedBy(placer, stack);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }
}

