/*
 * Decompiled with CFR 0.152.
 */
package jeresources.collection;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import jeresources.entry.VillagerEntry;
import jeresources.util.FakeMerchant;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class TradeList
extends LinkedList<Trade> {
    private static final Random r = new Random();
    private static final IMerchant m = new FakeMerchant();
    private VillagerEntry villagerEntry;

    public TradeList(VillagerEntry villagerEntry) {
        this.villagerEntry = villagerEntry;
    }

    public List<ItemStack> getFirstBuyStacks() {
        return this.stream().map(Trade::getMinBuyStack1).collect(Collectors.toList());
    }

    public List<ItemStack> getSecondBuyStacks() {
        return this.stream().map(Trade::getMinBuyStack2).collect(Collectors.toList());
    }

    public List<ItemStack> getSellStacks() {
        return this.stream().map(Trade::getMinSellStack).collect(Collectors.toList());
    }

    public TradeList getSubListSell(ItemStack itemStack) {
        return this.stream().filter(trade -> trade.sellsItem(itemStack)).collect(Collectors.toCollection(() -> new TradeList(this.villagerEntry)));
    }

    public TradeList getSubListBuy(ItemStack itemStack) {
        return this.stream().filter(trade -> trade.buysItem(itemStack)).collect(Collectors.toCollection(() -> new TradeList(this.villagerEntry)));
    }

    public TradeList getFocusedList(IFocus<ItemStack> focus) {
        if (focus == null) {
            return this;
        }
        switch (focus.getMode()) {
            case INPUT: {
                return this.getSubListBuy((ItemStack)focus.getValue());
            }
            case OUTPUT: {
                return this.getSubListSell((ItemStack)focus.getValue());
            }
        }
        return this;
    }

    public void addITradeList(EntityVillager.ITradeList tradeList) {
        int maxSell;
        int minBuy2;
        int maxBuy2;
        int maxBuy1;
        MerchantRecipeList tempList = new MerchantRecipeList();
        for (int itr = 0; itr < 100; ++itr) {
            tradeList.func_190888_a(m, tempList, r);
        }
        if (tempList.size() == 0) {
            return;
        }
        ItemStack buy1 = ((MerchantRecipe)tempList.get(0)).func_77394_a();
        ItemStack buy2 = ((MerchantRecipe)tempList.get(0)).func_77396_b();
        ItemStack sell = ((MerchantRecipe)tempList.get(0)).func_77397_d();
        int minBuy1 = maxBuy1 = buy1.func_190916_E();
        if (buy2 != null) {
            minBuy2 = maxBuy2 = buy2.func_190916_E();
        } else {
            maxBuy2 = 0;
            minBuy2 = 0;
        }
        int minSell = maxSell = sell.func_190916_E();
        for (MerchantRecipe merchantRecipe : tempList) {
            if (minBuy1 > merchantRecipe.func_77394_a().func_190916_E()) {
                minBuy1 = merchantRecipe.func_77394_a().func_190916_E();
            }
            if (buy2 != null && minBuy2 > merchantRecipe.func_77396_b().func_190916_E()) {
                minBuy2 = merchantRecipe.func_77396_b().func_190916_E();
            }
            if (minSell > merchantRecipe.func_77397_d().func_190916_E()) {
                minSell = merchantRecipe.func_77397_d().func_190916_E();
            }
            if (maxBuy1 < merchantRecipe.func_77394_a().func_190916_E()) {
                maxBuy1 = merchantRecipe.func_77394_a().func_190916_E();
            }
            if (buy2 != null && maxBuy2 < merchantRecipe.func_77396_b().func_190916_E()) {
                maxBuy2 = merchantRecipe.func_77396_b().func_190916_E();
            }
            if (maxSell >= merchantRecipe.func_77397_d().func_190916_E()) continue;
            maxSell = merchantRecipe.func_77397_d().func_190916_E();
        }
        this.add(new Trade(buy1, minBuy1, maxBuy1, buy2, minBuy2, maxBuy2, sell, minSell, maxSell));
    }

    public static class Trade {
        private final ItemStack buy1;
        private final ItemStack buy2;
        private final ItemStack sell;
        private final int minBuy1;
        private final int minBuy2;
        private final int minSell;
        private final int maxBuy1;
        private final int maxBuy2;
        private final int maxSell;

        Trade(ItemStack buy1, int minBuy1, int maxBuy1, ItemStack buy2, int minBuy2, int maxBuy2, ItemStack sell, int minSell, int maxSell) {
            this.buy1 = buy1;
            this.minBuy1 = minBuy1;
            this.maxBuy1 = maxBuy1;
            this.buy2 = buy2;
            this.minBuy2 = minBuy2;
            this.maxBuy2 = maxBuy2;
            this.sell = sell;
            this.minSell = minSell;
            this.maxSell = maxSell;
        }

        public boolean sellsItem(ItemStack itemStack) {
            return this.sell.func_77969_a(itemStack);
        }

        public boolean buysItem(ItemStack itemStack) {
            return this.buy1.func_77969_a(itemStack) || this.buy2 != null && this.buy2.func_77969_a(itemStack);
        }

        public ItemStack getMinBuyStack1() {
            ItemStack minBuyStack = this.buy1.func_77946_l();
            minBuyStack.func_190920_e(this.minBuy1);
            return minBuyStack;
        }

        public ItemStack getMinBuyStack2() {
            if (this.buy2 == null) {
                return null;
            }
            ItemStack minBuyStack = this.buy2.func_77946_l();
            minBuyStack.func_190920_e(this.minBuy2);
            return minBuyStack;
        }

        public ItemStack getMinSellStack() {
            ItemStack minSellStack = this.sell.func_77946_l();
            minSellStack.func_190920_e(this.minSell);
            return minSellStack;
        }

        public ItemStack getMaxBuyStack1() {
            ItemStack maxBuyStack = this.buy1.func_77946_l();
            maxBuyStack.func_190920_e(this.maxBuy1);
            return maxBuyStack;
        }

        public ItemStack getMaxBuyStack2() {
            if (this.buy2 == null) {
                return null;
            }
            ItemStack maxBuyStack = this.buy2.func_77946_l();
            maxBuyStack.func_190920_e(this.maxBuy2);
            return maxBuyStack;
        }

        public ItemStack getMaxSellStack() {
            ItemStack maxSellStack = this.sell.func_77946_l();
            maxSellStack.func_190920_e(this.maxSell);
            return maxSellStack;
        }

        public String toString() {
            return "Buy1: " + this.buy1 + ", Buy2: " + this.buy2 + ", Sell: " + this.sell;
        }
    }
}

