/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.client;

import com.cleanroommc.client.ime.DummyIMEHandler;
import com.cleanroommc.client.ime.WaylandIMEhandler;
import com.cleanroommc.client.ime.WindowsIMEHandler;
import com.cleanroommc.client.ime.X11IMEHandler;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.FMLLog;
import org.lwjgl.glfw.GLFW;

public class IMEHandler {
    private static final Consumer<Boolean> instance;

    public static void setIME(boolean active) {
        instance.accept(active);
    }

    static {
        if (ForgeModContainer.inputMethodBlockingEnabled) {
            switch (GLFW.glfwGetPlatform()) {
                case 393217: {
                    instance = new WindowsIMEHandler();
                    break;
                }
                case 393220: {
                    instance = new X11IMEHandler();
                    break;
                }
                case 393219: {
                    instance = new WaylandIMEhandler();
                    break;
                }
                default: {
                    instance = new DummyIMEHandler();
                    FMLLog.log.warn("IME handler initialization failed: Unsupported platform {}", (Object)GLFW.glfwGetPlatform());
                    break;
                }
            }
        } else {
            instance = new DummyIMEHandler();
        }
    }
}

