/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.b3d;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class B3DModel {
    static final Logger logger = LogManager.getLogger((String)"forge.B3DModel");
    private static final boolean printLoadedModels = "true".equals(System.getProperty("b3dloader.printLoadedModels"));
    private final List<Texture> textures;
    private final List<Brush> brushes;
    private final Node<?> root;
    private final ImmutableMap<String, Node<Mesh>> meshes;

    public B3DModel(List<Texture> textures, List<Brush> brushes, Node<?> root, ImmutableMap<String, Node<Mesh>> meshes) {
        this.textures = textures;
        this.brushes = brushes;
        this.root = root;
        this.meshes = meshes;
    }

    public List<Texture> getTextures() {
        return this.textures;
    }

    public List<Brush> getBrushes() {
        return this.brushes;
    }

    public Node<?> getRoot() {
        return this.root;
    }

    public ImmutableMap<String, Node<Mesh>> getMeshes() {
        return this.meshes;
    }

    public static class Node<K extends IKind<K>> {
        private final String name;
        private final Vector3f pos;
        private final Vector3f scale;
        private final Quat4f rot;
        private final ImmutableMap<String, Node<?>> nodes;
        @Nullable
        private Animation animation;
        private final K kind;
        @Nullable
        private Node<? extends IKind<?>> parent;

        public static <K extends IKind<K>> Node<K> create(String name, Vector3f pos, Vector3f scale, Quat4f rot, List<Node<?>> nodes, K kind) {
            return new Node<K>(name, pos, scale, rot, nodes, kind);
        }

        public Node(String name, Vector3f pos, Vector3f scale, Quat4f rot, List<Node<?>> nodes, K kind) {
            this.name = name;
            this.pos = pos;
            this.scale = scale;
            this.rot = rot;
            this.nodes = this.buildNodeMap(nodes);
            this.kind = kind;
            kind.setParent(this);
            for (Node child : this.nodes.values()) {
                child.setParent(this);
            }
        }

        public void setAnimation(Animation animation) {
            this.animation = animation;
            ArrayDeque q = new ArrayDeque(this.nodes.values());
            while (!q.isEmpty()) {
                Node node = (Node)q.pop();
                if (node.getAnimation() != null) continue;
                node.setAnimation(animation);
                q.addAll(node.getNodes().values());
            }
        }

        public void setAnimation(Triple<Integer, Integer, Float> animData, Table<Integer, Optional<Node<?>>, Key> keyData) {
            ImmutableTable.Builder builder = ImmutableTable.builder();
            for (Table.Cell key : keyData.cellSet()) {
                builder.put((Object)((Integer)key.getRowKey()), (Object)((Optional)key.getColumnKey()).orElse(this), (Object)((Key)key.getValue()));
            }
            this.setAnimation(new Animation((Integer)animData.getLeft(), (Integer)animData.getMiddle(), ((Float)animData.getRight()).floatValue(), builder.build()));
        }

        private ImmutableMap<String, Node<?>> buildNodeMap(List<Node<?>> nodes) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Node<?> node : nodes) {
                builder.put((Object)node.getName(), node);
            }
            return builder.build();
        }

        public String getName() {
            return this.name;
        }

        public K getKind() {
            return this.kind;
        }

        public Vector3f getPos() {
            return this.pos;
        }

        public Vector3f getScale() {
            return this.scale;
        }

        public Quat4f getRot() {
            return this.rot;
        }

        public ImmutableMap<String, Node<?>> getNodes() {
            return this.nodes;
        }

        @Nullable
        public Animation getAnimation() {
            return this.animation;
        }

        @Nullable
        public Node<? extends IKind<?>> getParent() {
            return this.parent;
        }

        public void setParent(Node<? extends IKind<?>> parent) {
            this.parent = parent;
        }

        public String toString() {
            return String.format("Node [name=%s, kind=%s, pos=%s, scale=%s, rot=%s, keys=..., nodes=..., animation=%s]", this.name, this.kind, this.pos, this.scale, this.rot, this.animation);
        }
    }

    public static class Bone
    implements IKind<Bone> {
        private Node<Bone> parent;
        private final List<Pair<Vertex, Float>> data;

        public Bone(List<Pair<Vertex, Float>> data) {
            this.data = data;
        }

        public List<Pair<Vertex, Float>> getData() {
            return this.data;
        }

        @Override
        public void setParent(Node<Bone> parent) {
            this.parent = parent;
        }

        @Override
        public Node<Bone> getParent() {
            return this.parent;
        }
    }

    public static class Mesh
    implements IKind<Mesh> {
        private Node<Mesh> parent;
        private final Brush brush;
        private final ImmutableList<Face> faces;
        private Set<Node<Bone>> bones = new HashSet<Node<Bone>>();
        private ImmutableMultimap<Vertex, Pair<Float, Node<Bone>>> weightMap = ImmutableMultimap.of();

        public Mesh(Pair<Brush, List<Face>> data) {
            this.brush = (Brush)data.getLeft();
            this.faces = ImmutableList.copyOf((Collection)((Collection)data.getRight()));
        }

        public ImmutableMultimap<Vertex, Pair<Float, Node<Bone>>> getWeightMap() {
            return this.weightMap;
        }

        public ImmutableList<Face> bake(Function<Node<?>, Matrix4f> animator) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Face f : this.getFaces()) {
                Vertex v1 = f.getV1().bake(this, animator);
                Vertex v2 = f.getV2().bake(this, animator);
                Vertex v3 = f.getV3().bake(this, animator);
                builder.add((Object)new Face(v1, v2, v3, f.getBrush()));
            }
            return builder.build();
        }

        public Brush getBrush() {
            return this.brush;
        }

        public ImmutableList<Face> getFaces() {
            return this.faces;
        }

        public ImmutableSet<Node<Bone>> getBones() {
            return ImmutableSet.copyOf(this.bones);
        }

        public String toString() {
            return String.format("Mesh [pivot=%s, brush=%s, data=...]", super.toString(), this.brush);
        }

        @Override
        public void setParent(Node<Mesh> parent) {
            this.parent = parent;
            ArrayDeque queue = new ArrayDeque(parent.getNodes().values());
            while (!queue.isEmpty()) {
                Node node = (Node)queue.pop();
                if (!(node.getKind() instanceof Bone)) continue;
                this.bones.add(node);
                queue.addAll(node.getNodes().values());
            }
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (Node bone : this.getBones()) {
                for (Pair<Vertex, Float> b2 : ((Bone)bone.getKind()).getData()) {
                    builder.put((Object)((Vertex)b2.getLeft()), (Object)Pair.of((Object)((Float)b2.getRight()), (Object)bone));
                }
            }
            this.weightMap = builder.build();
        }

        @Override
        public Node<Mesh> getParent() {
            return this.parent;
        }
    }

    public static class Pivot
    implements IKind<Pivot> {
        private Node<Pivot> parent;

        @Override
        public void setParent(Node<Pivot> parent) {
            this.parent = parent;
        }

        @Override
        public Node<Pivot> getParent() {
            return this.parent;
        }
    }

    public static interface IKind<K extends IKind<K>> {
        public void setParent(Node<K> var1);

        public Node<K> getParent();
    }

    public static class Animation {
        private final int flags;
        private final int frames;
        private final float fps;
        private final ImmutableTable<Integer, Node<?>, Key> keys;

        public Animation(int flags, int frames, float fps, ImmutableTable<Integer, Node<?>, Key> keys) {
            this.flags = flags;
            this.frames = frames;
            this.fps = fps;
            this.keys = keys;
        }

        public int getFlags() {
            return this.flags;
        }

        public int getFrames() {
            return this.frames;
        }

        public float getFps() {
            return this.fps;
        }

        public ImmutableTable<Integer, Node<?>, Key> getKeys() {
            return this.keys;
        }

        public String toString() {
            return String.format("Animation [flags=%s, frames=%s, fps=%s, keys=...]", this.flags, this.frames, Float.valueOf(this.fps));
        }
    }

    public static class Key {
        @Nullable
        private final Vector3f pos;
        @Nullable
        private final Vector3f scale;
        @Nullable
        private final Quat4f rot;

        public Key(@Nullable Vector3f pos, @Nullable Vector3f scale, @Nullable Quat4f rot) {
            this.pos = pos;
            this.scale = scale;
            this.rot = rot;
        }

        @Nullable
        public Vector3f getPos() {
            return this.pos;
        }

        @Nullable
        public Vector3f getScale() {
            return this.scale;
        }

        @Nullable
        public Quat4f getRot() {
            return this.rot;
        }

        public String toString() {
            return String.format("Key [pos=%s, scale=%s, rot=%s]", this.pos, this.scale, this.rot);
        }
    }

    public static class Face {
        private final Vertex v1;
        private final Vertex v2;
        private final Vertex v3;
        @Nullable
        private final Brush brush;
        private final Vector3f normal;

        public Face(Vertex v1, Vertex v2, Vertex v3, @Nullable Brush brush) {
            this(v1, v2, v3, brush, Face.getNormal(v1, v2, v3));
        }

        public Face(Vertex v1, Vertex v2, Vertex v3, @Nullable Brush brush, Vector3f normal) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.brush = brush;
            this.normal = normal;
        }

        public Vertex getV1() {
            return this.v1;
        }

        public Vertex getV2() {
            return this.v2;
        }

        public Vertex getV3() {
            return this.v3;
        }

        @Nullable
        public Brush getBrush() {
            return this.brush;
        }

        public String toString() {
            return String.format("Face [v1=%s, v2=%s, v3=%s]", this.v1, this.v2, this.v3);
        }

        public Vector3f getNormal() {
            return this.normal;
        }

        public static Vector3f getNormal(Vertex v1, Vertex v2, Vertex v3) {
            Vector3f a2 = new Vector3f(v2.getPos());
            a2.sub((Tuple3f)v1.getPos());
            Vector3f b2 = new Vector3f(v3.getPos());
            b2.sub((Tuple3f)v1.getPos());
            Vector3f c2 = new Vector3f();
            c2.cross(a2, b2);
            c2.normalize();
            return c2;
        }
    }

    public static class Vertex {
        private final Vector3f pos;
        @Nullable
        private final Vector3f normal;
        @Nullable
        private final Vector4f color;
        private final Vector4f[] texCoords;

        public Vertex(Vector3f pos, @Nullable Vector3f normal, @Nullable Vector4f color, Vector4f[] texCoords) {
            this.pos = pos;
            this.normal = normal;
            this.color = color;
            this.texCoords = texCoords;
        }

        public Vertex bake(Mesh mesh, Function<Node<?>, Matrix4f> animator) {
            Float totalWeight = Float.valueOf(0.0f);
            Matrix4f t = new Matrix4f();
            if (mesh.getWeightMap().get((Object)this).isEmpty()) {
                t.setIdentity();
            } else {
                for (Pair bone : mesh.getWeightMap().get((Object)this)) {
                    totalWeight = Float.valueOf(totalWeight.floatValue() + ((Float)bone.getLeft()).floatValue());
                    Matrix4f bm = animator.apply((Node)bone.getRight());
                    bm.mul(((Float)bone.getLeft()).floatValue());
                    t.add(bm);
                }
                if ((double)Math.abs(totalWeight.floatValue()) > 1.0E-4) {
                    t.mul(1.0f / totalWeight.floatValue());
                } else {
                    t.setIdentity();
                }
            }
            TRSRTransformation trsr = new TRSRTransformation(t);
            Vector4f pos = new Vector4f((Tuple3f)this.pos);
            pos.w = 1.0f;
            trsr.transformPosition(pos);
            Vector3f rPos = new Vector3f(pos.x / pos.w, pos.y / pos.w, pos.z / pos.w);
            Vector3f rNormal = null;
            if (this.normal != null) {
                rNormal = new Vector3f(this.normal);
                trsr.transformNormal(rNormal);
            }
            return new Vertex(rPos, rNormal, this.color, this.texCoords);
        }

        public Vector3f getPos() {
            return this.pos;
        }

        @Nullable
        public Vector3f getNormal() {
            return this.normal;
        }

        @Nullable
        public Vector4f getColor() {
            return this.color;
        }

        public Vector4f[] getTexCoords() {
            return this.texCoords;
        }

        public String toString() {
            return String.format("Vertex [pos=%s, normal=%s, color=%s, texCoords=%s]", this.pos, this.normal, this.color, Arrays.toString(this.texCoords));
        }
    }

    public static class Brush {
        private final String name;
        private final Vector4f color;
        private final float shininess;
        private final int blend;
        private final int fx;
        private final List<Texture> textures;

        public Brush(String name, Vector4f color, float shininess, int blend, int fx, List<Texture> textures) {
            this.name = name;
            this.color = color;
            this.shininess = shininess;
            this.blend = blend;
            this.fx = fx;
            this.textures = textures;
        }

        public String getName() {
            return this.name;
        }

        public Vector4f getColor() {
            return this.color;
        }

        public float getShininess() {
            return this.shininess;
        }

        public int getBlend() {
            return this.blend;
        }

        public int getFx() {
            return this.fx;
        }

        public List<Texture> getTextures() {
            return this.textures;
        }

        public String toString() {
            return String.format("Brush [name=%s, color=%s, shininess=%s, blend=%s, fx=%s, textures=%s]", this.name, this.color, Float.valueOf(this.shininess), this.blend, this.fx, this.textures);
        }
    }

    public static class Texture {
        public static final Texture White = new Texture("builtin/white", 0, 0, new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f), 0.0f);
        private final String path;
        private final int flags;
        private final int blend;
        private final Vector2f pos;
        private final Vector2f scale;
        private final float rot;

        public Texture(String path, int flags, int blend, Vector2f pos, Vector2f scale, float rot) {
            this.path = path;
            this.flags = flags;
            this.blend = blend;
            this.pos = pos;
            this.scale = scale;
            this.rot = rot;
        }

        public String getPath() {
            return this.path;
        }

        public int getFlags() {
            return this.flags;
        }

        public int getBlend() {
            return this.blend;
        }

        public Vector2f getPos() {
            return this.pos;
        }

        public Vector2f getScale() {
            return this.scale;
        }

        public float getRot() {
            return this.rot;
        }

        public String toString() {
            return String.format("Texture [path=%s, flags=%s, blend=%s, pos=%s, scale=%s, rot=%s]", this.path, this.flags, this.blend, this.pos, this.scale, Float.valueOf(this.rot));
        }
    }

    public static class Parser {
        private static final int version = 1;
        private final ByteBuffer buf;
        private byte[] tag = new byte[4];
        private int length;
        private String dump = "";
        private B3DModel res;
        private final List<Texture> textures = new ArrayList<Texture>();
        private final List<Brush> brushes = new ArrayList<Brush>();
        private final List<Vertex> vertices = new ArrayList<Vertex>();
        private final ImmutableMap.Builder<String, Node<Mesh>> meshes = ImmutableMap.builder();
        private Deque<Integer> limitStack = new ArrayDeque<Integer>();
        private final Deque<Table<Integer, Optional<Node<?>>, Key>> animations = new ArrayDeque();

        public Parser(InputStream in) throws IOException {
            if (in instanceof FileInputStream) {
                FileChannel channel = ((FileInputStream)in).getChannel();
                this.buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size()).order(ByteOrder.LITTLE_ENDIAN);
            } else {
                IOUtils.readFully((InputStream)in, (byte[])this.tag);
                byte[] tmp = new byte[4];
                IOUtils.readFully((InputStream)in, (byte[])tmp);
                int l2 = ByteBuffer.wrap(tmp).order(ByteOrder.LITTLE_ENDIAN).getInt();
                if (l2 < 0 || l2 + 8 < 0) {
                    throw new IOException("File is too large");
                }
                this.buf = ByteBuffer.allocate(l2 + 8).order(ByteOrder.LITTLE_ENDIAN);
                this.buf.clear();
                this.buf.put(this.tag);
                this.buf.put(tmp);
                this.buf.put(IOUtils.toByteArray((InputStream)in, (int)l2));
                this.buf.flip();
            }
        }

        private void dump(String str) {
            if (printLoadedModels) {
                this.dump = this.dump + str + "\n";
            }
        }

        public B3DModel parse() throws IOException {
            if (this.res != null) {
                return this.res;
            }
            this.dump = "\n";
            this.readHeader();
            this.res = this.bb3d();
            if (printLoadedModels) {
                logger.info(this.dump);
            }
            return this.res;
        }

        private Texture getTexture(int texture) {
            if (texture > this.textures.size()) {
                logger.error("texture {} is out of range", (Object)texture);
                return null;
            }
            if (texture == -1) {
                return Texture.White;
            }
            return this.textures.get(texture);
        }

        @Nullable
        private Brush getBrush(int brush) throws IOException {
            if (brush > this.brushes.size()) {
                throw new IOException(String.format("brush %s is out of range", brush));
            }
            if (brush == -1) {
                return null;
            }
            return this.brushes.get(brush);
        }

        private Vertex getVertex(int vertex) throws IOException {
            if (vertex > this.vertices.size()) {
                throw new IOException(String.format("vertex %s is out of range", vertex));
            }
            return this.vertices.get(vertex);
        }

        private void readHeader() throws IOException {
            this.buf.get(this.tag);
            this.length = this.buf.getInt();
        }

        private boolean isChunk(String tag) throws IOException {
            return Arrays.equals(this.tag, tag.getBytes("US-ASCII"));
        }

        private void chunk(String tag) throws IOException {
            if (!this.isChunk(tag)) {
                throw new IOException("Expected chunk " + tag + ", got " + new String(this.tag, "US-ASCII"));
            }
            this.pushLimit();
        }

        private String readString() throws IOException {
            int start = this.buf.position();
            while (this.buf.get() != 0) {
            }
            int end = this.buf.position();
            byte[] tmp = new byte[end - start - 1];
            this.buf.position(start);
            this.buf.get(tmp);
            this.buf.get();
            return new String(tmp, "UTF8");
        }

        private void pushLimit() {
            this.limitStack.push(this.buf.limit());
            this.buf.limit(this.buf.position() + this.length);
        }

        private void popLimit() {
            this.buf.limit(this.limitStack.pop());
        }

        private B3DModel bb3d() throws IOException {
            this.chunk("BB3D");
            int version = this.buf.getInt();
            if (version / 100 > 0) {
                throw new IOException("Unsupported major model version: " + (float)version / 100.0f);
            }
            if (version % 100 > 1) {
                logger.warn(String.format("Minor version difference in model: %s", Float.valueOf((float)version / 100.0f)));
            }
            List<Texture> textures = Collections.emptyList();
            List<Brush> brushes = Collections.emptyList();
            Node<?> root = null;
            this.dump("BB3D(version = " + version + ") {");
            while (this.buf.hasRemaining()) {
                this.readHeader();
                if (this.isChunk("TEXS")) {
                    textures = this.texs();
                    continue;
                }
                if (this.isChunk("BRUS")) {
                    brushes = this.brus();
                    continue;
                }
                if (this.isChunk("NODE")) {
                    root = this.node();
                    continue;
                }
                this.skip();
            }
            this.dump("}");
            this.popLimit();
            if (root == null) {
                throw new IOException("not found the root node in the model");
            }
            return new B3DModel(textures, brushes, root, (ImmutableMap<String, Node<Mesh>>)this.meshes.build());
        }

        private List<Texture> texs() throws IOException {
            this.chunk("TEXS");
            ArrayList<Texture> ret = new ArrayList<Texture>();
            while (this.buf.hasRemaining()) {
                String path = this.readString();
                int flags = this.buf.getInt();
                int blend = this.buf.getInt();
                Vector2f pos = new Vector2f(this.buf.getFloat(), this.buf.getFloat());
                Vector2f scale = new Vector2f(this.buf.getFloat(), this.buf.getFloat());
                float rot = this.buf.getFloat();
                ret.add(new Texture(path, flags, blend, pos, scale, rot));
            }
            this.dump("TEXS([" + Joiner.on((String)", ").join(ret) + "])");
            this.popLimit();
            this.textures.addAll(ret);
            return ret;
        }

        private List<Brush> brus() throws IOException {
            this.chunk("BRUS");
            ArrayList<Brush> ret = new ArrayList<Brush>();
            int n_texs = this.buf.getInt();
            while (this.buf.hasRemaining()) {
                String name = this.readString();
                Vector4f color = new Vector4f(this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat());
                float shininess = this.buf.getFloat();
                int blend = this.buf.getInt();
                int fx = this.buf.getInt();
                ArrayList<Texture> textures = new ArrayList<Texture>();
                for (int i2 = 0; i2 < n_texs; ++i2) {
                    textures.add(this.getTexture(this.buf.getInt()));
                }
                ret.add(new Brush(name, color, shininess, blend, fx, textures));
            }
            this.dump("BRUS([" + Joiner.on((String)", ").join(ret) + "])");
            this.popLimit();
            this.brushes.addAll(ret);
            return ret;
        }

        private List<Vertex> vrts() throws IOException {
            this.chunk("VRTS");
            ArrayList<Vertex> ret = new ArrayList<Vertex>();
            int flags = this.buf.getInt();
            int tex_coord_sets = this.buf.getInt();
            int tex_coord_set_size = this.buf.getInt();
            while (this.buf.hasRemaining()) {
                Vector3f v = new Vector3f(this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat());
                Vector3f n = null;
                Vector4f color = null;
                if ((flags & 1) != 0) {
                    n = new Vector3f(this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat());
                }
                if ((flags & 2) != 0) {
                    color = new Vector4f(this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat());
                }
                Vector4f[] tex_coords = new Vector4f[tex_coord_sets];
                block7: for (int i2 = 0; i2 < tex_coord_sets; ++i2) {
                    switch (tex_coord_set_size) {
                        case 1: {
                            tex_coords[i2] = new Vector4f(this.buf.getFloat(), 0.0f, 0.0f, 1.0f);
                            continue block7;
                        }
                        case 2: {
                            tex_coords[i2] = new Vector4f(this.buf.getFloat(), this.buf.getFloat(), 0.0f, 1.0f);
                            continue block7;
                        }
                        case 3: {
                            tex_coords[i2] = new Vector4f(this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat(), 1.0f);
                            continue block7;
                        }
                        case 4: {
                            tex_coords[i2] = new Vector4f(this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat());
                            continue block7;
                        }
                        default: {
                            logger.error(String.format("Unsupported number of texture coords: %s", tex_coord_set_size));
                            tex_coords[i2] = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                        }
                    }
                }
                ret.add(new Vertex(v, n, color, tex_coords));
            }
            this.dump("VRTS([" + Joiner.on((String)", ").join(ret) + "])");
            this.popLimit();
            this.vertices.clear();
            this.vertices.addAll(ret);
            return ret;
        }

        private List<Face> tris() throws IOException {
            this.chunk("TRIS");
            ArrayList<Face> ret = new ArrayList<Face>();
            int brush_id = this.buf.getInt();
            while (this.buf.hasRemaining()) {
                ret.add(new Face(this.getVertex(this.buf.getInt()), this.getVertex(this.buf.getInt()), this.getVertex(this.buf.getInt()), this.getBrush(brush_id)));
            }
            this.dump("TRIS([" + Joiner.on((String)", ").join(ret) + "])");
            this.popLimit();
            return ret;
        }

        private Pair<Brush, List<Face>> mesh() throws IOException {
            this.chunk("MESH");
            int brush_id = this.buf.getInt();
            this.readHeader();
            this.dump("MESH(brush = " + brush_id + ") {");
            this.vrts();
            ArrayList<Face> ret = new ArrayList<Face>();
            while (this.buf.hasRemaining()) {
                this.readHeader();
                ret.addAll(this.tris());
            }
            this.dump("}");
            this.popLimit();
            return Pair.of((Object)this.getBrush(brush_id), ret);
        }

        private List<Pair<Vertex, Float>> bone() throws IOException {
            this.chunk("BONE");
            ArrayList<Pair<Vertex, Float>> ret = new ArrayList<Pair<Vertex, Float>>();
            while (this.buf.hasRemaining()) {
                ret.add((Pair<Vertex, Float>)Pair.of((Object)this.getVertex(this.buf.getInt()), (Object)Float.valueOf(this.buf.getFloat())));
            }
            this.dump("BONE(...)");
            this.popLimit();
            return ret;
        }

        private Map<Integer, Key> keys() throws IOException {
            this.chunk("KEYS");
            HashMap<Integer, Key> ret = new HashMap<Integer, Key>();
            int flags = this.buf.getInt();
            Vector3f pos = null;
            Vector3f scale = null;
            Quat4f rot = null;
            while (this.buf.hasRemaining()) {
                int frame = this.buf.getInt();
                if ((flags & 1) != 0) {
                    pos = new Vector3f(this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat());
                }
                if ((flags & 2) != 0) {
                    scale = new Vector3f(this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat());
                }
                if ((flags & 4) != 0) {
                    rot = this.readQuat();
                }
                Key key = new Key(pos, scale, rot);
                Key oldKey = (Key)this.animations.peek().get((Object)frame, null);
                if (oldKey != null) {
                    if (pos != null) {
                        if (oldKey.getPos() != null) {
                            logger.error("Duplicate keys: {} and {} (ignored)", (Object)oldKey, (Object)key);
                        } else {
                            key = new Key(oldKey.getPos(), key.getScale(), key.getRot());
                        }
                    }
                    if (scale != null) {
                        if (oldKey.getScale() != null) {
                            logger.error("Duplicate keys: {} and {} (ignored)", (Object)oldKey, (Object)key);
                        } else {
                            key = new Key(key.getPos(), oldKey.getScale(), key.getRot());
                        }
                    }
                    if (rot != null) {
                        if (oldKey.getRot() != null) {
                            logger.error("Duplicate keys: {} and {} (ignored)", (Object)oldKey, (Object)key);
                        } else {
                            key = new Key(key.getPos(), key.getScale(), oldKey.getRot());
                        }
                    }
                }
                this.animations.peek().put((Object)frame, Optional.empty(), (Object)key);
                ret.put(frame, key);
            }
            this.dump("KEYS([(" + Joiner.on((String)"), (").withKeyValueSeparator(" -> ").join(ret) + ")])");
            this.popLimit();
            return ret;
        }

        private Triple<Integer, Integer, Float> anim() throws IOException {
            this.chunk("ANIM");
            int flags = this.buf.getInt();
            int frames = this.buf.getInt();
            float fps = this.buf.getFloat();
            this.dump("ANIM(" + flags + ", " + frames + ", " + fps + ")");
            this.popLimit();
            return Triple.of((Object)flags, (Object)frames, (Object)Float.valueOf(fps));
        }

        private Node<?> node() throws IOException {
            Node<IKind<Pivot>> node;
            this.chunk("NODE");
            this.animations.push((Table<Integer, Optional<Node<?>>, Key>)HashBasedTable.create());
            Triple<Integer, Integer, Float> animData = null;
            Pair<Brush, List<Face>> mesh = null;
            List<Pair<Vertex, Float>> bone = null;
            HashMap<Integer, Key> keys = new HashMap<Integer, Key>();
            ArrayList nodes = new ArrayList();
            String name = this.readString();
            Vector3f pos = new Vector3f(this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat());
            Vector3f scale = new Vector3f(this.buf.getFloat(), this.buf.getFloat(), this.buf.getFloat());
            Quat4f rot = this.readQuat();
            this.dump("NODE(" + name + ", " + String.valueOf(pos) + ", " + String.valueOf(scale) + ", " + String.valueOf(rot) + ") {");
            while (this.buf.hasRemaining()) {
                this.readHeader();
                if (this.isChunk("MESH")) {
                    mesh = this.mesh();
                    continue;
                }
                if (this.isChunk("BONE")) {
                    bone = this.bone();
                    continue;
                }
                if (this.isChunk("KEYS")) {
                    keys.putAll(this.keys());
                    continue;
                }
                if (this.isChunk("NODE")) {
                    nodes.add(this.node());
                    continue;
                }
                if (this.isChunk("ANIM")) {
                    animData = this.anim();
                    continue;
                }
                this.skip();
            }
            this.dump("}");
            this.popLimit();
            Table<Integer, Optional<Node<?>>, Key> keyData = this.animations.pop();
            if (mesh != null) {
                Node<Mesh> mNode = Node.create(name, pos, scale, rot, nodes, new Mesh(mesh));
                this.meshes.put((Object)name, mNode);
                node = mNode;
            } else {
                node = bone != null ? Node.create(name, pos, scale, rot, nodes, new Bone(bone)) : Node.create(name, pos, scale, rot, nodes, new Pivot());
            }
            if (animData == null) {
                for (Table.Cell key : keyData.cellSet()) {
                    this.animations.peek().put((Object)((Integer)key.getRowKey()), Optional.of(((Optional)key.getColumnKey()).orElse(node)), (Object)((Key)key.getValue()));
                }
            } else {
                node.setAnimation(animData, keyData);
            }
            return node;
        }

        private Quat4f readQuat() {
            float w = this.buf.getFloat();
            float x = this.buf.getFloat();
            float y = this.buf.getFloat();
            float z = this.buf.getFloat();
            return new Quat4f(x, y, z, w);
        }

        private void skip() {
            this.buf.position(this.buf.position() + this.length);
        }
    }
}

