/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.asm.transformers.AccessTransformer;
import org.jspecify.annotations.NonNull;

public class ModAccessTransformer
extends AccessTransformer {
    public static final Attributes.Name FMLAT = new Attributes.Name("FMLAT");
    private static final Map<String, String> embedded = Maps.newHashMap();

    public ModAccessTransformer() throws Exception {
        super(ModAccessTransformer.class);
        for (Map.Entry<String, String> e : embedded.entrySet()) {
            int old_count = this.getModifiers().size();
            this.processATFile(CharSource.wrap((CharSequence)e.getValue()));
            int added = this.getModifiers().size() - old_count;
            if (added <= 0) continue;
            FMLLog.log.debug("Loaded {} rules from AccessTransformer mod jar file {}\n", (Object)added, (Object)e.getKey());
        }
    }

    public static void addJar(JarFile jar, String atList) throws IOException {
        for (String at : atList.split(" ")) {
            JarEntry jarEntry = jar.getJarEntry("META-INF/" + at);
            if (jarEntry == null) continue;
            embedded.put(String.format("%s!META-INF/%s", jar.getName(), at), new JarByteSource(jar, jarEntry).asCharSource(StandardCharsets.UTF_8).read());
        }
    }

    private static class JarByteSource
    extends ByteSource {
        private final JarFile jar;
        private final JarEntry entry;

        public JarByteSource(JarFile jar, JarEntry entry) {
            this.jar = jar;
            this.entry = entry;
        }

        public @NonNull InputStream openStream() throws IOException {
            return this.jar.getInputStream(this.entry);
        }
    }
}

