/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.eventhandler;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.IEventListener;

public class ListenerList {
    private static ImmutableList<ListenerList> allLists = ImmutableList.of();
    private static int maxSize = 0;
    @Nullable
    private final ListenerList parent;
    private ListenerListInst[] lists = new ListenerListInst[0];

    public ListenerList() {
        this(null);
    }

    public ListenerList(@Nullable ListenerList parent) {
        this.parent = parent;
        ListenerList.extendMasterList(this);
        this.resizeLists(maxSize);
    }

    private static synchronized void extendMasterList(ListenerList inst) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(allLists);
        builder.add((Object)inst);
        allLists = builder.build();
    }

    public static void resize(int max) {
        if (max <= maxSize) {
            return;
        }
        for (ListenerList list : allLists) {
            list.resizeLists(max);
        }
        maxSize = max;
    }

    public void resizeLists(int max) {
        int x;
        if (this.parent != null) {
            this.parent.resizeLists(max);
        }
        if (this.lists.length >= max) {
            return;
        }
        ListenerListInst[] newList = new ListenerListInst[max];
        for (x = 0; x < this.lists.length; ++x) {
            newList[x] = this.lists[x];
        }
        while (x < max) {
            newList[x] = this.parent != null ? new ListenerListInst(this.parent.getInstance(x)) : new ListenerListInst();
            ++x;
        }
        this.lists = newList;
    }

    public static void clearBusID(int id) {
        for (ListenerList list : allLists) {
            list.lists[id].dispose();
        }
    }

    protected ListenerListInst getInstance(int id) {
        return this.lists[id];
    }

    public IEventListener[] getListeners(int id) {
        return this.lists[id].getListeners();
    }

    public void register(int id, EventPriority priority, IEventListener listener) {
        this.lists[id].register(priority, listener);
    }

    public void unregister(int id, IEventListener listener) {
        this.lists[id].unregister(listener);
    }

    public static void unregisterAll(int id, IEventListener listener) {
        for (ListenerList list : allLists) {
            list.unregister(id, listener);
        }
    }

    private static class ListenerListInst {
        private static final EventPriority[] PRIORITIES = EventPriority.values();
        private static final IEventListener[] EMPTY_LISTENER_ARRAY = new IEventListener[0];
        private boolean rebuild = true;
        private IEventListener[] listeners;
        private final ArrayList<IEventListener>[] priorities = new ArrayList[PRIORITIES.length];
        private ListenerListInst parent;
        private List<ListenerListInst> children;

        private ListenerListInst() {
        }

        public void dispose() {
            Arrays.fill(this.priorities, null);
            this.parent = null;
            this.listeners = null;
            if (this.children != null) {
                this.children.clear();
            }
        }

        private ListenerListInst(ListenerListInst parent) {
            this();
            this.parent = parent;
            this.parent.addChild(this);
        }

        public List<IEventListener> getListeners(EventPriority priority) {
            if (this.parent == null) {
                ArrayList<IEventListener> byPriority = this.priorities[priority.ordinal()];
                return byPriority != null ? byPriority : List.of();
            }
            List<IEventListener> fromParent = this.parent.getListeners(priority);
            ArrayList<IEventListener> fromThis = this.priorities[priority.ordinal()];
            if (fromThis == null) {
                return fromParent;
            }
            ArrayList<IEventListener> merged = new ArrayList<IEventListener>(fromParent.size() + fromThis.size());
            merged.addAll(fromThis);
            merged.addAll(fromParent);
            return merged;
        }

        public IEventListener[] getListeners() {
            if (this.shouldRebuild()) {
                this.buildCache();
            }
            return this.listeners;
        }

        protected boolean shouldRebuild() {
            return this.rebuild;
        }

        protected void forceRebuild() {
            this.rebuild = true;
            if (this.children != null) {
                for (ListenerListInst child : this.children) {
                    child.forceRebuild();
                }
            }
        }

        private void addChild(ListenerListInst child) {
            if (this.children == null) {
                this.children = new ArrayList<ListenerListInst>();
            }
            this.children.add(child);
        }

        private void buildCache() {
            if (this.parent != null && this.parent.shouldRebuild()) {
                this.parent.buildCache();
            }
            ArrayList<IEventListener> ret = new ArrayList<IEventListener>();
            for (EventPriority value : PRIORITIES) {
                List<IEventListener> listeners = this.getListeners(value);
                if (listeners.isEmpty()) continue;
                ret.add(value);
                ret.addAll(listeners);
            }
            this.listeners = ret.toArray(EMPTY_LISTENER_ARRAY);
            this.rebuild = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void register(EventPriority priority, IEventListener listener) {
            ArrayList<IEventListener> byPriority = this.priorities[priority.ordinal()];
            if (byPriority == null) {
                ArrayList<IEventListener>[] arrayListArray = this.priorities;
                // MONITORENTER : this.priorities
                byPriority = this.priorities[priority.ordinal()];
                if (byPriority == null) {
                    this.priorities[priority.ordinal()] = byPriority = new ArrayList();
                }
                // MONITOREXIT : arrayListArray
            }
            byPriority.add(listener);
            this.forceRebuild();
        }

        public void unregister(IEventListener listener) {
            for (ArrayList<IEventListener> list : this.priorities) {
                if (list == null || !list.remove(listener)) continue;
                this.forceRebuild();
            }
        }
    }
}

