/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.TracingPrintStream;
import net.minecraftforge.fml.common.launcher.FMLTweaker;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;
import org.apache.logging.log4j.LogManager;

public class FMLLaunchHandler {
    private static FMLLaunchHandler INSTANCE;
    static Side side;
    private LaunchClassLoader classLoader;
    private FMLTweaker tweaker;
    private File minecraftHome;

    public static void configureForClientLaunch(LaunchClassLoader loader, FMLTweaker tweaker) {
        FMLLaunchHandler.instance(loader, tweaker).setupClient();
    }

    public static void configureForServerLaunch(LaunchClassLoader loader, FMLTweaker tweaker) {
        FMLLaunchHandler.instance(loader, tweaker).setupServer();
    }

    private static FMLLaunchHandler instance(LaunchClassLoader launchLoader, FMLTweaker tweaker) {
        if (INSTANCE == null) {
            INSTANCE = new FMLLaunchHandler(launchLoader, tweaker);
        }
        return INSTANCE;
    }

    private FMLLaunchHandler(LaunchClassLoader launchLoader, FMLTweaker tweaker) {
        this.classLoader = launchLoader;
        this.tweaker = tweaker;
        this.minecraftHome = tweaker.getGameDir();
        this.classLoader.addTransformerExclusion("com.cleanroommc.loader.");
        this.classLoader.addTransformerExclusion("net.minecraftforge.fml.relauncher.");
        this.classLoader.addTransformerExclusion("net.minecraftforge.classloading.");
        this.classLoader.addTransformerExclusion("net.minecraftforge.fml.common.asm.transformers.");
        this.classLoader.addTransformerExclusion("net.minecraftforge.fml.common.patcher.");
        this.classLoader.addTransformerExclusion("net.minecraftforge.fml.repackage.");
        this.classLoader.addTransformerExclusion("LZMA.");
        this.classLoader.addTransformerExclusion("scala.");
        this.classLoader.addTransformerExclusion("it.unimi.dsi.");
        this.classLoader.addTransformerExclusion("oshi.");
    }

    private void setupClient() {
        side = Side.CLIENT;
        this.setupHome();
    }

    private void setupServer() {
        side = Side.SERVER;
        this.setupHome();
    }

    private void setupHome() {
        FMLInjectionData.build(this.minecraftHome, this.classLoader);
        this.redirectStdOutputToLog();
        FMLLog.log.info("Forge Mod Loader version {}.{}.{}.{} for Minecraft {} loading", (Object)FMLInjectionData.major, (Object)FMLInjectionData.minor, (Object)FMLInjectionData.rev, (Object)FMLInjectionData.build, (Object)FMLInjectionData.mccversion);
        FMLLog.log.info("Cleanroom version {}", (Object)"0.3.13-alpha");
        FMLLog.log.info("Java is {}, version {}, running on {}:{}:{}, installed at {}", (Object)System.getProperty("java.vm.name"), (Object)System.getProperty("java.version"), (Object)System.getProperty("os.name"), (Object)System.getProperty("os.arch"), (Object)System.getProperty("os.version"), (Object)System.getProperty("java.home"));
        FMLLog.log.debug("Removing LWJGL2 from Java classpath");
        System.setProperty("java.class.path", Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).filter(it -> !it.contains("2.9.4-nightly-20150209")).collect(Collectors.joining(File.pathSeparator)));
        FMLLog.log.debug("Java classpath at launch is:");
        for (String path : System.getProperty("java.class.path").split(File.pathSeparator)) {
            FMLLog.log.debug("    {}", (Object)path);
        }
        FMLLog.log.debug("Java library path at launch is:");
        for (String path : System.getProperty("java.library.path").split(File.pathSeparator)) {
            FMLLog.log.debug("    {}", (Object)path);
        }
        try {
            LibraryManager.setup(this.minecraftHome);
            CoreModManager.handleLaunch(this.minecraftHome, this.classLoader, this.tweaker);
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred trying to configure the Minecraft home at " + this.minecraftHome.getAbsolutePath() + " for Forge Mod Loader", t);
        }
    }

    private void redirectStdOutputToLog() {
        FMLLog.log.debug("Injecting tracing printstreams for STDOUT/STDERR.");
        System.setOut(new TracingPrintStream(LogManager.getLogger((String)"STDOUT"), System.out));
        System.setErr(new TracingPrintStream(LogManager.getLogger((String)"STDERR"), System.err));
    }

    public static Side side() {
        return side;
    }

    private void injectPostfixTransformers() {
        CoreModManager.injectTransformers(this.classLoader);
    }

    public static void appendCoreMods() {
        INSTANCE.injectPostfixTransformers();
    }

    public static boolean isDeobfuscatedEnvironment() {
        return CoreModManager.deobfuscatedEnvironment;
    }
}

