/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.bugfixes.world.portal;

import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigBugfixes;
import mod.acgaming.universaltweaks.config.UTConfigGeneral;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="universaltweaks")
public class UTPortalLocationLink {
    @SubscribeEvent
    public static void utDimensionChangeEventPortalLocation(EntityTravelToDimensionEvent event) {
        if (!UTConfigBugfixes.WORLD.utPortalLocationLink) {
            return;
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTPortalLocationLink ::: Entity travel to dimension event");
        }
        if (event.getEntity().field_71087_bX && event.getEntity().func_130014_f_().field_73011_w.getDimension() == 0) {
            UTPortalLocationLink.writePortalNBT(event.getEntity());
        }
    }

    public static double[] getStoredPortalCoords(Entity entity) {
        double distanceSq;
        double[] storedPortalCoords;
        if (entity.func_130014_f_().field_73011_w.getDimension() == -1 && (storedPortalCoords = UTPortalLocationLink.readPortalNBT(entity)) != null && (distanceSq = entity.func_180425_c().func_177954_c(storedPortalCoords[0], storedPortalCoords[1], storedPortalCoords[2])) <= 16384.0) {
            return storedPortalCoords;
        }
        return new double[0];
    }

    private static void writePortalNBT(Entity entity) {
        NBTTagCompound nbt = entity.getEntityData();
        if (!nbt.func_150297_b("NetherPortal", 10)) {
            nbt.func_74782_a("NetherPortal", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound portalData = nbt.func_74775_l("NetherPortal");
        portalData.func_74780_a("LastPortalX", entity.field_70165_t);
        portalData.func_74780_a("LastPortalY", entity.field_70163_u);
        portalData.func_74780_a("LastPortalZ", entity.field_70161_v);
        nbt.func_74782_a("NetherPortal", (NBTBase)portalData);
    }

    private static double[] readPortalNBT(Entity entity) {
        NBTTagCompound portalData;
        NBTTagCompound nbt = entity.getEntityData();
        if (nbt.func_150297_b("NetherPortal", 10) && (portalData = nbt.func_74775_l("NetherPortal")).func_74764_b("LastPortalX") && portalData.func_74764_b("LastPortalY") && portalData.func_74764_b("LastPortalZ")) {
            double x = portalData.func_74769_h("LastPortalX");
            double y = portalData.func_74769_h("LastPortalY");
            double z = portalData.func_74769_h("LastPortalZ");
            return new double[]{x, y, z};
        }
        return null;
    }
}

