/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.misc.armorcurve.mixin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import mod.acgaming.universaltweaks.tweaks.misc.armorcurve.UTArmorCurve;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public abstract class UTArmorDegradationMixin {
    @Unique
    private static final Cache<ItemStack, ImmutableMultimap<String, AttributeModifier>> CACHE = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(1L, TimeUnit.SECONDS).build();

    @Shadow
    public abstract Item func_77973_b();

    @Shadow
    public abstract boolean func_190926_b();

    @Shadow
    public abstract int func_77952_i();

    @Shadow
    public abstract int func_77958_k();

    @Inject(cancellable=true, at={@At(value="RETURN")}, method={"getAttributeModifiers"}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void utGetAttributeModifiers(EntityEquipmentSlot equipmentSlot, CallbackInfoReturnable<Multimap<String, AttributeModifier>> info, Multimap<String, AttributeModifier> m) {
        if (!this.func_190926_b() && equipmentSlot != EntityEquipmentSlot.MAINHAND && equipmentSlot != EntityEquipmentSlot.OFFHAND && this.func_77973_b().func_77645_m()) {
            ImmutableMultimap cached = (ImmutableMultimap)CACHE.getIfPresent((Object)((ItemStack)this));
            if (cached != null) {
                info.setReturnValue((Object)cached);
            }
            ImmutableMultimap.Builder copy = ImmutableMultimap.builder();
            if (UTArmorCurve.degrade == null || UTConfigTweaks.MISC.ARMOR_CURVE.utArmorCurveDegradation.equals("1")) {
                return;
            }
            float retDegrade = UTArmorCurve.degrade.with("remaining", BigDecimal.valueOf(this.func_77958_k() - this.func_77952_i())).and("max", BigDecimal.valueOf(this.func_77958_k())).eval().floatValue();
            if (UTConfigTweaks.MISC.ARMOR_CURVE.utArmorCurveLogging) {
                UniversalTweaks.LOGGER.info("UTArmorCurve ::: Armor Degradation: " + retDegrade);
            }
            for (String e : m.keySet()) {
                for (AttributeModifier eam : m.get((Object)e)) {
                    AttributeModifier degradedEAM = new AttributeModifier(eam.func_111167_a(), eam.func_111166_b(), (double)retDegrade * eam.func_111164_d(), eam.func_111169_c());
                    copy.put((Object)e, (Object)degradedEAM);
                }
            }
            cached = copy.build();
            CACHE.put((Object)((ItemStack)this), (Object)cached);
            info.setReturnValue((Object)cached);
        }
    }
}

