/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.capability.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import pl.asie.charset.api.lib.IDyeableItem;
import pl.asie.charset.lib.capability.Capabilities;

public class DyeableItem
implements IDyeableItem,
ICapabilityProvider {
    private final boolean storesAlpha;
    private final boolean[] colorSet;
    private final int[] colors;

    public DyeableItem() {
        this(1, false);
    }

    public DyeableItem(int count, boolean alpha) {
        this.colorSet = new boolean[count];
        this.colors = new int[count];
        this.storesAlpha = alpha;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Capabilities.DYEABLE_ITEM;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.DYEABLE_ITEM ? Capabilities.DYEABLE_ITEM.cast((Object)this) : null);
    }

    @Override
    public int getColorSlotCount() {
        return this.colors.length;
    }

    @Override
    public int getColor(int slot) {
        if (this.hasColor(slot)) {
            return this.colors[slot];
        }
        return -1;
    }

    @Override
    public boolean hasColor(int slot) {
        return this.colorSet[slot];
    }

    @Override
    public boolean removeColor(int slot) {
        if (this.colorSet[slot]) {
            this.colorSet[slot] = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean setColor(int slot, int color) {
        this.colorSet[slot] = true;
        if (!this.storesAlpha) {
            color |= 0xFF000000;
        }
        this.colors[slot] = color;
        return true;
    }
}

