/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.command;

import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import pl.asie.charset.lib.command.CommandCharset;
import pl.asie.charset.lib.command.SubCommand;

public class SubCommandHelp
extends SubCommand {
    public SubCommandHelp(Side side) {
        super("help", side);
    }

    @Override
    public String getUsage() {
        return "Get help about a given command or all commands.";
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length >= 1) {
            SubCommand command = (this.getSide() == Side.CLIENT ? CommandCharset.CLIENT : CommandCharset.SERVER).SUB_COMMAND_MAP.get(args[0].toLowerCase(Locale.ROOT));
            if (command != null && sender.func_70003_b(this.getPermissionLevel(), "charset") && (command.getSide() == Side.SERVER || sender.func_130014_f_() != null && sender.func_130014_f_().field_72995_K)) {
                String[] usage = command.getUsage().split("\n");
                for (int i = 0; i < usage.length; ++i) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(usage[i]));
                }
            } else {
                sender.func_145747_a(new TextComponentTranslation("commands.generic.parameter.invalid", new Object[]{args[0]}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        } else {
            for (SubCommand command : (this.getSide() == Side.CLIENT ? CommandCharset.CLIENT : CommandCharset.SERVER).SUB_COMMANDS) {
                String[] usage;
                if (!sender.func_70003_b(this.getPermissionLevel(), "charset") || command.getSide() != Side.SERVER && (sender.func_130014_f_() == null || !sender.func_130014_f_().field_72995_K) || (usage = command.getUsage().split("\n")).length <= 0) continue;
                String name = TextFormatting.BOLD + command.getName() + TextFormatting.RESET;
                if (command.getAliases().size() > 0) {
                    name = name + " (" + CommandCharset.COMMAS.join(command.getAliases()) + ")";
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("- " + name + ": " + usage[0]));
                for (int i = 1; i < usage.length; ++i) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(usage[i]));
                }
            }
        }
    }
}

