/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.material;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.charset.lib.material.ItemMaterialRegistry;

public final class ItemMaterial {
    private final ItemStack stack;
    private final transient String id;
    private final transient String idForTexture;
    private final transient Set<String> types;
    private final transient Map<String, ItemMaterial> relations;

    protected ItemMaterial(ItemStack stack) {
        this.stack = stack;
        this.id = ItemMaterialRegistry.createId(stack);
        this.idForTexture = this.id.replaceAll("[^0-9a-zA-Z]+", "_");
        this.types = new HashSet<String>();
        this.relations = new HashMap<String, ItemMaterial>();
    }

    public Collection<String> getTypes() {
        return this.types;
    }

    public Map<String, ItemMaterial> getRelations() {
        return this.relations;
    }

    public ItemMaterial getRelated(String relation) {
        return this.relations.get(relation);
    }

    public String getId() {
        return this.id;
    }

    public String getIdForTexture() {
        return this.idForTexture;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void writeToNBT(NBTTagCompound compound, String key) {
        compound.func_74778_a(key, this.id);
    }

    public String toString() {
        return "ItemMaterial[" + this.id + "]";
    }
}

