/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render.sprite;

import java.awt.image.BufferedImage;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.render.sprite.TextureAtlasSpriteCustom;
import pl.asie.charset.lib.utils.RenderUtils;

public final class SpritesheetFactory {
    private SpritesheetFactory() {
    }

    public static TextureAtlasSprite[] register(TextureMap map, ResourceLocation location, int width, int height) {
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[width * height];
        for (int i = 0; i < sprites.length; ++i) {
            String s = String.format(location.toString() + "#%d", i);
            sprites[i] = map.getTextureExtry(s);
            if (sprites[i] != null) continue;
            sprites[i] = new SliceSprite(new ResourceLocation(s), location, i, width, height);
            map.setTextureEntry(sprites[i]);
        }
        return sprites;
    }

    protected static class SliceSprite
    extends TextureAtlasSpriteCustom {
        private final ResourceLocation location;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        protected SliceSprite(ResourceLocation loc, ResourceLocation location, int i, int width, int height) {
            super(loc.toString());
            this.location = location;
            this.width = width;
            this.height = height;
            this.x = i % width;
            this.y = i / width;
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }

        public boolean load(IResourceManager manager, ResourceLocation loc, Function<ResourceLocation, TextureAtlasSprite> getter) {
            BufferedImage sheet = RenderUtils.getTextureImage(this.location, getter);
            if (sheet == null) {
                ModCharset.logger.warn("Could not find texture sheet " + this.location + "!");
                return false;
            }
            int pieceWidth = sheet.getWidth() / this.width;
            int pieceHeight = sheet.getHeight() / this.height;
            int[] pixels = new int[pieceWidth * pieceHeight];
            sheet.getRGB(pieceWidth * this.x, pieceHeight * this.y, pieceWidth, pieceHeight, pixels, 0, pieceWidth);
            this.addFrameTextureData(pieceWidth, pieceHeight, pixels);
            return false;
        }
    }
}

