/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils.colorspace;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.PriorityQueue;
import java.util.function.Function;
import pl.asie.charset.lib.utils.colorspace.Colorspace;
import pl.asie.charset.lib.utils.colorspace.ColorspaceFunctions;

public class Colorspaces {
    private static boolean initialized = false;
    private static Table<Colorspace, Colorspace, Function<float[], float[]>> conversionTable;

    private static void buildConversionTable(ValueGraph<Colorspace, Function<float[], float[]>> conversionGraph) {
        for (Colorspace from : Colorspace.values()) {
            int[] distances = new int[Colorspace.values().length];
            Colorspace[] predecessors = new Colorspace[distances.length];
            PriorityQueue<Colorspace> nodesToTraverse = new PriorityQueue<Colorspace>(distances.length, Comparator.comparingInt(colorspace -> distances[colorspace.ordinal()]));
            for (Colorspace c : Colorspace.values()) {
                distances[c.ordinal()] = c != from ? Integer.MAX_VALUE : 0;
                nodesToTraverse.add(c);
            }
            while (!nodesToTraverse.isEmpty()) {
                Colorspace c = nodesToTraverse.poll();
                for (Colorspace other : conversionGraph.successors((Object)c)) {
                    if (distances[other.ordinal()] - 1 <= distances[c.ordinal()]) continue;
                    distances[other.ordinal()] = distances[c.ordinal()] + 1;
                    predecessors[other.ordinal()] = c;
                }
            }
            for (Colorspace to : Colorspace.values()) {
                if (from == to || predecessors[to.ordinal()] == null) continue;
                Colorspace[] path = new Colorspace[distances[to.ordinal()] + 1];
                Colorspace current = to;
                for (int i = path.length - 1; i >= 0; --i) {
                    path[i] = current;
                    current = predecessors[current.ordinal()];
                }
                Function function = null;
                for (int i = 0; i < path.length - 1; ++i) {
                    function = function == null ? (Function)conversionGraph.edgeValue((Object)path[i], (Object)path[i + 1]) : ((Function)conversionGraph.edgeValue((Object)path[i], (Object)path[i + 1])).compose(function);
                }
                if (function == null) continue;
                conversionTable.put((Object)from, (Object)to, function);
            }
        }
    }

    private static int asFF(float f) {
        if (f >= 1.0f) {
            return 255;
        }
        if (f <= 0.0f) {
            return 0;
        }
        return Math.round(f * 255.0f) & 0xFF;
    }

    public static float[] convert(float[] data, Colorspace from, Colorspace to) {
        if (from == to) {
            return data;
        }
        Function converter = (Function)conversionTable.get((Object)from, (Object)to);
        if (converter != null) {
            return (float[])converter.apply(data);
        }
        throw new RuntimeException("Could not convert from colorspace " + (Object)((Object)from) + " to " + (Object)((Object)to) + "!");
    }

    public static int convertToRGB(float[] data, Colorspace from) {
        float[] v = Colorspaces.convert(data, from, Colorspace.sRGB);
        return Colorspaces.asFF(v[0]) << 16 | Colorspaces.asFF(v[1]) << 8 | Colorspaces.asFF(v[2]);
    }

    public static float[] convertFromRGB(int v, Colorspace to) {
        float[] data = new float[]{(float)(v >> 16 & 0xFF) / 255.0f, (float)(v >> 8 & 0xFF) / 255.0f, (float)(v & 0xFF) / 255.0f};
        return Colorspaces.convert(data, Colorspace.sRGB, to);
    }

    public static double getColorDistance(float[] c1, float[] c2) {
        return Math.sqrt(Colorspaces.getColorDistanceSq(c1, c2));
    }

    public static double getColorDistance(int c1, int c2, Colorspace space) {
        return Math.sqrt(Colorspaces.getColorDistanceSq(c1, c2, space));
    }

    public static double getColorDistanceSq(float[] f1, float[] f2) {
        return (f1[0] - f2[0]) * (f1[0] - f2[0]) + (f1[1] - f2[1]) * (f1[1] - f2[1]) + (f1[2] - f2[2]) * (f1[2] - f2[2]);
    }

    public static double getColorDistanceSq(int c1, int c2, Colorspace space) {
        float[] f1 = Colorspaces.convertFromRGB(c1, space);
        float[] f2 = Colorspaces.convertFromRGB(c2, space);
        return (f1[0] - f2[0]) * (f1[0] - f2[0]) + (f1[1] - f2[1]) * (f1[1] - f2[1]) + (f1[2] - f2[2]) * (f1[2] - f2[2]);
    }

    public static void init() {
        if (!initialized) {
            initialized = true;
            MutableValueGraph conversionGraph = ValueGraphBuilder.directed().allowsSelfLoops(false).build();
            for (Colorspace c : Colorspace.values()) {
                conversionGraph.addNode((Object)c);
            }
            conversionGraph.putEdgeValue((Object)Colorspace.sRGB, (Object)Colorspace.XYZ, ColorspaceFunctions::sRGBtoXYZ);
            conversionGraph.putEdgeValue((Object)Colorspace.XYZ, (Object)Colorspace.sRGB, ColorspaceFunctions::XYZtosRGB);
            conversionGraph.putEdgeValue((Object)Colorspace.XYZ, (Object)Colorspace.LAB, ColorspaceFunctions::XYZtoLAB);
            conversionGraph.putEdgeValue((Object)Colorspace.LAB, (Object)Colorspace.XYZ, ColorspaceFunctions::LABtoXYZ);
            conversionGraph.putEdgeValue((Object)Colorspace.sRGB, (Object)Colorspace.YUV, ColorspaceFunctions::sRGBtoYUV);
            conversionGraph.putEdgeValue((Object)Colorspace.YUV, (Object)Colorspace.sRGB, ColorspaceFunctions::YUVtosRGB);
            conversionGraph.putEdgeValue((Object)Colorspace.sRGB, (Object)Colorspace.YIQ, ColorspaceFunctions::sRGBtoYIQ);
            conversionTable = Tables.newCustomTable(new EnumMap(Colorspace.class), () -> new EnumMap(Colorspace.class));
            Colorspaces.buildConversionTable((ValueGraph<Colorspace, Function<float[], float[]>>)conversionGraph);
        }
    }

    public static void main(String[] args) {
        Colorspaces.init();
    }
}

