/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.event.DynamicModelBakeEvent;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;
import team.chisel.ctm.client.util.ResourceUtil;
import team.chisel.ctm.client.util.TextureMetadataHandler;

public class CTMHelper {
    private static final Object2BooleanMap<ResourceLocation> wrappedModels = (Object2BooleanMap)ObfuscationReflectionHelper.getPrivateValue(TextureMetadataHandler.class, (Object)TextureMetadataHandler.INSTANCE, (String)"wrappedModels");
    private static final Class<?> multipartModelClass;
    private static final Class<?> vanillaModelWrapperClass;
    private static final Field multipartPartModels;
    private static final Field modelWrapperModel;
    private static final MethodHandle wrapMethod;

    @SubscribeEvent
    public static void onDynModelBake(DynamicModelBakeEvent event) {
        if (!(event.location instanceof ModelResourceLocation)) {
            return;
        }
        ModelResourceLocation mrl = (ModelResourceLocation)event.location;
        IModel rootModel = event.unbakedModel;
        if (rootModel != null) {
            if (event.bakedModel instanceof AbstractCTMModelInterface || event.bakedModel.func_188618_c()) {
                return;
            }
            ArrayDeque<Object> dependencies = new ArrayDeque<Object>();
            HashSet<Object> seenModels = new HashSet<Object>();
            dependencies.push(mrl);
            seenModels.add(mrl);
            boolean shouldWrap = (Boolean)wrappedModels.getOrDefault((Object)mrl, (Object)false);
            while (!shouldWrap && !dependencies.isEmpty()) {
                IModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == mrl ? rootModel : ModelLoaderRegistry.getModel((ResourceLocation)dep);
                }
                catch (Exception e) {
                    continue;
                }
                Set<Object> textures = Sets.newHashSet((Iterable)model.getTextures());
                if (vanillaModelWrapperClass.isAssignableFrom(model.getClass())) {
                    ModelBlock parent;
                    try {
                        parent = ((ModelBlock)CTMHelper.modelWrapperModel.get((Object)model)).field_178315_d;
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                    while (parent != null) {
                        textures.addAll(parent.field_178318_c.values().stream().filter(s -> !s.startsWith("#")).map(ResourceLocation::new).collect(Collectors.toSet()));
                        parent = parent.field_178315_d;
                    }
                }
                HashSet newDependencies = Sets.newHashSet((Iterable)model.getDependencies());
                if (multipartModelClass.isAssignableFrom(model.getClass())) {
                    Map partModels;
                    try {
                        partModels = (Map)multipartPartModels.get(model);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                    textures = partModels.values().stream().map(m -> m.getTextures()).flatMap(Collection::stream).collect(Collectors.toSet());
                    newDependencies.addAll(partModels.values().stream().flatMap(m -> m.getDependencies().stream()).collect(Collectors.toList()));
                }
                for (ResourceLocation tex : textures) {
                    IMetadataSectionCTM meta = null;
                    try {
                        meta = ResourceUtil.getMetadata((ResourceLocation)ResourceUtil.spriteToAbsolute((ResourceLocation)tex));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (meta == null) continue;
                    shouldWrap = true;
                    break;
                }
                for (ResourceLocation rl : newDependencies) {
                    if (!seenModels.add(rl)) continue;
                    dependencies.push(rl);
                }
            }
            wrappedModels.put((Object)mrl, shouldWrap);
            if (shouldWrap) {
                try {
                    event.bakedModel = wrapMethod.invokeExact(TextureMetadataHandler.INSTANCE, rootModel, event.bakedModel);
                    dependencies.clear();
                }
                catch (Throwable e) {
                    VintageFix.LOGGER.error("Could not wrap model " + mrl + ". Aborting...", e);
                }
            }
        }
    }

    static {
        try {
            multipartModelClass = Class.forName("net.minecraftforge.client.model.ModelLoader$MultipartModel");
            multipartPartModels = multipartModelClass.getDeclaredField("partModels");
            multipartPartModels.setAccessible(true);
            vanillaModelWrapperClass = Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper");
            modelWrapperModel = vanillaModelWrapperClass.getDeclaredField("model");
            modelWrapperModel.setAccessible(true);
            wrapMethod = MethodHandles.lookup().unreflect(ObfuscationReflectionHelper.findMethod(TextureMetadataHandler.class, (String)"wrap", IBakedModel.class, (Class[])new Class[]{IModel.class, IBakedModel.class}));
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static interface AbstractCTMModelInterface {
    }
}

