/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.book;

import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mystlibrary.MystLibrary;
import mystlibrary.book.BookPage;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public final class BookGenerator {
    private BookGenerator() {
    }

    public static ItemStack generateDescriptiveBook(List<BookPage> pages, @Nonnull String bookName, @Nonnull List<String> bookAuthors) {
        ItemStack bookStack = BookGenerator.getMystcraftStack("agebook");
        if (bookStack.func_190926_b()) {
            return bookStack;
        }
        bookStack.func_77964_b(0);
        NBTTagCompound compoundDesBook = new NBTTagCompound();
        compoundDesBook.func_74776_a("MaxHealth", 10.0f);
        compoundDesBook.func_74776_a("damage", 0.0f);
        compoundDesBook.func_74778_a("DisplayName", bookName);
        NBTTagList listAuthors = new NBTTagList();
        for (String author : bookAuthors) {
            NBTTagString stringAuthor = new NBTTagString(author);
            listAuthors.func_74742_a((NBTBase)stringAuthor);
        }
        compoundDesBook.func_74782_a("Authors", (NBTBase)listAuthors);
        NBTTagList listPages = new NBTTagList();
        for (BookPage page : pages) {
            if (page.getSymbol() != null) {
                NBTTagCompound compoundSymbol = BookGenerator.generateSymbolPage(page.getSymbol());
                listPages.func_74742_a((NBTBase)compoundSymbol);
                continue;
            }
            if (page.getPanelEffects() != null) {
                NBTTagCompound compoundLinkPanel = BookGenerator.generateLinkPanelPage(page.getPanelEffects());
                listPages.func_74742_a((NBTBase)compoundLinkPanel);
                continue;
            }
            NBTTagCompound compoundBlankPage = BookGenerator.generateBlankPage();
            listPages.func_74742_a((NBTBase)compoundBlankPage);
        }
        compoundDesBook.func_74782_a("Pages", (NBTBase)listPages);
        bookStack.func_77982_d(compoundDesBook);
        return bookStack;
    }

    public static NBTTagCompound generateLinkPanelPage(List<String> effects) {
        NBTTagCompound compoundPage = BookGenerator.generateBlankPage();
        NBTTagList properties = new NBTTagList();
        for (String effect : effects) {
            NBTTagString effectName = new NBTTagString(effect);
            properties.func_74742_a((NBTBase)effectName);
        }
        NBTTagCompound panel = new NBTTagCompound();
        panel.func_74782_a("properties", (NBTBase)properties);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("linkpanel", (NBTBase)panel);
        compoundPage.func_74782_a("tag", (NBTBase)tag);
        return compoundPage;
    }

    @Nullable
    public static NBTTagCompound generateSymbolPage(ResourceLocation location) {
        NBTTagCompound compoundPage = BookGenerator.generateBlankPage();
        NBTTagCompound tag = new NBTTagCompound();
        String id = location.toString();
        tag.func_74778_a("symbol", id);
        compoundPage.func_74782_a("tag", (NBTBase)tag);
        return compoundPage;
    }

    public static NBTTagCompound generateBlankPage() {
        NBTTagCompound compoundPage = new NBTTagCompound();
        compoundPage.func_74774_a("Count", (byte)1);
        compoundPage.func_74777_a("Damage", (short)0);
        compoundPage.func_74778_a("id", "mystcraft:page");
        NBTTagCompound tag = new NBTTagCompound();
        compoundPage.func_74782_a("tag", (NBTBase)tag);
        return compoundPage;
    }

    public static ItemStack generateLinkingBook(BlockPos blockPos, float yaw, int dimension, String displayName, Map<String, Boolean> effects) {
        ItemStack bookStack = BookGenerator.getMystcraftStack("linkbook");
        if (bookStack.func_190926_b()) {
            return bookStack;
        }
        ILinkInfo info = MystLibrary.mystcraft.linking.createLinkInfo(null);
        info.setDimensionUID(dimension);
        info.setTargetUUID(new UUID(dimension, 0L));
        info.setSpawnYaw(yaw);
        if (displayName != null) {
            info.setDisplayName(displayName);
        }
        if (blockPos != null) {
            info.setSpawn(blockPos);
        }
        if (effects != null) {
            for (Map.Entry<String, Boolean> flag : effects.entrySet()) {
                info.setFlag(flag.getKey(), flag.getValue().booleanValue());
            }
        }
        bookStack.func_77982_d(info.getTagCompound());
        return bookStack;
    }

    public static ItemStack getMystcraftStack(String name) {
        ItemStack stack = ItemStack.field_190927_a;
        String id = "mystcraft:" + name;
        Item item = Item.func_111206_d((String)id);
        if (item != null) {
            stack = new ItemStack(item);
        } else {
            MystLibrary.logger.error("Item \"" + id + "\" is not present. Returning empty ItemStack.");
        }
        return stack;
    }
}

