/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.book;

import com.google.common.collect.Lists;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.util.List;
import javax.annotation.Nonnull;
import mystlibrary.book.BookGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public final class BookPage {
    private PageType type = null;
    private ResourceLocation symbol = null;
    private List<String> panelEffects = null;

    private BookPage(PageType pageType, ResourceLocation location, List<String> effects) {
        this.setType(pageType);
        this.setSymbol(location);
        this.setPanelEffects(effects);
    }

    public static BookPage blankPage() {
        return new BookPage(PageType.BLANK_PAGE, null, null);
    }

    public static BookPage symbolPage(@Nonnull ResourceLocation location) {
        return new BookPage(PageType.SYMBOL, location, null);
    }

    public static BookPage symbolPage(@Nonnull IAgeSymbol symbol) {
        return BookPage.symbolPage(symbol.getRegistryName());
    }

    public static BookPage linkPanelPage(@Nonnull List<String> effects) {
        return new BookPage(PageType.LINKING_PANEL, null, effects);
    }

    public static BookPage linkPanelPage(String ... effects) {
        return BookPage.linkPanelPage(Lists.newArrayList((Object[])effects));
    }

    public ResourceLocation getSymbol() {
        if (this.getType().equals((Object)PageType.SYMBOL)) {
            return this.symbol;
        }
        return null;
    }

    private void setSymbol(ResourceLocation location) {
        this.symbol = location;
    }

    public List<String> getPanelEffects() {
        if (this.getType().equals((Object)PageType.LINKING_PANEL)) {
            return this.panelEffects;
        }
        return null;
    }

    private void setPanelEffects(List<String> effects) {
        this.panelEffects = effects;
    }

    public PageType getType() {
        return this.type;
    }

    private void setType(PageType pageType) {
        this.type = pageType;
    }

    public ItemStack asItemStack() {
        ItemStack pageStack = BookGenerator.getMystcraftStack("page");
        if (pageStack.func_190926_b()) {
            return pageStack;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        switch (this.getType()) {
            case BLANK_PAGE: {
                nbt = BookGenerator.generateBlankPage();
                break;
            }
            case SYMBOL: {
                nbt = BookGenerator.generateLinkPanelPage(this.getPanelEffects());
                break;
            }
            case LINKING_PANEL: {
                nbt = BookGenerator.generateSymbolPage(this.getSymbol());
            }
        }
        pageStack.func_77982_d(nbt);
        return pageStack;
    }

    public static enum PageType {
        BLANK_PAGE,
        SYMBOL,
        LINKING_PANEL;

    }
}

