/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.mystcraftapi;

import com.xcompwiz.mystcraft.api.APIInstanceProvider;
import com.xcompwiz.mystcraft.api.MystObjects;
import com.xcompwiz.mystcraft.api.exception.APIUndefined;
import com.xcompwiz.mystcraft.api.exception.APIVersionRemoved;
import com.xcompwiz.mystcraft.api.exception.APIVersionUndefined;
import com.xcompwiz.mystcraft.api.hook.DimensionAPI;
import com.xcompwiz.mystcraft.api.hook.GrammarAPI;
import com.xcompwiz.mystcraft.api.hook.InstabilityAPI;
import com.xcompwiz.mystcraft.api.hook.InstabilityFactory;
import com.xcompwiz.mystcraft.api.hook.ItemFactory;
import com.xcompwiz.mystcraft.api.hook.LinkPropertyAPI;
import com.xcompwiz.mystcraft.api.hook.LinkingAPI;
import com.xcompwiz.mystcraft.api.hook.PageAPI;
import com.xcompwiz.mystcraft.api.hook.RenderAPI;
import com.xcompwiz.mystcraft.api.hook.SymbolAPI;
import com.xcompwiz.mystcraft.api.hook.SymbolFactory;
import com.xcompwiz.mystcraft.api.hook.SymbolValuesAPI;
import com.xcompwiz.mystcraft.api.hook.WordAPI;
import mystlibrary.MystLibrary;
import org.apache.logging.log4j.Logger;

public final class MystcraftApiWrapper {
    private final Logger log = MystLibrary.logger;
    public final DimensionAPI dimension;
    public final GrammarAPI grammar;
    public final InstabilityAPI instability;
    public final InstabilityFactory instabilityFactory;
    public final ItemFactory itemFactory;
    public final LinkingAPI linking;
    public final LinkPropertyAPI linkProperty;
    public final PageAPI page;
    public final RenderAPI render;
    public final SymbolAPI symbol;
    public final SymbolFactory symbolFactory;
    public final SymbolValuesAPI symbolValues;
    public final WordAPI word;

    public MystcraftApiWrapper() {
        APIInstanceProvider provider;
        this.log.info("Initializing Mystcraft APIs");
        try {
            provider = MystObjects.entryPoint.getProviderInstance();
        }
        catch (Exception ex) {
            this.log.error("Failed to get Mystcraft API Provider!");
            this.log.error(ex.getMessage());
            provider = new FakeInstanceProvider();
        }
        this.dimension = (DimensionAPI)this.getInstanceFromProvider(provider, "dimension-1");
        this.grammar = (GrammarAPI)this.getInstanceFromProvider(provider, "grammar-1");
        this.instability = (InstabilityAPI)this.getInstanceFromProvider(provider, "instability-1");
        this.instabilityFactory = (InstabilityFactory)this.getInstanceFromProvider(provider, "instabilityfact-1");
        this.itemFactory = (ItemFactory)this.getInstanceFromProvider(provider, "itemfact-1");
        this.linking = (LinkingAPI)this.getInstanceFromProvider(provider, "linking-1");
        this.linkProperty = (LinkPropertyAPI)this.getInstanceFromProvider(provider, "linkingprop-1");
        this.page = (PageAPI)this.getInstanceFromProvider(provider, "page-1");
        this.render = (RenderAPI)this.getInstanceFromProvider(provider, "render-1");
        this.symbol = (SymbolAPI)this.getInstanceFromProvider(provider, "symbol-1");
        this.symbolFactory = (SymbolFactory)this.getInstanceFromProvider(provider, "symbolfact-1");
        this.symbolValues = (SymbolValuesAPI)this.getInstanceFromProvider(provider, "symbolvals-1");
        this.word = (WordAPI)this.getInstanceFromProvider(provider, "word-1");
    }

    private Object getInstanceFromProvider(APIInstanceProvider provider, String instanceName) {
        try {
            return provider.getAPIInstance(instanceName);
        }
        catch (APIVersionRemoved e1) {
            this.log.error("API version removed!");
            this.log.error(e1.getMessage());
        }
        catch (APIVersionUndefined e2) {
            this.log.error("API version undefined!");
            this.log.error(e2.getMessage());
        }
        catch (APIUndefined e3) {
            MystLibrary.logger.error("API undefined!");
            MystLibrary.logger.error(e3.getMessage());
        }
        return null;
    }

    private final class FakeInstanceProvider
    implements APIInstanceProvider {
        private FakeInstanceProvider() {
        }

        public Object getAPIInstance(String api) throws APIUndefined, APIVersionUndefined, APIVersionRemoved {
            return null;
        }
    }
}

