/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.symbol;

import com.google.common.collect.HashMultimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import mystlibrary.MystLibrary;
import mystlibrary.exception.ModMissingException;
import mystlibrary.exception.SymbolBuildException;
import mystlibrary.proxy.CommonProxy;
import mystlibrary.symbol.AgeSymbol;
import mystlibrary.symbol.behavior.IAgeSymbolBehavior;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

public class SymbolLoader {
    private static final Pattern FILENAME_PATTERN = Pattern.compile(".*?/{0,1}assets/.*?/symbols/[^/]*?.json");
    private static final Pattern CONFIG_PATTERN = Pattern.compile(".*?/{0,1}config/mystcraft/mystlibrary/symbols/[^/]*?.json");
    private static final Logger LOGGER = MystLibrary.logger;
    public static final HashMap<ResourceLocation, IAgeSymbolBehavior.BehaviorFactory> BEHAVIORS = new HashMap();
    private final ClassLoader loader = this.getClass().getClassLoader();

    public void registerSymbols(IForgeRegistry<IAgeSymbol> registry) {
        File symbolConfigDir = new File(CommonProxy.configDirectory, "mystcraft" + File.separator + "mystlibrary" + File.separator + "symbols");
        if (!symbolConfigDir.exists()) {
            symbolConfigDir.mkdirs();
        }
        LOGGER.info("Loading Age Symbols from JSON....");
        List<String> paths = this.getSymbolPathsFromConfigDir(symbolConfigDir);
        List<AnyFile> files = this.getModFiles();
        for (AnyFile file : files) {
            if (file.jarFile != null) {
                paths.addAll(this.getSymbolPathsFromJarFile(file.jarFile));
                continue;
            }
            paths.addAll(this.getSymbolPathsFromFile(file.file));
        }
        HashMultimap missingMods = HashMultimap.create();
        for (String path : paths) {
            JsonArray json;
            LOGGER.info("Loading symbols from " + path);
            String stringContent = this.getFileContents(path);
            try {
                json = new JsonParser().parse(stringContent).getAsJsonArray();
            }
            catch (IllegalStateException e) {
                LOGGER.error("Expected JsonArray but found another type: " + stringContent);
                e.printStackTrace();
                continue;
            }
            catch (JsonParseException e) {
                LOGGER.error("Parsed text is not valid JSON: " + stringContent);
                e.printStackTrace();
                continue;
            }
            for (JsonElement symbolJson : json) {
                AgeSymbol symbol = null;
                try {
                    symbol = AgeSymbol.fromJson(symbolJson.getAsJsonObject());
                }
                catch (SymbolBuildException ex) {
                    LOGGER.info("Failed to build symbol \"" + ex.symbolId + "\" from file \"" + URI.create(path).getPath().substring(1) + "\":  " + ex.message);
                }
                catch (ModMissingException.BlockSymbol ex) {
                    missingMods.put((Object)new ResourceLocation(ex.blockId).func_110624_b(), (Object)path);
                }
                if (symbol == null) continue;
                if (registry.containsKey(symbol.getRegistryName())) {
                    LOGGER.error("Refusing to register duplicate symbol " + symbol.getRegistryName().toString());
                    continue;
                }
                registry.register((IForgeRegistryEntry)symbol);
                symbol.registerGrammarRules();
                symbol.registerSymbolRank();
            }
        }
        for (Map.Entry entry : missingMods.entries()) {
            LOGGER.info("One or more block symbols from mod \"" + (String)entry.getKey() + "\" added from " + (String)entry.getValue() + " failed to load because the block's mod is not present. Add or enable this mod if you would like to use these symbols.");
        }
    }

    private String getFileContents(String path) {
        String contents = "";
        try {
            InputStream stream = this.loader.getResourceAsStream(path);
            if (stream == null) {
                path = path.replaceAll("%20", " ");
                stream = this.loader.getResourceAsStream(path);
            }
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)stream, (Writer)writer, (String)"UTF-8");
            contents = writer.toString();
        }
        catch (IOException ex) {
            LOGGER.error("IOException -> Failed to load file contents: " + path);
            LOGGER.error((Object)ex);
        }
        catch (Exception ex2) {
            LOGGER.error("Exception -> Failed to load file contents: " + path);
            LOGGER.error((Object)ex2);
        }
        return contents;
    }

    private List<String> getSymbolPathsFromJarFile(JarFile jarFile) {
        ArrayList<String> paths = new ArrayList<String>();
        Enumeration<JarEntry> files = jarFile.entries();
        while (files.hasMoreElements()) {
            JarEntry file = files.nextElement();
            String name = file.getName();
            if (!FILENAME_PATTERN.matcher(name).matches()) continue;
            paths.add(name);
        }
        return paths;
    }

    private List<String> getSymbolPathsFromFile(File file) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            Files.walk(file.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> FILENAME_PATTERN.matcher(path.toUri().toString()).matches()).forEach(path -> paths.add(path.toUri().toString()));
        }
        catch (IOException ex) {
            LOGGER.error("Failed to get symbol paths under " + file.toString());
        }
        return paths;
    }

    private List<String> getSymbolPathsFromConfigDir(File file) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!file.exists()) {
            try {
                file.mkdir();
            }
            catch (SecurityException ex) {
                LOGGER.error("Cannot create symbols directory in config/mystcraft/symbols because of security exception.");
                ex.printStackTrace();
            }
        }
        try {
            Files.walk(file.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> CONFIG_PATTERN.matcher(path.toUri().toString()).matches()).forEach(path -> paths.add(path.toUri().toString()));
        }
        catch (IOException ex) {
            LOGGER.error("Failed to get symbol paths under " + file.toString());
        }
        return paths;
    }

    private List<AnyFile> getModFiles() {
        List<URL> urls = this.getModAssetUrls();
        ArrayList<AnyFile> files = new ArrayList<AnyFile>();
        for (URL url : urls) {
            try {
                URLConnection connection = url.openConnection();
                if (connection instanceof JarURLConnection) {
                    JarURLConnection jarConnection = (JarURLConnection)connection;
                    files.add(new AnyFile(jarConnection.getJarFile()));
                    continue;
                }
                files.add(new AnyFile(Paths.get(url.toURI()).toFile()));
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load jar file: " + url.toString());
                LOGGER.error((Object)ex);
            }
            catch (URISyntaxException ex2) {
                LOGGER.error("Failed to load file: " + url.toString());
                LOGGER.error((Object)ex2);
            }
        }
        return files;
    }

    private List<URL> getModAssetUrls() {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            Enumeration<URL> enumeration = this.loader.getResources("assets/");
            while (enumeration.hasMoreElements()) {
                urls.add(enumeration.nextElement());
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load mod asset directories");
            LOGGER.error((Object)ex);
        }
        return urls;
    }

    public void registerBehavior(ResourceLocation behaviorName, IAgeSymbolBehavior.BehaviorFactory factory) {
        BEHAVIORS.put(behaviorName, factory);
    }

    private static class AnyFile {
        private final JarFile jarFile;
        private final File file;

        private AnyFile(JarFile jarFile) {
            this.jarFile = jarFile;
            this.file = null;
        }

        private AnyFile(File file) {
            this.jarFile = null;
            this.file = file;
        }
    }
}

