/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.symbol.behavior;

import com.google.gson.JsonObject;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import java.util.HashMap;
import java.util.Map;
import mystlibrary.MystLibrary;
import mystlibrary.exception.SymbolBuildException;
import mystlibrary.symbol.SymbolMetadata;
import mystlibrary.symbol.behavior.IAgeSymbolBehavior;
import mystlibrary.symbol.util.SymbolJsonParser;
import net.minecraft.util.ResourceLocation;

public final class FloatModifierBehavior
implements IAgeSymbolBehavior {
    public static final ResourceLocation NAME = MystLibrary.resource("float_modifier");
    public static final Map<String, String> MODIFIER_TYPES = FloatModifierBehavior.buildModifierMap();
    private static final String FIELD_NAME_VALUE = "value";
    private final float value;
    private static final String FIELD_NAME_TYPE = "type";
    private final String type;

    public static IAgeSymbolBehavior fromJson(JsonObject json, SymbolMetadata metadata) throws SymbolBuildException {
        FloatModifierBehavior behavior = null;
        float value = SymbolJsonParser.parseFloat(json, FIELD_NAME_VALUE, metadata);
        String type = SymbolJsonParser.parseString(json, FIELD_NAME_TYPE, metadata);
        behavior = new FloatModifierBehavior(value, type);
        return behavior;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("behavior_id", NAME.toString());
        json.addProperty(FIELD_NAME_VALUE, (Number)Float.valueOf(this.value));
        json.addProperty(FIELD_NAME_TYPE, this.type);
        return json;
    }

    public FloatModifierBehavior(float value, String type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        Number previousValue = controller.popModifier(MODIFIER_TYPES.get(this.type)).asNumber();
        if (previousValue == null) {
            previousValue = Float.valueOf(this.value);
        }
        float averageValue = 0.0f;
        switch (this.type) {
            case "direction": 
            case "phase": {
                averageValue = ModifierUtils.averageAngles((float)previousValue.floatValue(), (float)this.value);
                break;
            }
            case "length": {
                averageValue = ModifierUtils.averageLengths((float)previousValue.floatValue(), (float)this.value);
                break;
            }
            default: {
                averageValue = ModifierUtils.averageLengths((float)previousValue.floatValue(), (float)this.value);
            }
        }
        controller.setModifier(MODIFIER_TYPES.get(this.type), (Object)Float.valueOf(averageValue));
    }

    public static Map<String, String> buildModifierMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("direction", "angle");
        map.put("length", "wavelength");
        map.put("phase", "phase");
        return map;
    }
}

