/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.symbol.util;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.util.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mystlibrary.MystLibrary;
import mystlibrary.symbol.util.SymbolConverter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public final class SymbolCache {
    private static Map<ResourceLocation, Object> mapAllSymbols = new HashMap<ResourceLocation, Object>();
    private static Map<ResourceLocation, Biome> mapBiomes = new HashMap<ResourceLocation, Biome>();
    private static Map<ResourceLocation, IBlockState> mapBlocks = new HashMap<ResourceLocation, IBlockState>();
    private static Map<ResourceLocation, Color> mapColors = new HashMap<ResourceLocation, Color>();
    private static Map<ResourceLocation, Number> mapDirections = new HashMap<ResourceLocation, Number>();
    private static Map<ResourceLocation, Number> mapLengths = new HashMap<ResourceLocation, Number>();
    private static Map<ResourceLocation, Number> mapPhases = new HashMap<ResourceLocation, Number>();

    private SymbolCache() {
    }

    public static void cacheAllSymbols() {
        List symbols = MystLibrary.mystcraft.symbol.getAllRegisteredSymbols();
        for (IAgeSymbol symbol : symbols) {
            if (SymbolConverter.toBiome(symbol, false) != null) {
                SymbolCache.addToBiomeSymbols(symbol, SymbolConverter.toBiome(symbol, true));
                continue;
            }
            if (SymbolConverter.toBlockState(symbol, false) != null) {
                SymbolCache.addToBlockSymbols(symbol, SymbolConverter.toBlockState(symbol, true));
                continue;
            }
            if (SymbolConverter.toColor(symbol, false) != null) {
                SymbolCache.addToColorSymbols(symbol, SymbolConverter.toColor(symbol, true));
                continue;
            }
            if (SymbolConverter.toDirection(symbol, false) != null) {
                SymbolCache.addToDirectionSymbols(symbol, SymbolConverter.toDirection(symbol, true));
                continue;
            }
            if (SymbolConverter.toLength(symbol, false) != null) {
                SymbolCache.addToLengthSymbols(symbol, SymbolConverter.toLength(symbol, true));
                continue;
            }
            if (SymbolConverter.toPhase(symbol, false) == null) continue;
            SymbolCache.addToPhaseSymbols(symbol, SymbolConverter.toPhase(symbol, true));
        }
    }

    public static void addToAllSymbols(ResourceLocation loc, Object obj) {
        mapAllSymbols.put(loc, obj);
    }

    public static void addToAllSymbols(IAgeSymbol sym, Object obj) {
        SymbolCache.addToAllSymbols(sym.getRegistryName(), obj);
    }

    public static void addToBiomeSymbols(ResourceLocation loc, Biome obj) {
        mapBiomes.put(loc, obj);
        SymbolCache.addToAllSymbols(loc, (Object)obj);
    }

    public static void addToBiomeSymbols(IAgeSymbol sym, Biome obj) {
        SymbolCache.addToBiomeSymbols(sym.getRegistryName(), obj);
    }

    public static void addToBlockSymbols(ResourceLocation loc, IBlockState obj) {
        mapBlocks.put(loc, obj);
        SymbolCache.addToAllSymbols(loc, (Object)obj);
    }

    public static void addToBlockSymbols(IAgeSymbol sym, IBlockState obj) {
        SymbolCache.addToBlockSymbols(sym.getRegistryName(), obj);
    }

    public static void addToColorSymbols(ResourceLocation loc, Color obj) {
        mapColors.put(loc, obj);
        SymbolCache.addToAllSymbols(loc, (Object)obj);
    }

    public static void addToColorSymbols(IAgeSymbol sym, Color obj) {
        SymbolCache.addToColorSymbols(sym.getRegistryName(), obj);
    }

    public static void addToDirectionSymbols(ResourceLocation loc, Number obj) {
        mapDirections.put(loc, obj);
        SymbolCache.addToAllSymbols(loc, (Object)obj);
    }

    public static void addToDirectionSymbols(IAgeSymbol sym, Number obj) {
        SymbolCache.addToDirectionSymbols(sym.getRegistryName(), obj);
    }

    public static void addToLengthSymbols(ResourceLocation loc, Number obj) {
        mapLengths.put(loc, obj);
        SymbolCache.addToAllSymbols(loc, (Object)obj);
    }

    public static void addToLengthSymbols(IAgeSymbol sym, Number obj) {
        SymbolCache.addToLengthSymbols(sym.getRegistryName(), obj);
    }

    public static void addToPhaseSymbols(ResourceLocation loc, Number obj) {
        mapPhases.put(loc, obj);
        SymbolCache.addToAllSymbols(loc, (Object)obj);
    }

    public static void addToPhaseSymbols(IAgeSymbol sym, Number obj) {
        SymbolCache.addToPhaseSymbols(sym.getRegistryName(), obj);
    }

    public static Map<ResourceLocation, Object> getAllCachedSymbols() {
        return new HashMap<ResourceLocation, Object>(mapAllSymbols);
    }

    public static Map<ResourceLocation, Biome> getCachedBiomeSymbols() {
        return new HashMap<ResourceLocation, Biome>(mapBiomes);
    }

    public static Map<ResourceLocation, IBlockState> getCachedBlockSymbols() {
        return new HashMap<ResourceLocation, IBlockState>(mapBlocks);
    }

    public static Map<ResourceLocation, Color> getCachedColorSymbols() {
        return new HashMap<ResourceLocation, Color>(mapColors);
    }

    public static Map<ResourceLocation, Number> getCachedDirectionSymbols() {
        return new HashMap<ResourceLocation, Number>(mapDirections);
    }

    public static Map<ResourceLocation, Number> getCachedLengthSymbols() {
        return new HashMap<ResourceLocation, Number>(mapLengths);
    }

    public static Map<ResourceLocation, Number> getCachedPhaseSymbols() {
        return new HashMap<ResourceLocation, Number>(mapPhases);
    }
}

