/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.zenscript.GlobalRegistry;
import java.util.function.Consumer;
import leviathan143.loottweaker.common.CTLoggingErrorHandler;
import leviathan143.loottweaker.common.DeprecationWarningManager;
import leviathan143.loottweaker.common.LTConfig;
import leviathan143.loottweaker.common.LootTweakerNetworkChecker;
import leviathan143.loottweaker.common.command.CommandLootTables;
import leviathan143.loottweaker.common.lib.EventBusInspector;
import leviathan143.loottweaker.common.lib.Texts;
import leviathan143.loottweaker.common.zenscript.LootTweakerContext;
import leviathan143.loottweaker.common.zenscript.ZenLootTableTweakManager;
import leviathan143.loottweaker.common.zenscript.factory.ZenLambdaLootCondition;
import leviathan143.loottweaker.common.zenscript.factory.ZenLambdaLootFunction;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolPackage;

@Mod(modid="loottweaker", name="LootTweaker", version="0.4.1", dependencies="required-after:crafttweaker@[4.1.20,); before:jeresources; required:forge@[14.23.5.2779,);")
public class LootTweaker {
    public static final String MODNAME = "LootTweaker";
    public static final String MODID = "loottweaker";
    public static final String VERSION = "0.4.1";
    public static final String DEPENDENCIES = "required-after:crafttweaker@[4.1.20,); before:jeresources; required:forge@[14.23.5.2779,);";
    public static final LootTweakerContext CONTEXT = new LootTweakerContext(new CTLoggingErrorHandler());
    private static final Logger LOGGER = LogManager.getLogger((String)"LootTweaker");

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LootTweakerNetworkChecker.install();
        LTConfig.onLoad();
        LootFunctionManager.func_186582_a(ZenLambdaLootFunction.SERIALISER);
        LootConditionManager.func_186639_a(ZenLambdaLootCondition.SERIALISER);
        this.registerAliases("Conditions", "Functions", "LootCondition", "LootFunction", "LootPool", "LootTable");
    }

    private void registerAliases(String ... aliased) {
        SymbolPackage loottweaker = (SymbolPackage)GlobalRegistry.getRoot().get(MODID);
        SymbolPackage loottweakerVanilla = new SymbolPackage("loottweaker.vanilla");
        loottweaker.put("vanilla", (IZenSymbol)loottweakerVanilla, GlobalRegistry.getErrors());
        SymbolPackage loottweakerVanillaLoot = new SymbolPackage("loottweaker.vanilla.loot");
        loottweakerVanilla.put("loot", (IZenSymbol)loottweakerVanillaLoot, GlobalRegistry.getErrors());
        for (String simpleName : aliased) {
            loottweakerVanillaLoot.put(simpleName, loottweaker.get(simpleName), GlobalRegistry.getErrors());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CTChatCommand.registerCommand((CraftTweakerCommand)new CommandLootTables());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ZenLootTableTweakManager.onServerStarting(event);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        EventBusInspector.getListeners(MinecraftForge.EVENT_BUS).filter(listener -> {
            if (listener.owner == null) {
                LOGGER.error("Null owning mod container for listener {}", listener);
                return false;
            }
            if (listener.owner.getModId() == null) {
                LOGGER.error("Null mod id for owning mod container {} of listener {}", (Object)listener.owner, listener);
                return false;
            }
            boolean whitelisted = listener.owner.getModId().equals(MODID) || listener.owner.getModId().equals("zen_loot_tables");
            return !whitelisted && listener.eventType == LootTableLoadEvent.class && listener.priority == EventPriority.LOWEST;
        }).peek(listener -> CraftTweakerAPI.logInfo((String)String.format("Found listener for LootTableLoadEvent at lowest priority: %s", listener))).map(listener -> listener.owner).distinct().forEach(mod -> CraftTweakerAPI.logInfo((String)String.format("%1$s listens to LootTableLoadEvent at lowest priority. Any loot added by %1$s cannot be edited by LootTweaker.", mod.getName())));
        DeprecationWarningManager.printDeprecationWarnings();
    }

    public static TextComponentTranslation translation(String keySuffix, Object ... args) {
        return new TextComponentTranslation(MODID + keySuffix, args);
    }

    public static TextComponentTranslation translation(String keySuffix, Consumer<Style> styler, Object ... args) {
        return Texts.styled(new TextComponentTranslation(MODID + keySuffix, args), styler);
    }
}

