/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.command;

import com.google.common.collect.ImmutableMap;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import leviathan143.loottweaker.common.LootTweaker;
import leviathan143.loottweaker.common.command.Subcommand;
import leviathan143.loottweaker.common.command.SubcommandDumpAll;
import leviathan143.loottweaker.common.command.SubcommandDumpNamed;
import leviathan143.loottweaker.common.command.SubcommandDumpTargetsLootTable;
import leviathan143.loottweaker.common.command.SubcommandGenerate;
import leviathan143.loottweaker.common.command.SubcommandListLootTables;
import leviathan143.loottweaker.common.lib.Texts;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.ArrayUtils;

public class CommandLootTables
extends CraftTweakerCommand {
    private final Map<String, Subcommand> subcommands = ImmutableMap.builder().put((Object)"all", (Object)new SubcommandDumpAll()).put((Object)"byName", (Object)new SubcommandDumpNamed()).put((Object)"target", (Object)new SubcommandDumpTargetsLootTable()).put((Object)"list", (Object)new SubcommandListLootTables()).put((Object)"generate", (Object)new SubcommandGenerate()).build();
    private static final String DOCS_URL = "https://loottweaker-docs.readthedocs.io/en/latest/reference/commands.html";

    public CommandLootTables() {
        super("loottables");
    }

    protected void init() {
        this.setDescription(new ITextComponent[]{LootTweaker.translation(".commands.dump.desc", new Object[0])});
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 1 || args.length == 1 && args[0].equals("help")) {
            for (String subcommand : this.subcommands.keySet()) {
                sender.func_145747_a((ITextComponent)LootTweaker.translation(".commands.dump." + subcommand + ".usage", style -> style.func_150238_a(TextFormatting.RED), new Object[0]));
            }
            sender.func_145747_a((ITextComponent)LootTweaker.translation(".messages.openDocs", Texts.Styles.urlLink(DOCS_URL), new Object[0]));
            return;
        }
        Subcommand subcommand = this.subcommands.get(args[0]);
        if (subcommand != null) {
            try {
                subcommand.execute(server, sender, args);
            }
            catch (CommandException e) {
                sender.func_145747_a((ITextComponent)Texts.styled(new TextComponentTranslation(e.getMessage(), e.func_74844_a()), style -> style.func_150238_a(TextFormatting.RED)));
            }
        } else {
            sender.func_145747_a((ITextComponent)LootTweaker.translation(".commands.dump.unknownSubcommand", args[0]));
        }
    }

    public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return Stream.concat(this.subcommands.keySet().stream(), Stream.of("help")).filter(s -> s.startsWith(args[0])).collect(Collectors.toList());
        }
        Subcommand subcommand = this.subcommands.get(args[0]);
        if (subcommand != null && args.length <= subcommand.getMaxArguments() + 1) {
            return subcommand.getCompletions(server, sender, (String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length), targetPos);
        }
        return Collections.emptyList();
    }
}

