/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.lib;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import leviathan143.loottweaker.common.lib.LootConditions;
import leviathan143.loottweaker.common.mixin.LootEntryAccessors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RobustLootEntrySerialiser
implements JsonSerializer<LootEntry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final JsonSerializer<LootEntry> vanilla = new LootEntry.Serializer();

    public JsonElement serialize(LootEntry entry, Type type, JsonSerializationContext context) {
        if (entry instanceof LootEntryItem || entry instanceof LootEntryTable || entry instanceof LootEntryEmpty) {
            return this.vanilla.serialize((Object)this.patch(entry), type, context);
        }
        JsonObject json = new JsonObject();
        json.addProperty("entryName", entry.getEntryName());
        json.addProperty("weight", (Number)((LootEntryAccessors)entry).getWeight());
        json.addProperty("quality", (Number)((LootEntryAccessors)entry).getQuality());
        json.addProperty("type", "loottweaker:best_effort");
        LootCondition[] conditions = LootConditions.get(entry);
        if (conditions.length > 0) {
            json.add("conditions", context.serialize((Object)conditions));
        }
        JsonObject bestEffort = new JsonObject();
        if (this.trySerialise(entry, json, context)) {
            bestEffort.addProperty("comment", "A best effort serialisation of a mod-added serialisable entry type");
        } else {
            LootEntryFields.forClass(entry.getClass()).serialise(bestEffort, entry);
            bestEffort.addProperty("comment", "A best effort serialisation of a mod-added non-serialisable entry type");
        }
        bestEffort.addProperty("class", entry.getClass().getName());
        json.add("loottweaker:best_effort", (JsonElement)bestEffort);
        return json;
    }

    private boolean trySerialise(LootEntry entry, JsonObject json, JsonSerializationContext context) {
        int before = json.size();
        ((LootEntryAccessors)entry).callSerialize(json, context);
        return json.size() != before;
    }

    private LootEntry patch(LootEntry entry) {
        if (((LootEntryAccessors)entry).getConditionsUnsafe() == null) {
            ((LootEntryAccessors)entry).setConditions(LootConditions.NONE);
        }
        return entry;
    }

    private static class LootEntryFields {
        private static final Map<Class<?>, LootEntryFields> KNOWN_ENTRY_TYPES = new HashMap();
        private static final Set<Class<?>> PRIMITIVE_NUMBER_CLASSES = Sets.newHashSet((Object[])new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});
        private final List<Field> itemStackFields = new ArrayList<Field>();
        private final List<Field> itemFields = new ArrayList<Field>();
        private final List<Field> numberFields = new ArrayList<Field>();

        private LootEntryFields(Class<? extends LootEntry> lootEntryClass) {
            AccessibleObject[] allFields = lootEntryClass.getDeclaredFields();
            Field.setAccessible(allFields, true);
            for (AccessibleObject field : allFields) {
                if (Modifier.isStatic(((Field)field).getModifiers())) continue;
                if (((Field)field).getType() == ItemStack.class) {
                    this.itemStackFields.add((Field)field);
                    continue;
                }
                if (Item.class.isAssignableFrom(((Field)field).getType())) {
                    this.itemFields.add((Field)field);
                    continue;
                }
                if (!PRIMITIVE_NUMBER_CLASSES.contains(((Field)field).getType())) continue;
                this.numberFields.add((Field)field);
            }
        }

        static LootEntryFields forClass(Class<? extends LootEntry> lootEntryClass) {
            return KNOWN_ENTRY_TYPES.computeIfAbsent(lootEntryClass, k -> new LootEntryFields(lootEntryClass));
        }

        void serialise(JsonObject json, LootEntry entry) {
            if (this.itemStackFields.isEmpty() && this.itemFields.isEmpty()) {
                return;
            }
            JsonObject fields = new JsonObject();
            for (Field field : this.itemStackFields) {
                try {
                    JsonObject fieldRepr = new JsonObject();
                    ItemStack stack = (ItemStack)field.get(entry);
                    fieldRepr.addProperty("item", stack.func_77973_b().getRegistryName().toString());
                    if (stack.func_190916_E() != 1) {
                        fieldRepr.addProperty("count", (Number)stack.func_190916_E());
                    }
                    if (stack.func_77960_j() != 0) {
                        fieldRepr.addProperty("metadata", (Number)stack.func_77960_j());
                    }
                    if (stack.func_77942_o()) {
                        fieldRepr.addProperty("nbt", stack.func_77978_p().toString());
                    }
                    fields.add(field.getName(), (JsonElement)fieldRepr);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.error("Could not access loot entry's itemstack field", (Throwable)e);
                }
            }
            for (Field field : this.itemFields) {
                try {
                    Item item = (Item)field.get(entry);
                    fields.addProperty(field.getName(), item.getRegistryName().toString());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.error("Could not access loot entry's item field", (Throwable)e);
                }
            }
            for (Field field : this.numberFields) {
                try {
                    fields.addProperty(field.getName(), (Number)field.get(entry));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.error("Could not access loot entry field", (Throwable)e);
                }
            }
            json.add("fields", (JsonElement)fields);
        }
    }
}

