/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript.wrapper;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import leviathan143.loottweaker.common.lib.LootTableFinder;
import leviathan143.loottweaker.common.lib.RandomValueRanges;
import leviathan143.loottweaker.common.mutable_loot.MutableLootPool;
import leviathan143.loottweaker.common.mutable_loot.MutableLootTable;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntry;
import leviathan143.loottweaker.common.zenscript.LootTweakerContext;
import leviathan143.loottweaker.common.zenscript.wrapper.ZenLootPoolWrapper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="loottweaker.LootTable")
public class ZenLootTableWrapper {
    private final ResourceLocation id;
    private final List<LootTableTweaker> tweaks = new ArrayList<LootTableTweaker>();
    private final Map<String, ZenLootPoolWrapper> tweakedPools = new HashMap<String, ZenLootPoolWrapper>();
    private final LootTweakerContext context;

    public ZenLootTableWrapper(LootTweakerContext context, ResourceLocation id) {
        this.context = context;
        this.id = id;
    }

    @ZenMethod
    public ZenLootPoolWrapper getPool(String poolName) {
        if (this.tweakedPools.containsKey(poolName)) {
            return this.tweakedPools.get(poolName);
        }
        ZenLootPoolWrapper pool = this.context.wrapPool(this.id, poolName);
        this.tweakedPools.put(poolName, pool);
        this.enqueueTweaker(table -> {
            MutableLootPool targetPool = table.getPool(poolName);
            if (targetPool != null) {
                pool.tweak(targetPool);
            } else {
                this.context.getErrorHandler().error("No loot pool with name %s exists in table %s!", poolName, this.id);
            }
        }, "Retrieved pool %s from table %s", poolName, this.id);
        return pool;
    }

    @ZenMethod
    public ZenLootPoolWrapper addPool(String poolName, float minRolls, float maxRolls, float minBonusRolls, float maxBonusRolls) {
        ZenLootPoolWrapper pool = this.context.wrapPool(this.id, poolName);
        this.enqueueTweaker(table -> {
            MutableLootPool existing = table.getPool(poolName);
            if (existing != null) {
                this.context.getErrorHandler().error("Cannot add pool '%s' to table '%s'. Pool names must be unique within their table.", poolName, this.id);
                return;
            }
            MutableLootPool newPool = new MutableLootPool(poolName, new HashMap<String, MutableLootEntry>(), new ArrayList<LootCondition>(), RandomValueRanges.checked(this.context.getErrorHandler(), minRolls, maxRolls), RandomValueRanges.checked(this.context.getErrorHandler(), minBonusRolls, maxBonusRolls));
            pool.tweak(newPool);
            table.addPool(newPool);
            CraftTweakerAPI.logInfo((String)String.format("Added new pool %s to table %s", poolName, this.id));
        }, "Queued pool %s for addition to table %s", poolName, this.id);
        if (this.tweakedPools.putIfAbsent(poolName, pool) != null) {
            this.context.getErrorHandler().error("Cannot add pool '%s' to table '%s'. Pool names must be unique within their table.", poolName, this.id);
            return pool;
        }
        return pool;
    }

    @ZenMethod
    public void removePool(String poolName) {
        this.enqueueTweaker(table -> {
            if (table.getPool(poolName) == null) {
                this.context.getErrorHandler().error("No loot pool with name %s exists in table %s!", poolName, this.id);
                return;
            }
            table.removePool(poolName);
        }, "Queued pool %s of table %s for removal", poolName, this.id);
    }

    @ZenMethod
    public void clear() {
        this.enqueueTweaker(MutableLootTable::clearPools, "Queued all pools of table %s for removal", this.id);
    }

    private void enqueueTweaker(LootTableTweaker tweaker, String format, Object ... args) {
        this.tweaks.add(tweaker);
        CraftTweakerAPI.logInfo((String)String.format(format, args));
    }

    public void applyTweakers(MutableLootTable mutableTable) {
        for (LootTableTweaker tweaker : this.tweaks) {
            tweaker.tweak(mutableTable);
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isValid() {
        return LootTableFinder.DEFAULT.exists(this.id) || LootTableList.func_186374_a().contains(this.id);
    }

    @FunctionalInterface
    public static interface LootTableTweaker {
        public void tweak(MutableLootTable var1);
    }
}

